/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Source;

public class BinaryNode
extends UnaryNode {
    protected Node lhs;

    public BinaryNode(Source source, long token, Node lhs, Node rhs) {
        super(source, token, rhs);
        this.start = lhs.getStart();
        this.finish = rhs.getFinish();
        this.lhs = lhs;
    }

    protected BinaryNode(BinaryNode binaryNode, Node.CopyState cs) {
        super(binaryNode, cs);
        this.lhs = cs.existingOrCopy(binaryNode.lhs);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new BinaryNode(this, cs);
    }

    @Override
    public Type getWidestOperationType() {
        switch (this.tokenType()) {
            case SHR: 
            case ASSIGN_SHR: {
                return Type.LONG;
            }
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case SAR: 
            case SHL: {
                return Type.INT;
            }
            case DIV: 
            case MOD: 
            case MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: {
                return Type.NUMBER;
            }
        }
        return Type.OBJECT;
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case ASSIGN_SHR: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: 
            case ASSIGN: 
            case ASSIGN_ADD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment() && this.tokenType() != TokenType.ASSIGN;
    }

    @Override
    public Node getAssignmentDest() {
        return this.isAssignment() ? this.lhs() : null;
    }

    @Override
    public void setAssignmentDest(Node node) {
        this.setLHS(node);
    }

    @Override
    public Node getAssignmentSource() {
        return this.rhs();
    }

    @Override
    public void setAssignmentSource(Node source) {
        this.setRHS(source);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.lhs.equals(((BinaryNode)other).lhs());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.lhs().hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.lhs = this.lhs.accept(visitor);
            this.rhs = this.rhs.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        TokenType type = this.tokenType();
        boolean lhsParen = type.needsParens(this.lhs().tokenType(), true);
        boolean rhsParen = type.needsParens(this.rhs().tokenType(), false);
        if (lhsParen) {
            sb.append('(');
        }
        this.lhs().toString(sb);
        if (lhsParen) {
            sb.append(')');
        }
        sb.append(' ');
        switch (type) {
            case COMMALEFT: {
                sb.append(",<");
                break;
            }
            case COMMARIGHT: {
                sb.append(",>");
                break;
            }
            case INCPREFIX: 
            case DECPREFIX: {
                sb.append("++");
                break;
            }
            default: {
                sb.append(type.getName());
            }
        }
        sb.append(' ');
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
    }

    public Node lhs() {
        return this.lhs;
    }

    public void setLHS(Node lhs) {
        this.lhs = lhs;
    }
}

