/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.IdentityHashMap;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Location;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.runtime.Source;

public abstract class Node
extends Location {
    private Symbol symbol;
    protected int start;
    protected int finish;
    private boolean isResolved;
    private boolean isTerminal;
    private boolean hasGoto;
    private boolean shouldDiscard;

    public Node(Source source, long token, int finish) {
        super(source, token);
        this.start = Token.descPosition(token);
        this.finish = finish;
    }

    protected Node(Node node) {
        super(node);
        this.symbol = node.symbol;
        this.isResolved = node.isResolved;
        this.isTerminal = node.isTerminal;
        this.hasGoto = node.hasGoto;
        this.shouldDiscard = node.shouldDiscard;
        this.start = node.start;
        this.finish = node.finish;
    }

    public boolean hasType() {
        return this.getSymbol() != null;
    }

    public Type getType() {
        assert (this.hasType()) : this + " has no type";
        return this.symbol.getSymbolType();
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isLoop() {
        return false;
    }

    public boolean isAssignment() {
        return false;
    }

    public boolean isSelfModifying() {
        return false;
    }

    public Type getWidestOperationType() {
        return Type.OBJECT;
    }

    public boolean testResolved() {
        if (this.isResolved()) {
            return true;
        }
        this.setIsResolved();
        return false;
    }

    public boolean isDebug() {
        return false;
    }

    @Override
    public final Node clone() {
        return this.copy(new CopyState());
    }

    protected Node copy(CopyState cs) {
        return cs.existingOrCopy(this);
    }

    public abstract Node accept(NodeVisitor var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public abstract void toString(StringBuilder var1);

    public boolean hasTerminalFlags() {
        return this.isTerminal || this.hasGoto;
    }

    public void copyTerminalFlags(Node other) {
        this.isTerminal = other.isTerminal;
        this.hasGoto = other.hasGoto;
    }

    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    public void setDiscard(boolean shouldDiscard) {
        this.shouldDiscard = shouldDiscard;
    }

    public int getFinish() {
        return this.finish;
    }

    public void setFinish(int finish) {
        this.finish = finish;
    }

    public boolean hasGoto() {
        return this.hasGoto;
    }

    public void setHasGoto() {
        this.hasGoto = true;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved() {
        this.isResolved = true;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public void setIsTerminal(boolean isTerminal) {
        this.isTerminal = isTerminal;
    }

    public static final class CopyState {
        private final IdentityHashMap<Node, Node> cloneMap = new IdentityHashMap();

        public Node existingOrCopy(Node node) {
            if (node != null) {
                Node copy = this.cloneMap.get(node);
                if (copy == null) {
                    copy = node.copy(this);
                    this.cloneMap.put(node, copy);
                }
                return copy;
            }
            return node;
        }

        public Node existingOrSame(Node node) {
            if (node != null) {
                Node copy = this.cloneMap.get(node);
                if (copy == null) {
                    copy = node;
                }
                return copy;
            }
            return node;
        }
    }
}

