/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.SpecializedFunction;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.GlobalFunctions;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;

@ScriptClass(value="Math")
public final class NativeMath
extends ScriptObject {
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double E = Math.E;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double LN10 = 2.302585092994046;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double LN2 = 0.6931471805599453;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double LOG2E = 1.4426950408889634;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double LOG10E = 0.4342944819032518;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double PI = Math.PI;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double SQRT1_2 = 0.7071067811865476;
    @Property(attributes=7, where=Where.CONSTRUCTOR)
    public static final double SQRT2 = 1.4142135623730951;

    NativeMath() {
        this.setProto(Global.objectPrototype());
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object abs(Object self, Object x) {
        return Math.abs(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static int abs(Object self, int x) {
        return Math.abs(x);
    }

    @SpecializedFunction
    public static long abs(Object self, long x) {
        return Math.abs(x);
    }

    @SpecializedFunction
    public static double abs(Object self, double x) {
        return Math.abs(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object acos(Object self, Object x) {
        return Math.acos(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double acos(Object self, double x) {
        return Math.acos(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object asin(Object self, Object x) {
        return Math.asin(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double asin(Object self, double x) {
        return Math.asin(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object atan(Object self, Object x) {
        return Math.atan(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double atan(Object self, double x) {
        return Math.atan(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object atan2(Object self, Object y, Object x) {
        return Math.atan2(JSType.toNumber(y), JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double atan2(Object self, double y, double x) {
        return Math.atan2(y, x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object ceil(Object self, Object x) {
        return Math.ceil(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static int ceil(Object self, int x) {
        return x;
    }

    @SpecializedFunction
    public static long ceil(Object self, long x) {
        return x;
    }

    @SpecializedFunction
    public static double ceil(Object self, double x) {
        return Math.ceil(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object cos(Object self, Object x) {
        return Math.cos(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double cos(Object self, double x) {
        return Math.cos(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object exp(Object self, Object x) {
        return Math.exp(JSType.toNumber(x));
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object floor(Object self, Object x) {
        return Math.floor(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static int floor(Object self, int x) {
        return x;
    }

    @SpecializedFunction
    public static long floor(Object self, long x) {
        return x;
    }

    @SpecializedFunction
    public static double floor(Object self, double x) {
        return Math.floor(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object log(Object self, Object x) {
        return Math.log(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double log(Object self, double x) {
        return Math.log(x);
    }

    @Function(arity=2, attributes=2, where=Where.CONSTRUCTOR)
    public static Object max(Object self, Object ... args) {
        switch (args.length) {
            case 0: {
                return Double.NEGATIVE_INFINITY;
            }
            case 1: {
                return JSType.toNumber(args[0]);
            }
        }
        double res = JSType.toNumber(args[0]);
        for (int i = 1; i < args.length; ++i) {
            res = Math.max(res, JSType.toNumber(args[i]));
        }
        return res;
    }

    @SpecializedFunction
    public static double max(Object self) {
        return Double.NEGATIVE_INFINITY;
    }

    @SpecializedFunction
    public static int max(Object self, int x, int y) {
        return Math.max(x, y);
    }

    @SpecializedFunction
    public static long max(Object self, long x, long y) {
        return Math.max(x, y);
    }

    @SpecializedFunction
    public static double max(Object self, double x, double y) {
        return Math.max(x, y);
    }

    @Function(arity=2, attributes=2, where=Where.CONSTRUCTOR)
    public static Object min(Object self, Object ... args) {
        switch (args.length) {
            case 0: {
                return Double.POSITIVE_INFINITY;
            }
            case 1: {
                return JSType.toNumber(args[0]);
            }
        }
        double res = JSType.toNumber(args[0]);
        for (int i = 1; i < args.length; ++i) {
            res = Math.min(res, JSType.toNumber(args[i]));
        }
        return res;
    }

    @SpecializedFunction
    public static double min(Object self) {
        return Double.POSITIVE_INFINITY;
    }

    @SpecializedFunction
    public static int min(Object self, int x, int y) {
        return Math.min(x, y);
    }

    @SpecializedFunction
    public static long min(Object self, long x, long y) {
        return Math.min(x, y);
    }

    @SpecializedFunction
    public static double min(Object self, double x, double y) {
        return Math.min(x, y);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object pow(Object self, Object x, Object y) {
        return Math.pow(JSType.toNumber(x), JSType.toNumber(y));
    }

    @SpecializedFunction
    public static double pow(Object self, double x, double y) {
        return Math.pow(x, y);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object random(Object self) {
        return Math.random();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object round(Object self, Object x) {
        if (GlobalFunctions.isNaN(self, x)) {
            return Double.NaN;
        }
        if (!GlobalFunctions.isFinite(self, x)) {
            return x;
        }
        return Math.round(JSType.toNumber(x));
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object sin(Object self, Object x) {
        return Math.sin(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double sin(Object self, double x) {
        return Math.sin(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object sqrt(Object self, Object x) {
        return Math.sqrt(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double sqrt(Object self, double x) {
        return Math.sqrt(x);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object tan(Object self, Object x) {
        return Math.tan(JSType.toNumber(x));
    }

    @SpecializedFunction
    public static double tan(Object self, double x) {
        return Math.tan(x);
    }
}

