/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.ArrayDeque;

public class ConsString
implements CharSequence {
    private CharSequence left;
    private CharSequence right;
    private final int length;
    private boolean flat = false;

    public ConsString(CharSequence left, CharSequence right) {
        assert (left instanceof String || left instanceof ConsString);
        assert (right instanceof String || right instanceof ConsString);
        this.left = left;
        this.right = right;
        this.length = left.length() + right.length();
    }

    @Override
    public String toString() {
        if (!this.flat) {
            this.flatten();
        }
        return (String)this.left;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (!this.flat) {
            this.flatten();
        }
        return this.left.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (!this.flat) {
            this.flatten();
        }
        return this.left.subSequence(start, end);
    }

    private void flatten() {
        char[] chars = new char[this.length];
        int pos = this.length;
        ArrayDeque<CharSequence> stack = new ArrayDeque<CharSequence>();
        stack.addFirst(this.left);
        CharSequence cs = this.right;
        do {
            if (cs instanceof ConsString) {
                ConsString cons = (ConsString)cs;
                stack.addFirst(cons.left);
                cs = cons.right;
                continue;
            }
            String str = (String)cs;
            str.getChars(0, str.length(), chars, pos -= str.length());
            CharSequence charSequence = cs = stack.isEmpty() ? null : (CharSequence)stack.pollFirst();
        } while (cs != null);
        this.left = new String(chars);
        this.right = "";
        this.flat = true;
    }
}

