/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.PlatformManager;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.ios.DeviceDebugTransport;
import org.netbeans.modules.cordova.platforms.ios.IOSActionProvider;
import org.netbeans.modules.cordova.platforms.ios.IOSConfigurationPanel;
import org.netbeans.modules.cordova.platforms.ios.SimulatorDebugTransport;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.spi.project.ActionProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public enum IOSDevice implements Device
{
    IPHONE("iPhone", "--family iphone", true),
    IPHONE_RETINA("iPhone (Retina)", "--family iphone --retina", true),
    IPAD("iPad", "--family ipad", true),
    IPAD_RETINA("iPad (Retina)", "--family ipad --retina", true),
    CONNECTED("Connected Device", "", false);

    String displayName;
    String args;
    private boolean simulator;
    private static boolean ios_sim_bug;
    private Logger LOG = Logger.getLogger(IOSDevice.class.getName());

    private IOSDevice(String name, String args, boolean simulator) {
        this.displayName = name;
        this.args = args;
        this.simulator = simulator;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getArgs() {
        return this.args;
    }

    public boolean isEmulator() {
        return this.simulator;
    }

    public MobilePlatform getPlatform() {
        return PlatformManager.getPlatform((String)"ios");
    }

    public void addProperties(Properties props) {
        props.put("ios.sim.exec", this.getPlatform().getSimulatorPath());
        props.put("ios.device.args", this.getArgs());
    }

    public ActionProvider getActionProvider(Project p) {
        return new IOSActionProvider(p);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer(Project project, PropertyProvider aThis) {
        return new IOSConfigurationPanel.IOSConfigurationCustomizer(project, aThis);
    }

    public void openUrl(String url) {
        if (!this.simulator) {
            return;
        }
        try {
            if (ios_sim_bug) {
                return;
            }
            try {
                ProcessUtilities.callProcess((String)"killall", (boolean)true, (int)30000, (String[])new String[]{"MobileSafari"});
            }
            catch (IOException ex) {
                // empty catch block
            }
            String simctlList = ProcessUtilities.callProcess((String)"xcrun", (boolean)true, (int)30000, (String[])new String[]{"simctl", "list"});
            if (!simctlList.contains("Booted")) {
                String sim = InstalledFileLocator.getDefault().locate("bin/ios-sim", "org.netbeans.modules.cordova.platforms.ios", false).getPath();
                ProcessUtilities.callProcess((String)sim, (boolean)true, (int)30000, (String[])new String[]{"start", "--exit"});
                Thread.sleep(10000L);
            }
            String retVal = ProcessUtilities.callProcess((String)"xcrun", (boolean)true, (int)30000, (String[])new String[]{"simctl", "openurl", "booted", url});
            this.LOG.finest(retVal);
        }
        catch (IOException | InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            ios_sim_bug = true;
        }
    }

    private String getIPhoneSimName() {
        return this.getPlatform().getPrefferedTarget().getIdentifier().replace("p", "P").replace("s", "S");
    }

    public MobileDebugTransport getDebugTransport() {
        if (this.simulator) {
            return new SimulatorDebugTransport();
        }
        return new DeviceDebugTransport();
    }

    public boolean isWebViewDebugSupported() {
        return true;
    }
}

