/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.EventQueue;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.DiffTopComponent;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.util.ClientCheckSupport;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DiffAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/diff.png";

    public DiffAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Diff";
    }

    @Override
    protected int getFileEnabledStatus() {
        return this.getDirectoryEnabledStatus();
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    public static void diff(final Context ctx, final int type, final String contextName, final boolean initialStatusRefreshDisabled) {
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                SVNUrl repositoryUrl = null;
                SVNUrl fileUrl = null;
                RepositoryFile left = null;
                RepositoryFile right = null;
                File[] roots = SvnUtils.getActionRoots(ctx, false);
                if (roots != null) {
                    try {
                        File interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
                        repositoryUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
                        fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
                    }
                    catch (SVNClientException ex) {
                        Subversion.LOG.log(Level.INFO, null, ex);
                    }
                }
                if (repositoryUrl != null && fileUrl != null) {
                    if (type == 0) {
                        left = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.BASE);
                        right = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.WORKING);
                    } else if (type == 1) {
                        left = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.HEAD);
                        right = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.BASE);
                    } else {
                        left = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.HEAD);
                        right = new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.WORKING);
                    }
                }
                final SVNUrl fRepositoryUrl = repositoryUrl;
                final SVNUrl fFileUrl = fileUrl;
                final RepositoryFile fLeft = left;
                final RepositoryFile fRight = right;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiDiffPanel panel = new MultiDiffPanel(ctx, type, contextName, initialStatusRefreshDisabled, fRepositoryUrl, fFileUrl, fLeft, fRight);
                        DiffTopComponent tc = new DiffTopComponent(panel);
                        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
                        tc.open();
                        tc.requestActive();
                    }
                });
            }
        });
    }

    public static void diff(File file, String rev1, String rev2) {
        MultiDiffPanel panel = new MultiDiffPanel(file, rev1, rev2, false);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }

    public static void diff(File file, ISVNStatus status) {
        MultiDiffPanel panel = new MultiDiffPanel(file, status);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        ClientCheckSupport.getInstance().runInAWTIfAvailable(ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

            @Override
            public void run() {
                Context ctx = DiffAction.this.getContext(nodes);
                String contextName = DiffAction.this.getContextDisplayName(nodes);
                DiffAction.diff(ctx, SvnModuleConfig.getDefault().getLastUsedModificationContext(), contextName, DiffAction.isSvnNodes(nodes));
            }
        });
    }

    private static boolean isSvnNodes(Node[] nodes) {
        boolean fromSubversionView = true;
        for (Node node : nodes) {
            if (node instanceof SyncFileNode) continue;
            fromSubversionView = false;
            break;
        }
        return fromSubversionView;
    }

    public static class DiffToRepositoryAction
    extends ContextAction {
        @Override
        protected String getBaseName(Node[] nodes) {
            return "CTL_MenuItem_DiffToRepository";
        }

        @Override
        protected int getFileEnabledStatus() {
            return this.getDirectoryEnabledStatus();
        }

        @Override
        protected int getDirectoryEnabledStatus() {
            return -4;
        }

        @Override
        protected void performContextAction(final Node[] nodes) {
            ClientCheckSupport.getInstance().runInAWTIfAvailable(ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

                @Override
                public void run() {
                    Context ctx = DiffToRepositoryAction.this.getContext(nodes);
                    String contextName = DiffToRepositoryAction.this.getContextDisplayName(nodes);
                    DiffAction.diff(ctx, 2, contextName, DiffAction.isSvnNodes(nodes));
                }
            });
        }
    }

    public static class DiffToBaseAction
    extends ContextAction {
        @Override
        protected String getBaseName(Node[] nodes) {
            return "CTL_MenuItem_DiffToBase";
        }

        @Override
        protected int getFileEnabledStatus() {
            return this.getDirectoryEnabledStatus();
        }

        @Override
        protected int getDirectoryEnabledStatus() {
            return -4;
        }

        @Override
        protected void performContextAction(final Node[] nodes) {
            ClientCheckSupport.getInstance().runInAWTIfAvailable(ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

                @Override
                public void run() {
                    Context ctx = DiffToBaseAction.this.getContext(nodes);
                    String contextName = DiffToBaseAction.this.getContextDisplayName(nodes);
                    DiffAction.diff(ctx, 0, contextName, DiffAction.isSvnNodes(nodes));
                }
            });
        }
    }
}

