/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.config.WLApplicationModule;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLMessageDestination;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WebApplicationModel;
import org.netbeans.modules.j2ee.weblogic9.deploy.AbstractDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTargetModuleID;
import org.netbeans.modules.j2ee.weblogic9.optional.NonProxyHostsHelper;
import org.netbeans.modules.j2ee.weblogic9.ui.FailedAuthenticationSupport;
import org.netbeans.modules.weblogic.common.api.BatchDeployListener;
import org.netbeans.modules.weblogic.common.api.DeployListener;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicDeployer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class CommandBasedDeployer
extends AbstractDeployer {
    private static final Logger LOGGER = Logger.getLogger(CommandBasedDeployer.class.getName());
    private static final RequestProcessor URL_WAIT_RP = new RequestProcessor("Weblogic URL Wait", 10);
    private static final Callable<String> NON_PROXY = new Callable<String>(){

        @Override
        public String call() throws Exception {
            return NonProxyHostsHelper.getNonProxyHosts();
        }
    };

    public CommandBasedDeployer(WLDeploymentManager deploymentManager) {
        super(deploymentManager);
    }

    public ProgressObject directoryDeploy(Target target, String name, File file, String host, String port, boolean secured, J2eeModule.Type type) {
        return this.deploy(CommandBasedDeployer.createModuleId(target, file, host, port, secured, name, type), file, name);
    }

    public ProgressObject directoryRedeploy(TargetModuleID moduleId) {
        return this.redeploy(new TargetModuleID[]{moduleId}, null);
    }

    public ProgressObject deploy(Target[] target, File file, File plan, String host, String port, boolean secured) {
        String name = file.getName();
        if (name.endsWith(".war") || name.endsWith(".ear")) {
            name = name.substring(0, name.length() - 4);
        }
        WLTargetModuleID moduleId = CommandBasedDeployer.createModuleId(target[0], file, host, port, secured, name, null);
        return this.deploy(moduleId, file, null);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) {
        return this.redeploy(targetModuleID, file);
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        final LinkedHashMap<String, TargetModuleID> names = new LinkedHashMap<String, TargetModuleID>();
        for (TargetModuleID id : targetModuleID) {
            names.put(id.getModuleID(), id);
        }
        BatchDeployListener listener = new BatchDeployListener(){
            private TargetModuleID module;

            public void onStepStart(String name) {
                this.module = (TargetModuleID)names.get(name);
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeploying", (Object)name)));
            }

            public void onStepFinish(String name) {
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Started")));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Undeployment_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.undeploy(names.keySet(), listener);
        return progress;
    }

    public ProgressObject start(TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        final LinkedHashMap<String, TargetModuleID> names = new LinkedHashMap<String, TargetModuleID>();
        for (TargetModuleID id : targetModuleID) {
            names.put(id.getModuleID(), id);
        }
        BatchDeployListener listener = new BatchDeployListener(){
            private TargetModuleID module;

            public void onStepStart(String name) {
                this.module = (TargetModuleID)names.get(name);
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Starting", (Object)name)));
            }

            public void onStepFinish(String name) {
                try {
                    CommandBasedDeployer.waitForUrlReady(CommandBasedDeployer.this.getDeploymentManager(), this.module, progress);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Started")));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Start_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.start(names.keySet(), listener);
        return progress;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleID) {
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        final LinkedHashMap<String, TargetModuleID> names = new LinkedHashMap<String, TargetModuleID>();
        for (TargetModuleID id : targetModuleID) {
            names.put(id.getModuleID(), id);
        }
        BatchDeployListener listener = new BatchDeployListener(){
            private TargetModuleID module;

            public void onStepStart(String name) {
                this.module = (TargetModuleID)names.get(name);
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stopping", (Object)name)));
            }

            public void onStepFinish(String name) {
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Started")));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Stop_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.stop(names.keySet(), listener);
        return progress;
    }

    public ProgressObject deployDatasource(Collection<WLDatasource> datasources) {
        return this.deployApplicationModules(datasources, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Datasource"));
    }

    public ProgressObject deployMessageDestinations(Collection<WLMessageDestination> destinations) {
        return this.deployApplicationModules(destinations, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_JMS"));
    }

    private ProgressObject deployApplicationModules(Collection<? extends WLApplicationModule> modules, final String moduleDisplayName) {
        final String upperDisplayName = moduleDisplayName.length() <= 0 ? moduleDisplayName : Character.toUpperCase(moduleDisplayName.charAt(0)) + moduleDisplayName.substring(1);
        final WLProgressObject progress = new WLProgressObject(new TargetModuleID[0]);
        BatchDeployListener listener = new BatchDeployListener(){

            public void onStepStart(String name) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Deploying", (Object[])new Object[]{moduleDisplayName, name})));
            }

            public void onStepFinish(String name) {
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Started", (Object)upperDisplayName)));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Completed", (Object)upperDisplayName)));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Failed", (Object[])new Object[]{upperDisplayName, line})));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Failed_Timeout", (Object)upperDisplayName)));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Failed_Interrupted", (Object)upperDisplayName)));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Module_Failed_With_Message", (Object[])new Object[]{upperDisplayName, ex.getLocalizedMessage()})));
            }
        };
        ArrayList<WebLogicDeployer.Artifact> artifacts = new ArrayList<WebLogicDeployer.Artifact>(modules.size());
        for (WLApplicationModule wLApplicationModule : modules) {
            if (wLApplicationModule.getOrigin() == null) {
                LOGGER.log(Level.INFO, "Could not deploy {0}", wLApplicationModule.getName());
                continue;
            }
            artifacts.add(new WebLogicDeployer.Artifact(wLApplicationModule.getOrigin(), wLApplicationModule.getName(), false));
        }
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.deploy(artifacts, listener);
        return progress;
    }

    public ProgressObject deployLibraries(Set<File> libraries) {
        final WLProgressObject progress = new WLProgressObject(new TargetModuleID[0]);
        BatchDeployListener listener = new BatchDeployListener(){

            public void onStepStart(String name) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Deploying", (Object)name)));
            }

            public void onStepFinish(String name) {
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Started")));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Library_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        ArrayList<WebLogicDeployer.Artifact> artifacts = new ArrayList<WebLogicDeployer.Artifact>(libraries.size());
        for (File lib : libraries) {
            artifacts.add(new WebLogicDeployer.Artifact(lib, null, true));
        }
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.deploy(artifacts, listener);
        return progress;
    }

    private ProgressObject deploy(final TargetModuleID moduleId, final File file, String name) {
        final WLProgressObject progress = new WLProgressObject(moduleId);
        DeployListener listener = new DeployListener(){

            public void onStart() {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deploying", (Object)file.getAbsolutePath())));
            }

            public void onFinish() {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(moduleId, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Deployment_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        deployer.deploy(file, listener, name);
        return progress;
    }

    private ProgressObject redeploy(TargetModuleID[] targetModuleID, File file) {
        assert (file == null || targetModuleID.length == 1);
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        final LinkedHashMap<String, TargetModuleID> names = new LinkedHashMap<String, TargetModuleID>();
        for (TargetModuleID id : targetModuleID) {
            names.put(id.getModuleID(), id);
        }
        BatchDeployListener listener = new BatchDeployListener(){
            private TargetModuleID module;

            public void onStepStart(String name) {
                this.module = (TargetModuleID)names.get(name);
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeploying", (Object)name)));
            }

            public void onStepFinish(String name) {
            }

            public void onStart() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Started")));
            }

            public void onFinish() {
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Completed")));
            }

            public void onFail(String line) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed", (Object)line)));
                FailedAuthenticationSupport.checkFailedAuthentication(CommandBasedDeployer.this.getDeploymentManager(), line);
            }

            public void onTimeout() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Timeout")));
            }

            public void onInterrupted() {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Interrupted")));
            }

            public void onException(Exception ex) {
                progress.fireProgressEvent(this.module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_With_Message", (Object)ex.getMessage())));
            }
        };
        WebLogicDeployer deployer = WebLogicDeployer.getInstance((WebLogicConfiguration)this.getDeploymentManager().getCommonConfiguration(), (File)new File(this.getJavaBinary()), NON_PROXY);
        if (file != null) {
            deployer.redeploy(targetModuleID[0].getModuleID(), file, listener);
        } else {
            deployer.redeploy(new ArrayList(names.keySet()), listener);
        }
        return progress;
    }

    private String getJavaBinary() {
        FileObject folder;
        File file;
        String javaBinary;
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection folders = platform.getInstallFolders();
        String string = javaBinary = Utilities.isWindows() ? "java.exe" : "java";
        if (folders.size() > 0 && (file = FileUtil.toFile((FileObject)(folder = (FileObject)folders.iterator().next()))) != null) {
            javaBinary = file.getAbsolutePath() + File.separator + "bin" + File.separator + (Utilities.isWindows() ? "java.exe" : "java");
        }
        return javaBinary;
    }

    private static void waitForUrlReady(WLDeploymentManager dm, TargetModuleID moduleID, WLProgressObject progressObject) throws InterruptedException, TimeoutException {
        Thread.sleep(3000L);
        long start = System.currentTimeMillis();
        String webUrl = moduleID.getWebURL();
        if (webUrl == null) {
            TargetModuleID[] ch = moduleID.getChildTargetModuleID();
            if (ch != null) {
                for (int i = 0; i < ch.length; ++i) {
                    webUrl = ch[i].getWebURL();
                    if (webUrl == null) continue;
                    CommandBasedDeployer.waitForUrlReady(dm, webUrl, progressObject, start);
                }
            }
        } else {
            CommandBasedDeployer.waitForUrlReady(dm, webUrl, progressObject, start);
        }
    }

    private static void waitForUrlReady(WLDeploymentManager dm, String webUrl, WLProgressObject progressObject, long start) throws InterruptedException, TimeoutException {
        if (webUrl != null) {
            try {
                String realUrl = webUrl;
                if (dm.getCommonConfiguration().isSecured() && realUrl.startsWith("http:") && realUrl.contains(":" + dm.getPort() + "/")) {
                    realUrl = "https:" + realUrl.substring(5);
                }
                URL url = new URL(realUrl);
                String waitingMsg = NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                progressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
                int timeout = 1000;
                while (System.currentTimeMillis() - start < 300000L && !URLWait.waitForUrlReady(dm, (ExecutorService)URL_WAIT_RP, url, timeout)) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (timeout >= 30000) continue;
                    timeout = Math.min(30000, 2 * timeout);
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private static WLTargetModuleID createModuleId(Target target, File file, String host, String port, boolean secured, String name, J2eeModule.Type type) {
        WLTargetModuleID moduleId = new WLTargetModuleID(target, name, file);
        try {
            String serverUrl = (secured ? "https://" : "http://") + host + ":" + port;
            if (J2eeModule.Type.WAR.equals(type) || type == null && file.getName().endsWith(".war")) {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                if (fo != null) {
                    CommandBasedDeployer.configureWarModuleId(moduleId, fo, serverUrl);
                }
            } else if (J2eeModule.Type.EAR.equals(type) || type == null && file.getName().endsWith(".ear")) {
                CommandBasedDeployer.configureEarModuleId(moduleId, file, serverUrl);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureEarModuleId(WLTargetModuleID moduleId, File file, String serverUrl) {
        block15: {
            try {
                FileObject root = null;
                if (file.isDirectory()) {
                    root = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                } else {
                    JarFileSystem jfs = new JarFileSystem();
                    jfs.setJarFile(file);
                    root = jfs.getRoot();
                }
                if (root == null) {
                    return;
                }
                FileObject appXml = root.getFileObject("META-INF/application.xml");
                if (appXml != null) {
                    BufferedInputStream is = new BufferedInputStream(appXml.getInputStream());
                    try {
                        Application ear = DDProvider.getDefault().getDDRoot(new InputSource(is));
                        Module[] modules = ear.getModule();
                        for (int i = 0; i < modules.length; ++i) {
                            WLTargetModuleID childModuleId = null;
                            Web web = modules[i].getWeb();
                            childModuleId = web != null ? new WLTargetModuleID(moduleId.getTarget(), web.getWebUri()) : new WLTargetModuleID(moduleId.getTarget());
                            if (modules[i].getWeb() != null) {
                                String context = modules[i].getWeb().getContextRoot();
                                String contextUrl = CommandBasedDeployer.getContextUrl(serverUrl, context);
                                childModuleId.setContextURL(contextUrl);
                            }
                            moduleId.addChild(childModuleId);
                        }
                        break block15;
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                for (FileObject child : root.getChildren()) {
                    if (!child.hasExt("war") && !child.hasExt("jar")) continue;
                    WLTargetModuleID childModuleId = new WLTargetModuleID(moduleId.getTarget(), child.getNameExt());
                    if (child.hasExt("war")) {
                        CommandBasedDeployer.configureWarModuleId(childModuleId, child, serverUrl);
                    }
                    moduleId.addChild(childModuleId);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (PropertyVetoException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private static void configureWarModuleId(WLTargetModuleID moduleId, FileObject file, String serverUrl) {
        String contextUrl = CommandBasedDeployer.getContextUrl(serverUrl, CommandBasedDeployer.readWebContext(file));
        moduleId.setContextURL(contextUrl);
    }

    private static String getContextUrl(String serverUrl, String context) {
        StringBuilder builder = new StringBuilder(serverUrl);
        if (serverUrl.endsWith("/")) {
            builder.setLength(builder.length() - 1);
        }
        if (context != null) {
            if (!context.startsWith("/")) {
                LOGGER.log(Level.INFO, "Context path should start with forward slash while it is {0}", context);
                builder.append('/');
            }
            builder.append(context);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWebContext(FileObject file) {
        if (file.isFolder()) {
            FileObject weblogicXml = file.getFileObject("WEB-INF/weblogic.xml");
            if (weblogicXml == null) return "/" + file.getNameExt();
            if (!weblogicXml.isData()) return "/" + file.getNameExt();
            try {
                BufferedInputStream is = new BufferedInputStream(weblogicXml.getInputStream());
                try {
                    String string = WebApplicationModel.forInputStream(is).getContextRoot();
                    return string;
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return "/" + file.getNameExt();
        }
        try {
            ZipInputStream zis = new ZipInputStream(file.getInputStream());
            try {
                ZipEntry entry = null;
                do {
                    if ((entry = zis.getNextEntry()) == null) return "/" + file.getName();
                } while (!"WEB-INF/weblogic.xml".equals(entry.getName()));
                String string = WebApplicationModel.forInputStream(new ZipEntryInputStream(zis)).getContextRoot();
                return string;
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Error reading context-root", ex);
                return "/" + file.getName();
            }
            finally {
                zis.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return "/" + file.getName();
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zis) {
            this.zis = zis;
        }

        @Override
        public int available() throws IOException {
            return this.zis.available();
        }

        @Override
        public void close() throws IOException {
            this.zis.closeEntry();
        }

        @Override
        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.zis.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.zis.skip(n);
        }
    }
}

