/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class NonProxyHostsHelper {
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";

    private NonProxyHostsHelper() {
    }

    public static String getNonProxyHosts() {
        String hosts = NonProxyHostsHelper.getPreferences().get(NOT_PROXY_HOSTS, NonProxyHostsHelper.getDefaultUserNonProxyHosts());
        return NonProxyHostsHelper.compactNonProxyHosts(hosts);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/core");
    }

    private static String getDefaultUserNonProxyHosts() {
        return NonProxyHostsHelper.getModifiedNonProxyHosts(NonProxyHostsHelper.getSystemNonProxyHosts());
    }

    private static String getSystemNonProxyHosts() {
        String systemProxy = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return systemProxy == null ? "" : systemProxy;
    }

    private static String getPresetNonProxyHosts() {
        return System.getProperty(HTTP_NON_PROXY_HOSTS, "");
    }

    private static String getModifiedNonProxyHosts(String systemPreset) {
        String fromUser;
        String fromSystem = systemPreset.replaceAll(";", "|").replaceAll(",", "|");
        String string = fromUser = NonProxyHostsHelper.getPresetNonProxyHosts() == null ? "" : NonProxyHostsHelper.getPresetNonProxyHosts().replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            fromSystem = NonProxyHostsHelper.addReguralToNonProxyHosts(fromSystem);
        }
        String staticNonProxyHosts = "localhost|127.0.0.1";
        String nonProxy = NonProxyHostsHelper.concatProxies(fromUser, fromSystem, "localhost|127.0.0.1");
        try {
            String localhost = InetAddress.getLocalHost().getHostName();
            if (!"localhost".equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return NonProxyHostsHelper.compactNonProxyHosts(nonProxy);
    }

    private static String concatProxies(String ... proxies) {
        StringBuilder sb = new StringBuilder();
        for (String n : proxies) {
            if (n == null || (n = n.trim()).isEmpty()) continue;
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '|' && !n.startsWith("|")) {
                sb.append('|');
            }
            sb.append(n);
        }
        return sb.toString();
    }

    public static String compactNonProxyHosts(String hosts) {
        StringTokenizer st = new StringTokenizer(hosts, ",");
        StringBuilder nonProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String h = st.nextToken().trim();
            if (h.length() == 0) continue;
            if (nonProxyHosts.length() > 0) {
                nonProxyHosts.append("|");
            }
            nonProxyHosts.append(h);
        }
        st = new StringTokenizer(nonProxyHosts.toString(), "|");
        HashSet<String> set = new HashSet<String>();
        StringBuilder compactedProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!set.add(t.toLowerCase(Locale.US))) continue;
            if (compactedProxyHosts.length() > 0) {
                compactedProxyHosts.append('|');
            }
            compactedProxyHosts.append(t);
        }
        return compactedProxyHosts.toString();
    }

    private static String addReguralToNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        StringBuilder reguralProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf(42) == -1) {
                t = t + '*';
            }
            if (reguralProxyHosts.length() > 0) {
                reguralProxyHosts.append('|');
            }
            reguralProxyHosts.append(t);
        }
        return reguralProxyHosts.toString();
    }
}

