/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config.mdb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.jboss4.config.JBossMessageDestination;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.Depends;
import org.netbeans.modules.j2ee.jboss4.config.gen.Mbean;
import org.netbeans.modules.j2ee.jboss4.config.gen.Server;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MessageDestinationSupport {
    public static final String MSG_DEST_RESOURCE_NAME_JB4 = "jboss4-netbeans-destinations-service.xml";
    public static final String MSG_DEST_RESOURCE_NAME_JB5 = "jboss5-netbeans-destinations-service.xml";
    public static final String CONN_FACTORY_JNDI_NAME_JB4 = "ConnectionFactory";
    private File resourceDir;
    private Server destinationServiceModel;
    private File destinationsFile;
    private FileObject destinationsFO;

    public MessageDestinationSupport(File resourceDir) {
        this.resourceDir = resourceDir;
        this.destinationsFile = new File(resourceDir, MSG_DEST_RESOURCE_NAME_JB4);
        this.ensureDestinationsFOExists();
    }

    private void ensureDestinationsFOExists() {
        if (!this.destinationsFile.exists()) {
            return;
        }
        if (this.destinationsFO == null || !this.destinationsFO.isValid()) {
            this.destinationsFO = FileUtil.toFileObject((File)this.destinationsFile);
            assert (this.destinationsFO != null);
            this.destinationsFO.addFileChangeListener((FileChangeListener)new MessageDestinationFileListener());
        }
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        return MessageDestinationSupport.getMessageDestinations(this.getMessageDestinationModel(false));
    }

    private static Set<MessageDestination> getMessageDestinations(Server model) throws ConfigurationException {
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet<MessageDestination> destinations = new HashSet<MessageDestination>();
        for (Mbean mbean : model.getMbean()) {
            int nameIndex;
            String mbeanNameAttribute = mbean.getName();
            if (mbeanNameAttribute == null) continue;
            MessageDestination.Type type = null;
            if (mbeanNameAttribute.indexOf("service=Queue") > -1) {
                type = MessageDestination.Type.QUEUE;
            } else if (mbeanNameAttribute.indexOf("service=Topic") > -1) {
                type = MessageDestination.Type.TOPIC;
            }
            if (type == null || (nameIndex = mbeanNameAttribute.indexOf("name=")) == -1) continue;
            String name = mbeanNameAttribute.substring(nameIndex + 5);
            if (name.indexOf(",") > -1) {
                name = name.substring(0, name.indexOf(","));
            }
            destinations.add(new JBossMessageDestination(name, type));
        }
        return destinations;
    }

    private synchronized Server getMessageDestinationModel(boolean create) {
        block8: {
            try {
                if (this.destinationsFile.exists()) {
                    try {
                        if (this.destinationServiceModel == null) {
                            this.destinationServiceModel = Server.createGraph(this.destinationsFile);
                        }
                        break block8;
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                    break block8;
                }
                if (create) {
                    this.destinationServiceModel = new Server();
                    ResourceConfigurationHelper.writeFile(this.destinationsFile, this.destinationServiceModel);
                    this.ensureDestinationsFOExists();
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
                this.destinationServiceModel = null;
            }
        }
        return this.destinationServiceModel;
    }

    public MessageDestination createMessageDestination(String name, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
        if (!this.destinationsFile.exists()) {
            this.getMessageDestinationModel(true);
        }
        DataObject destinationsDO = null;
        try {
            destinationsDO = DataObject.find((FileObject)this.destinationsFO);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
            return null;
        }
        Server newDestinationServiceModel = null;
        StyledDocument doc = null;
        try {
            EditorCookie editor = (EditorCookie)destinationsDO.getCookie(EditorCookie.class);
            doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            byte[] docString = doc.getText(0, doc.getLength()).getBytes();
            newDestinationServiceModel = Server.createGraph(new ByteArrayInputStream(docString));
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotUpdateFile", (Object)this.destinationsFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
        catch (BadLocationException ble) {
            Logger.getLogger("global").log(Level.INFO, null, ble);
        }
        catch (RuntimeException e) {
            Server oldDestinationServiceModel = this.getMessageDestinationModel(true);
            if (oldDestinationServiceModel == null) {
                throw new ConfigurationException(NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlCannotParse", (Object)this.destinationsFile.getAbsolutePath()));
            }
            NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlNotValid", (Object)this.destinationsFile.getAbsolutePath()), 2);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
            if (result == NotifyDescriptor.CANCEL_OPTION) {
                return null;
            }
            newDestinationServiceModel = oldDestinationServiceModel;
        }
        JBossMessageDestination dest = this.modifyMessageDestinationModel(newDestinationServiceModel, name, type);
        boolean modified = destinationsDO.isModified();
        ResourceConfigurationHelper.replaceDocument(doc, newDestinationServiceModel);
        if (!modified) {
            SaveCookie cookie = (SaveCookie)destinationsDO.getCookie(SaveCookie.class);
            try {
                cookie.save();
            }
            catch (IOException ioe) {
                String msg = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotSaveFile", (Object)this.destinationsFile.getAbsolutePath());
                throw new ConfigurationException(msg, (Throwable)ioe);
            }
        }
        this.destinationServiceModel = newDestinationServiceModel;
        return dest;
    }

    private JBossMessageDestination modifyMessageDestinationModel(Server model, String name, MessageDestination.Type type) throws ConfigurationException {
        if (model == null) {
            return null;
        }
        for (MessageDestination destination : MessageDestinationSupport.getMessageDestinations(model)) {
            if (!name.equals(destination.getName()) || type != destination.getType()) continue;
            return null;
        }
        Depends depends = new Depends();
        depends.setOptionalAttributeName("DestinationManager");
        Mbean mbean = new Mbean();
        if (type == MessageDestination.Type.QUEUE) {
            mbean.setCode("org.jboss.mq.server.jmx.Queue");
            mbean.setName("jboss.mq.destination:service=Queue,name=" + name);
        } else if (type == MessageDestination.Type.TOPIC) {
            mbean.setCode("org.jboss.mq.server.jmx.Topic");
            mbean.setName("jboss.mq.destination:service=Topic,name=" + name);
        }
        mbean.addDepends(depends);
        model.addMbean(mbean);
        return new JBossMessageDestination(name, type);
    }

    private class MessageDestinationFileListener
    extends FileChangeAdapter {
        private MessageDestinationFileListener() {
        }

        public void fileChanged(FileEvent fe) {
            assert (fe.getSource() == MessageDestinationSupport.this.destinationsFO);
            MessageDestinationSupport.this.destinationServiceModel = null;
        }

        public void fileDeleted(FileEvent fe) {
            assert (fe.getSource() == MessageDestinationSupport.this.destinationsFO);
            MessageDestinationSupport.this.destinationServiceModel = null;
        }
    }
}

