/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.locks;

import java.awt.AWTKeyStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.LockCCTProvider;
import org.netbeans.lib.profiler.results.locks.LockRuntimeCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.locks.LockContentionRenderer;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public abstract class LockContentionPanel
extends DataView {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.locks.Bundle");
    private static final String ENABLE_LOCKS_MONITORING = messages.getString("LockContentionPanel_EnableLocksMonitoring");
    private static final String ENABLE_LOCKS_MONITORING_TOOLTIP = messages.getString("LockContentionPanel_EnableLocksMonitoringToolTip");
    private static final String NO_PROFILING = messages.getString("LockContentionPanel_NoProfiling");
    private static final String LOCKS_THREADS_COLUMN_NAME = messages.getString("LockContentionPanel_LocksThreadsColumnName");
    private static final String LOCKS_THREADS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_LocksThreadsColumnToolTip");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("LockContentionPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_TimeRelColumnToolTip");
    private static final String WAITS_COLUMN_NAME = messages.getString("LockContentionPanel_WaitsColumnName");
    private static final String WAITS_COLUMN_TOOLTIP = messages.getString("LockContentionPanel_WaitsColumnToolTip");
    private static final String DISPLAY_MODE = messages.getString("LockContentionPanel_DisplayMode");
    private static final String MODE_THREADS = messages.getString("LockContentionPanel_ModeThreads");
    private static final String MODE_MONITORS = messages.getString("LockContentionPanel_ModeMonitors");
    private final ProfilerToolbar toolbar;
    private final LocksTreeTableModel treeTableModel;
    private final ProfilerTreeTable treeTable;
    private final ProfilerTableContainer treeTablePanel;
    private final JComboBox modeCombo;
    private int columnCount;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private Aggregation aggregation = Aggregation.BY_THREADS;
    private final JPanel contentPanel;
    private final JPanel notificationPanel;
    private final JButton enableLockContentionButton;
    private final JLabel enableLockContentionLabel1;
    private final JLabel enableLockContentionLabel2;
    private LockRuntimeCCTNode root;
    private Listener cctListener;
    private long countsInMicrosec = 1L;
    private final HideableBarRenderer hbrTime;
    private final HideableBarRenderer hbrWaits;
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private long lastupdate;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LockContentionPanel() {
        this.toolbar = ProfilerToolbar.create(true);
        JLabel modeLabel = new JLabel(DISPLAY_MODE);
        modeLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.toolbar.add(modeLabel);
        this.modeCombo = new JComboBox(new Object[]{MODE_THREADS, MODE_MONITORS}){

            @Override
            protected void fireActionEvent() {
                super.fireActionEvent();
                LockContentionPanel.this.treeTable.clearSelection();
                LockContentionPanel.this.prepareResults();
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = this.getPreferredSize();
                dim.width += 20;
                return dim;
            }
        };
        this.modeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (MODE_THREADS.equals(value.toString())) {
                    dlcr.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
                } else if (MODE_MONITORS.equals(value.toString())) {
                    dlcr.setIcon(Icons.getIcon((String)"ProfilerIcons.WindowLocks"));
                }
                return dlcr;
            }
        });
        modeLabel.setLabelFor(this.modeCombo);
        this.toolbar.add(this.modeCombo);
        this.initColumnsData();
        this.treeTableModel = new LocksTreeTableModel();
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{0}){

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        LockContentionPanel.this.activateSearch();
                    }
                });
            }
        };
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.providePopupMenu(true);
        LockContentionRenderer lcRenderer = new LockContentionRenderer();
        this.treeTable.setTreeCellRenderer(lcRenderer);
        Long refTime = new Long(123456L);
        NumberPercentRenderer npr = new NumberPercentRenderer(new McsTimeRenderer());
        this.hbrTime = new HideableBarRenderer(npr);
        this.hbrTime.setMaxValue(refTime);
        this.treeTable.setColumnRenderer(1, this.hbrTime);
        this.treeTable.setDefaultColumnWidth(1, this.hbrTime.getOptimalWidth());
        this.hbrWaits = new HideableBarRenderer(new NumberRenderer());
        this.hbrWaits.setMaxValue(1234567L);
        this.treeTable.setColumnRenderer(2, this.hbrWaits);
        this.treeTable.setDefaultColumnWidth(2, this.hbrWaits.getMaxNoBarWidth());
        this.treeTable.setColumnToolTips(new String[]{LOCKS_THREADS_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, WAITS_COLUMN_TOOLTIP});
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, keys);
        this.treeTablePanel = new ProfilerTableContainer(this.treeTable, false, null);
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBackground(this.treeTable.getBackground());
        UIUtils.decorateProfilerPanel(this.notificationPanel);
        CompoundBorder myRolloverBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableLockContentionLabel1 = new JLabel(ENABLE_LOCKS_MONITORING);
        this.enableLockContentionLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableLockContentionLabel1.setForeground(Color.DARK_GRAY);
        this.enableLockContentionButton = new JButton(Icons.getIcon((String)"ProfilerIcons.ViewLocks32"));
        this.enableLockContentionButton.setToolTipText(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionButton.setContentAreaFilled(false);
        this.enableLockContentionButton.setMargin(new Insets(3, 3, 3, 3));
        this.enableLockContentionButton.setVerticalTextPosition(3);
        this.enableLockContentionButton.setHorizontalTextPosition(0);
        this.enableLockContentionButton.setRolloverEnabled(true);
        this.enableLockContentionButton.setBorder(myRolloverBorder);
        this.enableLockContentionButton.getAccessibleContext().setAccessibleName(ENABLE_LOCKS_MONITORING_TOOLTIP);
        this.enableLockContentionLabel2 = new JLabel(NO_PROFILING);
        this.enableLockContentionLabel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableLockContentionLabel2.setForeground(Color.DARK_GRAY);
        this.enableLockContentionLabel2.setVisible(false);
        this.notificationPanel.add(this.enableLockContentionLabel1);
        this.notificationPanel.add(this.enableLockContentionButton);
        this.notificationPanel.add(this.enableLockContentionLabel2);
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.notificationPanel, "DISABLED");
        this.contentPanel.add((Component)this.treeTablePanel, "ENABLED");
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.add((Component)this.contentPanel, "Center");
        this.prepareResults();
        this.registerActions();
    }

    protected abstract ProfilerClient getProfilerClient();

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockContentionPanel.this.activateSearch();
            }
        });
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    protected boolean hasBottomFilterFindMargin() {
        return true;
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.prepareResults();
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    private void refreshData(final LockRuntimeCCTNode appRootNode) {
        if ((this.lastupdate + 900L > System.currentTimeMillis() || this.paused) && !this.forceRefresh) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LockContentionPanel.this.root = appRootNode;
            }
        });
        this.prepareResults();
        this.forceRefresh = false;
    }

    public void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.lastupdate + 1400L < System.currentTimeMillis() && !this.paused || this.forceRefresh) {
            this.getProfilerClient().forceObtainedResultsDump(true);
        }
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LockContentionPanel.this.root = null;
                LockContentionPanel.this.treeTableModel.setRoot((TreeNode)LockCCTNode.EMPTY);
            }
        });
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        Component actionButton = this.toolbar.add(saveViewAction);
        this.toolbar.remove(actionButton);
        this.toolbar.add(actionButton, 0);
        this.toolbar.add(new JToolBar.Separator(), 1);
    }

    public void addExportAction(AbstractAction exportAction) {
        Component actionButton = this.toolbar.add(exportAction);
        this.toolbar.remove(actionButton);
        this.toolbar.add(actionButton, 0);
    }

    public void prepareResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LockContentionPanel.this.root == null) {
                    return;
                }
                LockCCTNode newRoot = null;
                switch (LockContentionPanel.this.aggregation) {
                    case BY_THREADS: {
                        newRoot = LockContentionPanel.this.root.getThreads();
                        break;
                    }
                    case BY_MONITORS: {
                        newRoot = LockContentionPanel.this.root.getMonitors();
                    }
                }
                LockContentionPanel.this.hbrTime.setMaxValue(LockContentionPanel.this.getTimeInMicroSec(newRoot));
                LockContentionPanel.this.hbrWaits.setMaxValue(newRoot.getWaits());
                LockContentionPanel.this.treeTableModel.setRoot((TreeNode)newRoot);
                LockContentionPanel.this.lastupdate = System.currentTimeMillis();
            }
        });
    }

    public void profilingSessionFinished() {
        this.enableLockContentionButton.setEnabled(false);
        this.enableLockContentionButton.setVisible(false);
        this.enableLockContentionLabel1.setVisible(false);
        this.enableLockContentionLabel2.setVisible(true);
        if (this.cctListener != null) {
            Collection locksCCTProviders = Lookup.getDefault().lookupAll(LockCCTProvider.class);
            assert (!locksCCTProviders.isEmpty());
            for (LockCCTProvider provider : locksCCTProviders) {
                provider.removeListener((CCTProvider.Listener)this.cctListener);
            }
            this.cctListener = null;
        }
    }

    public void profilingSessionStarted() {
        ProfilingSessionStatus session = TargetAppRunner.getDefault().getProfilingSessionStatus();
        this.countsInMicrosec = session.timerCountsInSecond[0] / 1000000L;
        if (this.cctListener == null) {
            this.cctListener = new Listener();
            Collection locksCCTProviders = Lookup.getDefault().lookupAll(LockCCTProvider.class);
            assert (!locksCCTProviders.isEmpty());
            for (LockCCTProvider provider : locksCCTProviders) {
                provider.addListener((CCTProvider.Listener)this.cctListener);
            }
        } else {
            this.treeTable.clearSelection();
            this.treeTableModel.setRoot((TreeNode)LockCCTNode.EMPTY);
        }
        this.enableLockContentionButton.setEnabled(true);
        this.enableLockContentionButton.setVisible(true);
        this.enableLockContentionLabel1.setVisible(true);
        this.enableLockContentionLabel2.setVisible(false);
    }

    public void lockContentionDisabled() {
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "DISABLED");
    }

    public void lockContentionEnabled() {
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, "ENABLED");
    }

    public void addLockContentionListener(ActionListener listener) {
        this.enableLockContentionButton.addActionListener(listener);
    }

    public void removeLockContentionListener(ActionListener listener) {
        this.enableLockContentionButton.removeActionListener(listener);
    }

    private long getTimeInMicroSec(LockCCTNode node) {
        return node.getTime() / this.countsInMicrosec;
    }

    private String getTimeInMillis(LockCCTNode node) {
        long microSec = this.getTimeInMicroSec(node);
        return StringUtils.mcsTimeToString((long)microSec);
    }

    private void initColumnsData() {
        this.columnCount = 3;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = LOCKS_THREADS_COLUMN_NAME;
        this.columnToolTips[0] = LOCKS_THREADS_COLUMN_TOOLTIP;
        this.columnNames[1] = TIME_REL_COLUMN_NAME;
        this.columnToolTips[1] = TIME_REL_COLUMN_TOOLTIP;
        this.columnNames[2] = WAITS_COLUMN_NAME;
        this.columnToolTips[2] = WAITS_COLUMN_TOOLTIP;
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = new LabelBracketTableCellRenderer(11);
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = new LabelTableCellRenderer(11);
    }

    public Component getToolbar() {
        return this.toolbar.getComponent();
    }

    private class LocksTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        private LocksTreeTableModel() {
            super((TreeNode)LockCCTNode.EMPTY);
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            return false;
        }

        @Override
        public Class getColumnClass(int column) {
            if (column == 0) {
                return JTree.class;
            }
            if (column == 1) {
                return Long.class;
            }
            if (column == 2) {
                return Long.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return LockContentionPanel.this.columnCount;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return LockContentionPanel.this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            LockCCTNode lnode = (LockCCTNode)node;
            switch (columnIndex) {
                case 0: {
                    return lnode;
                }
                case 1: {
                    return LockContentionPanel.this.getTimeInMicroSec(lnode);
                }
                case 2: {
                    return lnode.getWaits();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int column) {
        }
    }

    private class Listener
    implements LockCCTProvider.Listener {
        private Listener() {
        }

        public void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty && appRootNode instanceof LockRuntimeCCTNode) {
                LockContentionPanel.this.refreshData((LockRuntimeCCTNode)appRootNode);
            }
        }

        public void cctReset() {
            LockContentionPanel.this.resetData();
        }
    }

    public static enum Aggregation {
        BY_THREADS,
        BY_MONITORS;

    }
}

