/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.AllocTableView;
import org.netbeans.lib.profiler.ui.memory.AllocTreeTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTreeTableView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.memory.SampledTableView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class SnapshotMemoryView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotMemoryView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotMemoryView_ResetCompareSnapshots");
    private final MemoryView dataView;
    private int aggregation;
    private final Collection<String> filter;
    private final MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private JToggleButton compareButton;

    public SnapshotMemoryView(MemoryResultsSnapshot snapshot, Collection<String> filter, Action saveAction, final Action compareAction, Action infoAction, ExportUtils.Exportable exportProvider) {
        this.filter = filter;
        this.snapshot = snapshot;
        MemoryView.userFormClassNames(snapshot);
        this.setLayout(new BorderLayout());
        this.dataView = snapshot instanceof SampledMemoryResultsSnapshot ? new SampledTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotMemoryView.this.populatePopup(this, popup, value, userValue);
            }
        } : (snapshot instanceof AllocMemoryResultsSnapshot ? (snapshot.containsStacks() ? new AllocTreeTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotMemoryView.this.populatePopup(this, popup, value, userValue);
            }
        } : new AllocTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotMemoryView.this.populatePopup(this, popup, value, userValue);
            }
        }) : (snapshot instanceof LivenessMemoryResultsSnapshot ? (snapshot.containsStacks() ? new LivenessTreeTableView(null, filter == null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotMemoryView.this.populatePopup(this, popup, value, userValue);
            }
        } : new LivenessTableView(null, filter == null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                SnapshotMemoryView.this.populatePopup(this, popup, value, userValue);
            }
        }) : null));
        ProfilerToolbar toolbar = ProfilerToolbar.create(true);
        if (saveAction != null) {
            toolbar.add(saveAction);
        }
        toolbar.add(ExportUtils.exportButton(this, MemoryView.EXPORT_TOOLTIP, this.getExportables(exportProvider)));
        if (compareAction != null) {
            toolbar.addSpace(2);
            toolbar.addSeparator();
            toolbar.addSpace(2);
            Icon icon = (Icon)compareAction.getValue("SmallIcon");
            this.compareButton = new JToggleButton(icon){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    boolean sel = this.isSelected();
                    if (sel) {
                        compareAction.actionPerformed(e);
                        if (SnapshotMemoryView.this.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        SnapshotMemoryView.this.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            toolbar.add(this.compareButton);
        }
        if (infoAction != null) {
            toolbar.addFiller();
            toolbar.add(infoAction);
        }
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.add((Component)toolbar.getComponent(), "North");
        this.setAggregation(1);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotMemoryView.this.dataView.activateFilter();
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotMemoryView.this.dataView.activateSearch();
            }
        });
    }

    public void setRefSnapshot(MemoryResultsSnapshot snapshot) {
        MemoryView.userFormClassNames(snapshot);
        this.refSnapshot = snapshot;
        if (this.compareButton != null && snapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setAggregation(this.aggregation);
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    static boolean isSelectable(ClientUtils.SourceCodeSelection value, boolean method) {
        String className = value.getClassName();
        String methodName = value.getMethodName();
        if (method && methodName.endsWith("[native]")) {
            return false;
        }
        return !"org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) || !"traceVMObjectAlloc".equals(methodName);
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(MemoryView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null && SnapshotMemoryView.this.aggregation != 2);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SnapshotMemoryView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (userValue != null && !"*".equals(userValue.getMethodName())) {
            popup.add(new JMenuItem(MemoryView.ACTION_PROFILE_METHOD){
                {
                    super(x0);
                    this.setEnabled(SnapshotMemoryView.isSelectable(userValue, true));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SnapshotMemoryView.this.profileMethod(userValue);
                }
            });
        }
        popup.add(new JMenuItem(MemoryView.ACTION_PROFILE_CLASS){
            {
                super(x0);
                this.setEnabled(userValue != null && SnapshotMemoryView.this.aggregation != 2 && SnapshotMemoryView.isSelectable(userValue, false));
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SnapshotMemoryView.this.profileClass(userValue);
            }
        });
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    private void setAggregation(int aggregation) {
        this.aggregation = aggregation;
        if (this.dataView != null) {
            if (this.refSnapshot == null) {
                this.dataView.setData(this.snapshot, this.filter, aggregation);
            } else {
                this.dataView.setData(this.snapshot.createDiff(this.refSnapshot), this.filter, aggregation);
            }
        }
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable snapshotExporter) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotMemoryView.this.refSnapshot == null && snapshotExporter.isEnabled();
            }

            @Override
            public String getName() {
                return snapshotExporter.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return snapshotExporter.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public String getName() {
                return MemoryView.EXPORT_OBJECTS;
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotMemoryView.this.dataView.getExportProviders();
            }
        }};
    }
}

