/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.swing.EditableHistoryCombo;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.spi.ActionsSupportProvider;

public final class FilterUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    public static final String ACTION_FILTER = messages.getString("FilterUtils_ActionFilter");
    private static final String SIDEBAR_CAPTION = messages.getString("FilterUtils_SidebarCaption");
    private static final String BTN_FILTER_TOOLTIP = messages.getString("FilterUtils_BtnFilterTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("FilterUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("FilterUtils_BtnCloseTooltip");
    private static final String MSG_INVALID_REGEXP = messages.getString("FilterUtils_MsgInvalidRegexp");
    private static final String FILTER_CONTAINS = messages.getString("FilterUtils_FilterContains");
    private static final String FILTER_NOT_CONTAINS = messages.getString("FilterUtils_FilterNotContains");
    private static final String FILTER_REGEXP = messages.getString("FilterUtils_FilterRegexp");
    private static final String FILTER_TYPE = messages.getString("FilterUtils_FilterType");
    public static final String FILTER_ACTION_KEY = "filter-action-key";

    public static boolean filterContains(ProfilerTable table, String text) {
        return FilterUtils.filterContains(table, text, false, null);
    }

    public static boolean filterContains(ProfilerTable table, String text, boolean matchCase, RowFilter excludes) {
        return FilterUtils.filterImpl(table, text, matchCase, excludes, true);
    }

    public static boolean filterNotContains(ProfilerTable table, String text, boolean matchCase, RowFilter excludes) {
        return FilterUtils.filterImpl(table, text, matchCase, excludes, false);
    }

    private static boolean filterImpl(ProfilerTable table, String text, final boolean matchCase, final RowFilter excludesFilter, final boolean mode) {
        final int mainColumn = table.getMainColumn();
        if (text != null && !matchCase) {
            text = text.toLowerCase();
        }
        final String[] texts = text == null || text.isEmpty() ? new String[]{} : text.split(" +");
        Filter filter = new Filter(){

            public boolean include(RowFilter.Entry entry) {
                if (texts.length == 0) {
                    return true;
                }
                if (excludesFilter != null && excludesFilter.include(entry)) {
                    return true;
                }
                for (String f : texts) {
                    String value = entry.getValue(mainColumn).toString();
                    if (!matchCase) {
                        value = value.toLowerCase();
                    }
                    if (!value.contains(f)) continue;
                    return mode;
                }
                return !mode;
            }
        };
        if (texts.length > 0) {
            table.addRowFilter(filter);
            return table.getRowCount() > 0;
        }
        table.removeRowFilter(filter);
        return false;
    }

    public static boolean filterRegExp(ProfilerTable table, String text, boolean matchCase, final RowFilter excludesFilter) {
        boolean f;
        Pattern p = null;
        boolean bl = f = text != null && !text.isEmpty();
        if (f) {
            try {
                p = Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                ProfilerDialogs.displayError((String)MSG_INVALID_REGEXP);
                f = false;
            }
        }
        final boolean _f = f;
        final Pattern _p = p;
        final int mainColumn = table.getMainColumn();
        Filter filter = new Filter(){

            public boolean include(RowFilter.Entry entry) {
                if (!_f) {
                    return true;
                }
                if (excludesFilter != null && excludesFilter.include(entry)) {
                    return true;
                }
                return _p.matcher(entry.getValue(mainColumn).toString()).matches();
            }
        };
        if (f) {
            table.addRowFilter(filter);
            return table.getRowCount() > 0;
        }
        table.removeRowFilter(filter);
        return false;
    }

    public static JComponent createFilterPanel(ProfilerTable table) {
        return FilterUtils.createFilterPanel(table, null);
    }

    public static JComponent createFilterPanel(final ProfilerTable table, final RowFilter excludesFilter) {
        InvisibleToolbar toolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        toolbar.add(Box.createHorizontalStrut(6));
        toolbar.add(new JLabel(SIDEBAR_CAPTION));
        toolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo combo = new EditableHistoryCombo();
        final JTextComponent textC = combo.getTextComponent();
        JPanel comboContainer = new JPanel(new BorderLayout());
        comboContainer.add((Component)combo, "Center");
        comboContainer.setMinimumSize(combo.getMinimumSize());
        comboContainer.setPreferredSize(combo.getPreferredSize());
        comboContainer.setMaximumSize(combo.getMaximumSize());
        toolbar.add(comboContainer);
        toolbar.add(Box.createHorizontalStrut(5));
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        KeyStroke filterKey = KeyStroke.getKeyStroke(10, 0);
        final JButton[] filterButton = new JButton[1];
        final String[] activeFilter = new String[1];
        final int[] activeFilterType = new int[1];
        final boolean[] activeMatchCase = new boolean[1];
        JButton filter = new JButton(ACTION_FILTER, Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String filterString = FilterUtils.getFilterString(combo);
                        if (FilterUtils.doFilter(table, filterString, activeFilterType[0], activeMatchCase[0], excludesFilter)) {
                            combo.addItem(filterString);
                        }
                        activeFilter[0] = filterString;
                        FilterUtils.updateFilterButton(filterButton[0], activeFilter[0], filterString);
                    }
                });
            }
        };
        String filterAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)filterKey);
        filter.setToolTipText(MessageFormat.format(BTN_FILTER_TOOLTIP, filterAccelerator));
        filterButton[0] = filter;
        toolbar.add(filter);
        FilterUtils.updateFilterButton(filter, activeFilter[0], FilterUtils.getFilterString(combo));
        toolbar.add(Box.createHorizontalStrut(2));
        ((JToolBar)toolbar).addSeparator();
        toolbar.add(Box.createHorizontalStrut(1));
        final JToggleButton matchCase = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                if (this.isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            activeMatchCase[0] = this.isSelected();
                            String filterString = FilterUtils.getFilterString(combo);
                            if (FilterUtils.doFilter(table, filterString, activeFilterType[0], activeMatchCase[0], excludesFilter)) {
                                combo.addItem(filterString);
                            }
                        }
                    });
                }
            }
        };
        matchCase.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
        PopupButton filterType = new PopupButton(Icons.getIcon((String)"GeneralIcons.FilterContains")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JMenuItem(FILTER_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(0, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(FILTER_NOT_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterNotContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(1, this.getIcon(), this.getText());
                    }
                });
                popup.add(new JMenuItem(FILTER_REGEXP, Icons.getIcon((String)"GeneralIcons.FilterRegExp")){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        this.filterImpl(2, this.getIcon(), this.getText());
                    }
                });
            }

            private void filterImpl(final int type, final Icon icon, final String name) {
                if (type == 2) {
                    matchCase.setEnabled(false);
                    matchCase.setSelected(false);
                } else if (!matchCase.isEnabled()) {
                    matchCase.setSelected(activeMatchCase[0]);
                    matchCase.setEnabled(true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setIcon(icon);
                        this.setToolTipText(MessageFormat.format(FILTER_TYPE, name));
                        activeFilterType[0] = type;
                        String filterString = FilterUtils.getFilterString(combo);
                        if (FilterUtils.doFilter(table, filterString, activeFilterType[0], activeMatchCase[0], excludesFilter)) {
                            combo.addItem(filterString);
                        }
                    }
                });
            }
        };
        filterType.setToolTipText(MessageFormat.format(FILTER_TYPE, FILTER_CONTAINS));
        toolbar.add(filterType);
        toolbar.add(matchCase);
        toolbar.add(Box.createHorizontalStrut(2));
        combo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                FilterUtils.updateFilterButton(filterButton[0], activeFilter[0], FilterUtils.getFilterString(combo));
            }
        });
        final JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible) {
                    table.requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (textC != null) {
                    textC.selectAll();
                }
                return combo.requestFocusInWindow();
            }
        };
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        panel.add((Component)toolbar, "Center");
        final Runnable hider = new Runnable(){

            @Override
            public void run() {
                activeFilter[0] = null;
                FilterUtils.updateFilterButton(filterButton[0], activeFilter[0], FilterUtils.getFilterString(combo));
                FilterUtils.filterContains(table, activeFilter[0], true, excludesFilter);
                panel.setVisible(false);
            }
        };
        JButton closeButton = CloseButton.create(hider);
        String escAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)escKey);
        closeButton.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, escAccelerator));
        panel.add((Component)closeButton, "East");
        String HIDE = "hide-action";
        InputMap map = panel.getInputMap(1);
        AbstractAction hiderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                hider.run();
            }
        };
        panel.getActionMap().put(HIDE, hiderAction);
        map.put(escKey, HIDE);
        if (textC != null) {
            map = textC.getInputMap();
            AbstractAction nextAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combo.isPopupVisible()) {
                        combo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (filterButton[0].isEnabled()) {
                                filterButton[0].doClick();
                            }
                        }
                    });
                }
            };
            textC.getActionMap().put(FILTER_ACTION_KEY, nextAction);
            map.put(filterKey, FILTER_ACTION_KEY);
        }
        return panel;
    }

    private static String getFilterString(EditableHistoryCombo combo) {
        String filter = combo.getText();
        return filter == null ? null : filter.trim();
    }

    private static boolean doFilter(ProfilerTable table, String text, int filterType, boolean matchCase, RowFilter excludesFilter) {
        switch (filterType) {
            case 0: {
                return FilterUtils.filterContains(table, text, matchCase, excludesFilter);
            }
            case 1: {
                return FilterUtils.filterNotContains(table, text, matchCase, excludesFilter);
            }
            case 2: {
                return FilterUtils.filterRegExp(table, text, matchCase, excludesFilter);
            }
        }
        return false;
    }

    private static void updateFilterButton(JButton button, String activeFilter, String currentFilter) {
        String active = activeFilter == null ? "" : activeFilter;
        String current = currentFilter == null ? "" : currentFilter;
        button.setEnabled(!current.equals(active));
    }

    private FilterUtils() {
    }

    private static interface Support {

        public static final class FilterActionProvider
        extends ActionsSupportProvider {
            public KeyStroke registerAction(String actionKey, Action action, ActionMap actionMap, InputMap inputMap) {
                if (!FilterUtils.FILTER_ACTION_KEY.equals(actionKey)) {
                    return null;
                }
                KeyStroke ks = KeyStroke.getKeyStroke(71, 2);
                actionMap.put(actionKey, action);
                inputMap.put(ks, actionKey);
                return ks;
            }
        }
    }

    private static abstract class Filter
    extends RowFilter {
        private Filter() {
        }

        public boolean equals(Object o) {
            return o instanceof Filter;
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }
}

