/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class TimelineRenderer
extends BaseRenderer {
    private static final Color TICK_COLOR = new Color(200, 200, 200);
    private static final int BAR_MARGIN = 3;
    private static final int BAR_MARGIN_X2 = 6;
    private final ViewManager view;
    private ViewManager.RowView rowView;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public TimelineRenderer(ViewManager view) {
        this.view = view;
        this.setOpaque(true);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    @Override
    public void setValue(Object value, int row) {
        this.rowView = (ViewManager.RowView)value;
    }

    @Override
    public String toString() {
        int lastIndex = this.rowView.getLastIndex();
        return TimelineRenderer.getStateName(lastIndex == -1 ? -1 : this.rowView.getState(lastIndex));
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int x;
        super.paint(g);
        int w = this.size.width;
        int h = this.size.height;
        long time = this.view.getFirstTimeMark(false);
        long step = this.view.getTimeMarksStep();
        g.setColor(TICK_COLOR);
        int oldX = x = this.view.getTimePosition(time, false);
        while (x < w) {
            g.drawLine(x + this.location.x, this.location.y, x + this.location.x, h - 1 + this.location.y);
            x = this.view.getTimePosition(time += step, false);
            if (x <= oldX) break;
            oldX = x;
        }
        if ((i = this.rowView.getLastIndex()) != -1) {
            int xx = Math.min(this.rowView.getMaxPosition(), w);
            while (i >= 0 && xx >= 0) {
                xx = this.paintState(g, i--, xx, h);
            }
        }
    }

    private int paintState(Graphics g, int i, int xx, int h) {
        int x = Math.max(0, this.rowView.getPosition(this.rowView.getTime(i)));
        Color c = ThreadData.getThreadStateColor((int)this.rowView.getState(i));
        if (c != null) {
            g.setColor(c);
            g.fillRect(x + this.location.x, 3 + this.location.y, xx - x + 1, h - 6);
        }
        return x - 1;
    }

    private static String getStateName(int state) {
        switch (state) {
            case 1: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateRunning");
            }
            case 2: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateSleeping");
            }
            case 3: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateMonitor");
            }
            case 4: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateWait");
            }
            case 5: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStatePark");
            }
        }
        return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateFinished");
    }
}

