/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FeatureProjectFactory;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.w3c.dom.Document;

public final class FeatureInfo {
    private final URL delegateLayer;
    private final Set<String> cnbs;
    private final Map<String, String> nbproject = new HashMap<String, String>();
    private final Map<Object[], String> files = new HashMap<Object[], String>();
    private Properties properties;
    final String clusterName;
    private Boolean cacheEnabled;
    private Boolean cachePresent;

    private FeatureInfo(String clusterName, Set<String> cnbs, URL delegateLayer, Properties p) {
        this.cnbs = cnbs;
        this.delegateLayer = delegateLayer;
        this.properties = p;
        this.clusterName = clusterName;
    }

    public static FeatureInfo create(String clusterName, URL delegateLayer, URL bundle) throws IOException {
        Properties p = new Properties();
        p.load(bundle.openStream());
        String cnbs = p.getProperty("cnbs");
        assert (cnbs != null) : "Error loading from " + bundle;
        TreeSet<String> s = new TreeSet<String>();
        s.addAll(Arrays.asList(cnbs.split(",")));
        FeatureInfo info = new FeatureInfo(clusterName, s, delegateLayer, p);
        String prefix = "nbproject.";
        String prefFile = "project.file.";
        String prefXPath = "project.xpath.";
        for (Object k : p.keySet()) {
            IOException e;
            String key = (String)k;
            if (key.startsWith("nbproject.")) {
                info.nbproject(key.substring("nbproject.".length()), p.getProperty(key));
            }
            if (key.startsWith("project.file.")) {
                try {
                    info.projectFile(key.substring("project.file.".length()), null, p.getProperty(key));
                }
                catch (XPathExpressionException ex) {
                    e = new IOException(ex.getMessage());
                    e.initCause(ex);
                    throw e;
                }
            }
            if (!key.startsWith("project.xpath.")) continue;
            try {
                String xpaths = p.getProperty(key);
                for (String xp : FeatureInfo.safeXPathSplit(xpaths)) {
                    info.projectFile(key.substring("project.xpath.".length()), xp, "");
                }
            }
            catch (XPathExpressionException ex) {
                e = new IOException(ex.getMessage());
                e.initCause(ex);
                throw e;
            }
        }
        return info;
    }

    public Object getProjectImporter() {
        return this.properties.getProperty("projectImporter");
    }

    String getPreferredCodeNameBase() {
        return this.properties.getProperty("mainModule");
    }

    String getFeatureCodeNameBase() {
        String f = this.properties.getProperty("featureModule");
        if (f != null) {
            return f.length() == 0 ? null : f;
        }
        return this.getPreferredCodeNameBase();
    }

    public final boolean isEnabled() {
        Boolean e = this.cacheEnabled;
        if (e != null) {
            return e;
        }
        for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!this.cnbs.contains(mi.getCodeNameBase()) || !FeatureManager.showInAU(mi)) continue;
            this.cacheEnabled = mi.isEnabled();
            return this.cacheEnabled;
        }
        this.cacheEnabled = false;
        return this.cacheEnabled;
    }

    public final URL getLayerURL() {
        return this.delegateLayer;
    }

    int isProject(FeatureProjectFactory.Data data) {
        int toRet;
        FeatureProjectFactory.LOG.log(Level.FINE, "Checking project {0}", data);
        if (this.isNbProject(data)) {
            toRet = 1;
        } else if (this.files.isEmpty()) {
            toRet = 0;
        } else {
            toRet = 0;
            for (Object[] required : this.files.keySet()) {
                String s = (String)required[0];
                FeatureProjectFactory.LOG.log(Level.FINER, "    checking file {0}", s);
                if (!data.hasFile(s)) continue;
                FeatureProjectFactory.LOG.log(Level.FINER, "    found", s);
                Object r1 = required[1];
                if (data.isDeepCheck() && r1 != null) {
                    XPathExpression e;
                    block12: {
                        if (!(r1 instanceof XPathExpression)) {
                            try {
                                String path = (String)r1;
                                if (path.isEmpty()) {
                                    toRet = 2;
                                    continue;
                                }
                                e = XPathFactory.newInstance().newXPath().compile(path);
                                required[1] = e;
                                break block12;
                            }
                            catch (XPathExpressionException ex) {
                                FoDLayersProvider.LOG.log(Level.WARNING, "Cannot parse " + r1, ex);
                                continue;
                            }
                        }
                        e = (XPathExpression)r1;
                    }
                    Document content = data.dom(s);
                    try {
                        String res = e.evaluate(content);
                        FeatureProjectFactory.LOG.log(Level.FINER, "Parsed result {0} of type {1}", new Object[]{res, res == null ? null : res.getClass()});
                        if (res == null || res.length() <= 0) break;
                        toRet = 2;
                    }
                    catch (XPathExpressionException ex) {
                        FeatureProjectFactory.LOG.log(Level.INFO, "Cannot parse " + data, ex);
                    }
                    break;
                }
                toRet = 1;
                break;
            }
        }
        FeatureProjectFactory.LOG.log(Level.FINE, "  isProject: {0}", toRet);
        return toRet;
    }

    public final Set<String> getCodeNames() {
        return Collections.unmodifiableSet(this.cnbs);
    }

    public boolean isPresent() {
        Boolean p = this.cachePresent;
        if (p != null) {
            return p;
        }
        HashSet<String> codeNames = new HashSet<String>(this.getCodeNames());
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            codeNames.remove(moduleInfo.getCodeNameBase());
        }
        this.cachePresent = codeNames.isEmpty();
        return this.cachePresent;
    }

    void clearCache() {
        this.cachePresent = null;
        this.cacheEnabled = null;
    }

    public String toString() {
        return "FeatureInfo[" + this.clusterName + "]";
    }

    private boolean isNbProject(FeatureProjectFactory.Data data) {
        if (this.nbproject.isEmpty()) {
            return false;
        }
        if (!data.hasFile("nbproject/project.xml")) {
            FeatureProjectFactory.LOG.log(Level.FINEST, "    nbproject/project.xml not found");
            return false;
        }
        if (!data.isDeepCheck()) {
            FeatureProjectFactory.LOG.log(Level.FINEST, "    no deep check, OK");
            return true;
        }
        String text = data.is("nbproject/project.xml");
        if (text == null) {
            return false;
        }
        for (String t : this.nbproject.keySet()) {
            String pattern = "<type>" + t + "</type>";
            if (text.indexOf(pattern) >= 0) {
                FeatureProjectFactory.LOG.log(Level.FINEST, "    '" + pattern + "' found, OK");
                return true;
            }
            FeatureProjectFactory.LOG.log(Level.FINEST, "    '" + pattern + "' not found");
        }
        FeatureProjectFactory.LOG.log(Level.FINEST, "    not accepting");
        return false;
    }

    final void nbproject(String prjType, String clazz) {
        this.nbproject.put(prjType, clazz);
    }

    final void projectFile(String file, String xpath, String clazz) throws XPathExpressionException {
        this.files.put(new Object[]{file, xpath}, clazz);
    }

    static Map<String, String> nbprojectTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            map.putAll(featureInfo.nbproject);
        }
        return map;
    }

    static Map<String, String> projectFiles() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            for (Map.Entry<Object[], String> e : featureInfo.files.entrySet()) {
                if (e.getValue().length() <= 0) continue;
                map.put((String)e.getKey()[0], e.getValue());
            }
        }
        return map;
    }

    private static String[] safeXPathSplit(String xpathList) {
        ArrayList<String> xpaths = new ArrayList<String>();
        boolean inSelector = false;
        int start = 0;
        int i = 0;
        block5: for (i = 0; i < xpathList.length(); ++i) {
            char c = xpathList.charAt(i);
            switch (c) {
                case '[': {
                    inSelector = true;
                    continue block5;
                }
                case ']': {
                    inSelector = false;
                    continue block5;
                }
                case ',': {
                    if (inSelector) continue block5;
                    String xpath = xpathList.substring(0, i);
                    start = i + 1;
                    xpaths.add(xpath);
                }
            }
        }
        xpaths.add(xpathList.substring(start, i));
        return xpaths.toArray(new String[xpaths.size()]);
    }
}

