/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import org.netbeans.modules.form.FormLoaderSettings;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class NonVisualTray
extends JPanel
implements ExplorerManager.Provider {
    private NonVisualView listView;
    private ExplorerManager manager = new ExplorerManager();
    private ExplorerManager syncManager;
    private PropertyChangeListener selectionListener;

    public NonVisualTray(ExplorerManager syncManager, Node rootNode) {
        this.syncManager = syncManager;
        this.manager.setRootContext((Node)new NonVisualNode(rootNode, new NonVisualChildren(rootNode)));
        this.selectionListener = new Listener();
        this.manager.addPropertyChangeListener(this.selectionListener);
        syncManager.addPropertyChangeListener(this.selectionListener);
        this.listView = new NonVisualView();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.listView), "Center");
    }

    void close() {
        this.syncManager.removePropertyChangeListener(this.selectionListener);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void updateVisualSettings() {
        this.listView.updateVisualSettings();
    }

    private static class NonVisualNode
    extends FilterNode {
        public NonVisualNode(Node original) {
            super(original);
            this.disableDelegation(160);
        }

        public NonVisualNode(Node original, FilterNode.Children children) {
            super(original, (Children)children);
        }

        public String getShortDescription() {
            return this.getName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public Action[] getActions(boolean context) {
            List<Class> forbiddenActions = Arrays.asList(MoveUpAction.class, MoveDownAction.class);
            Action[] actions = this.getOriginal().getActions(context);
            ArrayList<Action> actionList = new ArrayList<Action>(Arrays.asList(actions));
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                if (action == null || !forbiddenActions.contains(action.getClass())) continue;
                actionList.remove(action);
            }
            return actionList.toArray(new Action[actionList.size()]);
        }
    }

    private class NonVisualChildren
    extends FilterNode.Children {
        public NonVisualChildren(Node original) {
            super(original);
        }

        protected Node copyNode(Node node) {
            return new NonVisualNode(node);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private boolean updating;

        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"selectedNodes".equals(evt.getPropertyName()) || this.updating) {
                return;
            }
            if (evt.getSource() == NonVisualTray.this.manager) {
                Node[] newNodes = (Node[])evt.getNewValue();
                Node[] nodes = new Node[newNodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = ((NonVisualNode)newNodes[i]).getOriginal();
                }
                try {
                    this.updating = true;
                    NonVisualTray.this.syncManager.setSelectedNodes(nodes);
                }
                catch (PropertyVetoException pvex) {
                }
                finally {
                    this.updating = false;
                }
            } else {
                Node[] nodes = (Node[])evt.getNewValue();
                ArrayList<Node> list = new ArrayList<Node>();
                Node node = ((NonVisualNode)NonVisualTray.this.manager.getRootContext()).getOriginal();
                for (int i = 0; i < nodes.length; ++i) {
                    if (node != nodes[i].getParentNode()) continue;
                    list.add(this.findFilterNode(nodes[i]));
                }
                try {
                    this.updating = true;
                    NonVisualTray.this.manager.setSelectedNodes(list.toArray(new Node[list.size()]));
                }
                catch (PropertyVetoException pvex) {
                }
                finally {
                    this.updating = false;
                }
            }
        }

        private Node findFilterNode(Node original) {
            Node root = NonVisualTray.this.manager.getRootContext();
            Node[] nodes = root.getChildren().getNodes(false);
            for (int i = 0; i < nodes.length; ++i) {
                NonVisualNode node = (NonVisualNode)nodes[i];
                if (node.getOriginal() != original) continue;
                return node;
            }
            return null;
        }
    }

    private static class Renderer
    implements ListCellRenderer {
        private JButton button = new JButton();
        private Border selectedBorder;
        private Border unselectedBorder;

        public Renderer() {
            this.button.setUI(new BasicButtonUI());
            this.unselectedBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
            Color selectionColor = FormLoaderSettings.getInstance().getSelectionBorderColor();
            this.selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(selectionColor));
            this.button.setOpaque(false);
            int fontSize = this.button.getFontMetrics(this.button.getFont()).getHeight();
            this.button.setPreferredSize(new Dimension(72, 50 + fontSize));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = Visualizer.findNode((Object)value);
            ImageIcon icon = new ImageIcon(node.getIcon(2));
            this.button.setIcon(icon);
            String text = node.getShortDescription();
            this.button.setText(text);
            this.button.setHorizontalTextPosition(0);
            this.button.setVerticalTextPosition(3);
            this.button.setHorizontalAlignment(0);
            this.button.setBorder(isSelected ? this.selectedBorder : this.unselectedBorder);
            return this.button;
        }
    }

    private static class NonVisualView
    extends ListView {
        public NonVisualView() {
            this.list.setCellRenderer(new Renderer());
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(-1);
            this.list.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.updateVisualSettings();
            this.setTraversalAllowed(false);
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            return new Dimension(1, (int)dim.getHeight());
        }

        void updateVisualSettings() {
            this.list.setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
        }
    }
}

