/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.form.CreationDescriptor;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.editors.EnumEditor;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class BorderDesignSupport
implements FormDesignValue {
    private Border theBorder;
    private boolean borderNeedsUpdate;
    private boolean propertiesNeedInit;
    private CreationDescriptor creationDesc;
    private FormPropertyContext propertyContext = null;
    private FormProperty[] properties = null;

    public BorderDesignSupport(Class borderClass) throws Exception {
        this.creationDesc = CreationFactory.getDescriptor(borderClass);
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(borderClass);
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.theBorder = (Border)CreationFactory.createInstance(borderClass);
    }

    public BorderDesignSupport(Border border) {
        this.creationDesc = CreationFactory.getDescriptor(border.getClass());
        if (this.creationDesc == null) {
            this.creationDesc = new CreationDescriptor(border.getClass());
            CreationFactory.registerDescriptor(this.creationDesc);
        }
        this.setBorder(border);
    }

    public BorderDesignSupport(BorderDesignSupport borderDesignSupport, FormPropertyContext propertyContext) throws Exception {
        this(borderDesignSupport.getBorderClass());
        this.setPropertyContext(propertyContext);
        this.createProperties();
        int copyMode = 3;
        FormUtils.copyProperties(borderDesignSupport.getProperties(), this.properties, copyMode);
    }

    @Override
    public FormDesignValue copy(FormProperty formProperty) {
        try {
            return new BorderDesignSupport(this, new FormPropertyContext.SubProperty(formProperty));
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public Border getBorder() {
        if (this.borderNeedsUpdate) {
            this.updateBorder();
        }
        return this.theBorder;
    }

    public void setBorder(Border border) {
        this.theBorder = border;
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                try {
                    this.properties[i].reinstateProperty();
                    continue;
                }
                catch (IllegalAccessException e1) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            this.propertiesNeedInit = false;
        } else {
            this.propertiesNeedInit = true;
        }
        this.borderNeedsUpdate = false;
    }

    public Class getBorderClass() {
        return this.creationDesc.getDescribedClass();
    }

    public String getDisplayName() {
        return Utilities.getShortClassName(this.theBorder.getClass());
    }

    public void setPropertyContext(FormPropertyContext propertyContext) {
        if (this.properties != null && this.propertyContext != propertyContext) {
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].getValueType().isPrimitive()) continue;
                this.properties[i].setPropertyContext(propertyContext);
            }
        }
        this.propertyContext = propertyContext;
    }

    public Node.Property[] getProperties() {
        if (this.properties == null) {
            this.createProperties();
        }
        return this.properties;
    }

    public Node.Property getPropertyOfName(String name) {
        Node.Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            return props[i];
        }
        return null;
    }

    private void createProperties() {
        FormLAF.executeWithLookAndFeel(this.propertyContext.getFormModel(), new Runnable(){

            @Override
            public void run() {
                BorderDesignSupport.this.createPropertiesInLAFBlock();
            }
        });
    }

    private void createPropertiesInLAFBlock() {
        BeanInfo bInfo;
        try {
            bInfo = FormUtils.getBeanInfo(this.theBorder.getClass());
        }
        catch (IntrospectionException ex) {
            return;
        }
        PropertyDescriptor[] props = bInfo.getPropertyDescriptors();
        ArrayList<BorderProperty> nodeProps = new ArrayList<BorderProperty>();
        for (int i = 0; i < props.length; ++i) {
            PropertyDescriptor pd = props[i];
            if (pd.isHidden() || pd.getWriteMethod() == null && !CreationFactory.containsProperty(this.creationDesc, pd.getName())) continue;
            BorderProperty prop = new BorderProperty(pd.getPropertyType().isPrimitive() ? null : this.propertyContext, pd);
            if (this.propertiesNeedInit) {
                try {
                    prop.reinstateProperty();
                }
                catch (IllegalAccessException e1) {
                }
                catch (InvocationTargetException e2) {
                    // empty catch block
                }
            }
            nodeProps.add(prop);
        }
        this.properties = new FormProperty[nodeProps.size()];
        nodeProps.toArray(this.properties);
        this.propertiesNeedInit = false;
    }

    public String getJavaInitializationString() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        return creator.getJavaCreationCode(this.properties, null, null, Border.class, null);
    }

    void updateBorder() {
        if (this.properties == null) {
            this.createProperties();
        }
        CreationDescriptor.Creator creator = this.creationDesc.findBestCreator(this.properties, 3);
        try {
            this.theBorder = (Border)CreationFactory.createInstance(this.creationDesc.getDescribedClass(), this.properties, 3);
            FormProperty[] otherProps = CreationFactory.getRemainingProperties(creator, this.properties);
            for (int i = 0; i < otherProps.length; ++i) {
                otherProps[i].reinstateTarget();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    @Override
    public Object getDesignValue() {
        return this.getBorder();
    }

    @Override
    public Object getDesignValue(Object target) {
        if (FormLAF.getUsePreviewDefaults()) {
            return this.copy((FormProperty)((Object)this.propertyContext.getOwner())).getDesignValue();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getDisplayName();
    }

    public class BorderProperty
    extends FormProperty {
        private PropertyDescriptor desc;
        private Object defaultValue;

        public BorderProperty(FormPropertyContext propertyContext, PropertyDescriptor desc) {
            super(propertyContext, desc.getName(), desc.getPropertyType(), desc.getDisplayName(), desc.getShortDescription());
            this.desc = desc;
            if (desc.getWriteMethod() == null) {
                this.setAccessType(2);
            } else if (desc.getReadMethod() == null) {
                this.setAccessType(1);
            }
            if (this.canReadFromTarget()) {
                try {
                    this.defaultValue = this.getTargetValue();
                    if (BorderDesignSupport.this.theBorder instanceof TitledBorder && this.canWriteToTarget()) {
                        this.setTargetValue(this.defaultValue);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        @Override
        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            super.setValue(value);
            if (MatteBorder.class.equals((Object)BorderDesignSupport.this.getBorderClass())) {
                String propName = null;
                if ("matteColor".equals(this.getName())) {
                    propName = "tileIcon";
                } else if ("tileIcon".equals(this.getName())) {
                    propName = "matteColor";
                }
                if (propName != null) {
                    Node.Property prop = BorderDesignSupport.this.getPropertyOfName(propName);
                    prop.restoreDefaultValue();
                }
            }
        }

        @Override
        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            Method readMethod = this.desc.getReadMethod();
            return readMethod.invoke((Object)BorderDesignSupport.this.theBorder, new Object[0]);
        }

        @Override
        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method writeMethod = this.desc.getWriteMethod();
            writeMethod.invoke((Object)BorderDesignSupport.this.theBorder, value);
        }

        @Override
        protected Object getRealValue(Object value) {
            Object realValue = super.getRealValue(value);
            if (realValue == FormDesignValue.IGNORED_VALUE && "title".equals(this.desc.getName())) {
                realValue = ((FormDesignValue)value).getDescription();
            }
            return realValue;
        }

        @Override
        public boolean supportsDefaultValue() {
            return true;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public PropertyEditor getExpliciteEditor() {
            try {
                Object[] enumerationValues;
                PropertyEditor propEd = this.desc.createPropertyEditor(BorderDesignSupport.this.theBorder);
                if (propEd == null && (enumerationValues = (Object[])this.desc.getValue("enumerationValues")) != null) {
                    propEd = new EnumEditor(enumerationValues);
                }
                return propEd;
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                return null;
            }
        }

        @Override
        protected Method getWriteMethod() {
            return this.desc.getWriteMethod();
        }

        @Override
        protected void propertyValueChanged(Object old, Object current) {
            super.propertyValueChanged(old, current);
            BorderDesignSupport.this.borderNeedsUpdate = (this.getAccessType() & 2) != 0;
        }

        public boolean equals(Object property) {
            return this == property;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

