/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.InvalidComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutNode;
import org.netbeans.modules.form.layoutsupport.LayoutSupportContext;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportRegistry;
import org.netbeans.modules.form.layoutsupport.UnknownLayoutSupport;
import org.netbeans.modules.form.layoutsupport.delegates.NullLayoutSupport;
import org.openide.nodes.Node;

public final class LayoutSupportManager
implements LayoutSupportContext {
    public static final int RESIZE_UP = 1;
    public static final int RESIZE_DOWN = 2;
    public static final int RESIZE_LEFT = 4;
    public static final int RESIZE_RIGHT = 8;
    private LayoutSupportDelegate layoutDelegate;
    private boolean needInit;
    private boolean initializeFromInstance;
    private boolean initializeFromCode;
    private Node.PropertySet[] propertySets;
    private LayoutListener layoutListener;
    private RADVisualContainer metaContainer;
    private Container primaryContainer;
    private Container primaryContainerDelegate;
    private CodeStructure codeStructure;
    private CodeExpression containerCodeExpression;
    private CodeExpression containerDelegateCodeExpression;

    public LayoutSupportManager(RADVisualContainer container, CodeStructure codeStructure) {
        this.metaContainer = container;
        this.codeStructure = codeStructure;
    }

    public boolean prepareLayoutDelegate(boolean fromCode, boolean initialize) throws Exception {
        LayoutSupportDelegate delegate = null;
        LayoutManager lmInstance = null;
        FormModel formModel = this.metaContainer.getFormModel();
        LayoutSupportRegistry layoutRegistry = LayoutSupportRegistry.getRegistry(formModel);
        delegate = layoutRegistry.createSupportForContainer(this.metaContainer.getBeanClass());
        if (delegate != null) {
            if (!fromCode && !delegate.checkEmptyContainer(this.getPrimaryContainer())) {
                IllegalArgumentException ex = new IllegalArgumentException(AbstractLayoutSupport.getBundle().getString("MSG_ERR_NonEmptyContainer"));
                throw ex;
            }
        } else {
            Container contDel;
            Iterator it;
            CodeStatement[] statements;
            if (fromCode && (statements = CodeStructure.filterStatements(it = CodeStructure.getDefinedStatementsIterator(this.getContainerDelegateCodeExpression()), AbstractLayoutSupport.getSetLayoutMethod())).length > 0) {
                CodeExpressionOrigin layoutOrigin = statements[0].getStatementParameters()[0].getOrigin();
                Class layoutType = layoutOrigin.getType();
                delegate = layoutRegistry.createSupportForLayout(layoutType);
                if (delegate == null) {
                    if (layoutOrigin.getType() == LayoutManager.class && layoutOrigin.getCreationParameters().length == 0 && layoutOrigin.getParentExpression() == null && "null".equals(layoutOrigin.getJavaCodeString(null, null))) {
                        delegate = new NullLayoutSupport();
                    } else if (layoutOrigin.getMetaObject() instanceof Constructor && layoutOrigin.getCreationParameters().length == 0) {
                        System.err.println("[WARNING] No support for " + layoutType.getName() + " was found, trying to use default support like if the layout was in palette as a bean.");
                        LayoutSupportRegistry.registerSupportForLayout(layoutType.getName(), "<default>");
                        delegate = new DefaultLayoutSupport(layoutOrigin.getType());
                    } else {
                        return false;
                    }
                }
                lmInstance = this.getPrimaryContainerDelegate().getLayout();
            }
            if (delegate == null && !((contDel = this.getPrimaryContainerDelegate()) instanceof InvalidComponent)) {
                if (contDel.getComponentCount() == 0) {
                    lmInstance = contDel.getLayout();
                    delegate = lmInstance != null ? layoutRegistry.createSupportForLayout(lmInstance.getClass()) : new NullLayoutSupport();
                } else {
                    IllegalArgumentException ex = new IllegalArgumentException(AbstractLayoutSupport.getBundle().getString("MSG_ERR_NonEmptyContainer"));
                    throw ex;
                }
            }
        }
        if (delegate == null) {
            return false;
        }
        if (initialize) {
            this.setLayoutDelegate(delegate, lmInstance, fromCode);
        } else {
            this.layoutDelegate = delegate;
            this.needInit = true;
            this.initializeFromInstance = lmInstance != null;
            this.initializeFromCode = fromCode;
        }
        return true;
    }

    public void initializeLayoutDelegate() throws Exception {
        if (this.layoutDelegate != null && this.needInit) {
            LayoutManager lmInstance = this.initializeFromInstance ? this.getPrimaryContainerDelegate().getLayout() : null;
            this.layoutDelegate.initialize(this, lmInstance, this.initializeFromCode);
            this.fillLayout(null);
            this.getPropertySets();
            this.needInit = false;
        }
    }

    public void setLayoutDelegate(LayoutSupportDelegate newDelegate, LayoutManager lmInstance, boolean fromCode) throws Exception {
        LayoutSupportDelegate oldDelegate = this.layoutDelegate;
        LayoutConstraints[] oldConstraints = this.layoutDelegate != null && (this.layoutDelegate != newDelegate || !fromCode) ? this.removeLayoutDelegate(true) : null;
        this.layoutDelegate = newDelegate;
        this.propertySets = null;
        this.needInit = false;
        if (this.layoutDelegate != null) {
            try {
                this.layoutDelegate.initialize(this, lmInstance, fromCode);
                if (!fromCode) {
                    this.fillLayout(oldConstraints);
                }
                this.getPropertySets();
            }
            catch (Exception ex) {
                this.removeLayoutDelegate(false);
                this.layoutDelegate = oldDelegate;
                if (this.layoutDelegate != null) {
                    this.fillLayout(null);
                }
                throw ex;
            }
        }
    }

    public LayoutSupportDelegate getLayoutDelegate() {
        return this.layoutDelegate;
    }

    public static LayoutSupportDelegate getLayoutDelegateForDefaultLayout(FormModel formModel, LayoutManager layout) throws Exception {
        LayoutSupportDelegate defaultLayoutDelegate;
        if (layout == null) {
            defaultLayoutDelegate = new NullLayoutSupport();
        } else {
            LayoutSupportRegistry layoutRegistry = LayoutSupportRegistry.getRegistry(formModel);
            defaultLayoutDelegate = layoutRegistry.createSupportForLayout(layout.getClass());
            if (defaultLayoutDelegate == null) {
                defaultLayoutDelegate = new UnknownLayoutSupport();
            }
        }
        return defaultLayoutDelegate;
    }

    public void setUnknownLayoutDelegate(boolean fromCode) {
        try {
            this.setLayoutDelegate(new UnknownLayoutSupport(), null, fromCode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isUnknownLayout() {
        return this.layoutDelegate == null || this.layoutDelegate instanceof UnknownLayoutSupport;
    }

    public boolean isSpecialLayout() {
        return this.layoutDelegate instanceof DefaultLayoutSupport;
    }

    public boolean hasComponentConstraints() {
        if (this.layoutDelegate != null) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (this.layoutDelegate.getConstraints(i) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void copyLayoutDelegateFrom(LayoutSupportManager sourceLayoutSupport, RADVisualComponent[] newMetaComps) {
        LayoutSupportDelegate sourceDelegate = sourceLayoutSupport.getLayoutDelegate();
        int componentCount = sourceDelegate.getComponentCount();
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        if (this.layoutDelegate != null) {
            this.removeLayoutDelegate(false);
        }
        CodeExpression[] compExps = new CodeExpression[componentCount];
        Component[] primaryComps = new Component[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            RADVisualComponent metacomp = newMetaComps[i];
            compExps[i] = metacomp.getCodeExpression();
            primaryComps[i] = (Component)metacomp.getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(primaryComps[i]);
        }
        LayoutSupportDelegate newDelegate = sourceDelegate.cloneLayoutSupport(this, compExps);
        newDelegate.setLayoutToContainer(cont, contDel);
        newDelegate.addComponentsToContainer(cont, contDel, primaryComps, 0);
        this.layoutDelegate = newDelegate;
        try {
            this.layoutDelegate.acceptContainerLayoutChange(null);
        }
        catch (PropertyVetoException pvex) {
            // empty catch block
        }
    }

    public void clearPrimaryContainer() {
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public RADVisualContainer getMetaContainer() {
        return this.metaContainer;
    }

    private LayoutConstraints[] removeLayoutDelegate(boolean extractConstraints) {
        RADVisualComponent[] metacomps;
        CodeGroup code = this.layoutDelegate.getLayoutCode();
        if (code != null) {
            CodeStructure.removeStatements(code.getStatementsIterator());
        }
        int componentCount = this.layoutDelegate.getComponentCount();
        LayoutConstraints[] constraints = null;
        if (componentCount > 0 && (metacomps = this.metaContainer.getSubComponents()).length == componentCount) {
            if (extractConstraints) {
                constraints = new LayoutConstraints[componentCount];
            }
            for (int i = 0; i < componentCount; ++i) {
                LayoutConstraints constr = this.layoutDelegate.getConstraints(i);
                if (extractConstraints) {
                    constraints[i] = constr;
                }
                if (constr != null) {
                    metacomps[i].setLayoutConstraints(this.layoutDelegate.getClass(), constr);
                }
                if ((code = this.layoutDelegate.getComponentCode(i)) == null) continue;
                CodeStructure.removeStatements(code.getStatementsIterator());
            }
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
        this.layoutDelegate = null;
        return constraints;
    }

    private void fillLayout(LayoutConstraints[] oldConstraints) {
        int i;
        RADVisualComponent[] metacomps = this.metaContainer.getSubComponents();
        int componentCount = metacomps.length;
        CodeExpression[] compExps = new CodeExpression[componentCount];
        Component[] designComps = new Component[componentCount];
        Component[] primaryComps = new Component[componentCount];
        LayoutConstraints[] newConstraints = new LayoutConstraints[componentCount];
        FormDesigner designer = FormEditor.getFormDesigner(this.metaContainer.getFormModel());
        for (i = 0; i < componentCount; ++i) {
            RADVisualComponent metacomp = metacomps[i];
            compExps[i] = metacomp.getCodeExpression();
            primaryComps[i] = (Component)metacomp.getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(primaryComps[i]);
            newConstraints[i] = metacomp.getLayoutConstraints(this.layoutDelegate.getClass());
            Component comp = designer != null ? (Component)designer.getComponent(metacomp) : null;
            designComps[i] = comp != null ? comp : (Component)metacomp.getBeanInstance();
        }
        if (this.metaContainer.getFormModel().isUndoRedoRecording()) {
            this.layoutDelegate.convertConstraints(oldConstraints, newConstraints, designComps);
        }
        if (componentCount > 0) {
            this.layoutDelegate.acceptNewComponents(compExps, newConstraints, 0);
            this.layoutDelegate.addComponents(compExps, newConstraints, 0);
            for (i = 0; i < componentCount; ++i) {
                metacomps[i].resetConstraintsProperties();
            }
        }
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        if (this.metaContainer.isDefaultLayoutDelegate(this.layoutDelegate) && this.layoutDelegate.getSupportedClass() == null) {
            contDel.setLayout(this.metaContainer.getDefaultLayout());
        }
        this.layoutDelegate.setLayoutToContainer(cont, contDel);
        if (componentCount > 0) {
            this.layoutDelegate.addComponentsToContainer(cont, contDel, primaryComps, 0);
        }
    }

    public boolean isDedicated() {
        return this.layoutDelegate.isDedicated();
    }

    public Class getSupportedClass() {
        return this.layoutDelegate.getSupportedClass();
    }

    public boolean shouldHaveNode() {
        return this.layoutDelegate.shouldHaveNode();
    }

    public String getDisplayName() {
        return this.layoutDelegate.getDisplayName();
    }

    public Image getIcon(int type) {
        return this.layoutDelegate.getIcon(type);
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            if (this.layoutDelegate == null) {
                return new Node.PropertySet[0];
            }
            this.propertySets = this.layoutDelegate.getPropertySets();
            for (int i = 0; i < this.propertySets.length; ++i) {
                Node.Property[] props = this.propertySets[i].getProperties();
                for (int j = 0; j < props.length; ++j) {
                    if (!(props[j] instanceof FormProperty)) continue;
                    FormProperty prop = (FormProperty)props[j];
                    prop.addVetoableChangeListener(this.getLayoutListener());
                    prop.addPropertyChangeListener(this.getLayoutListener());
                }
            }
        }
        return this.propertySets;
    }

    public Node.Property[] getAllProperties() {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getAllProperties();
        }
        ArrayList<Node.Property> allPropsList = new ArrayList<Node.Property>();
        for (int i = 0; i < this.propertySets.length; ++i) {
            Node.Property[] props = this.propertySets[i].getProperties();
            for (int j = 0; j < props.length; ++j) {
                allPropsList.add(props[j]);
            }
        }
        Node.Property[] allProperties = new Node.Property[allPropsList.size()];
        allPropsList.toArray(allProperties);
        return allProperties;
    }

    public Node.Property getLayoutProperty(String name) {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).getProperty(name);
        }
        Node.Property[] properties = this.getAllProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (!name.equals(properties[i].getName())) continue;
            return properties[i];
        }
        return null;
    }

    public boolean isLayoutPropertyChangedFromInitial(FormProperty prop) {
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            return ((AbstractLayoutSupport)this.layoutDelegate).isPropertyChangedFromInitial(prop);
        }
        return prop.isChanged();
    }

    public Class getCustomizerClass() {
        return this.layoutDelegate.getCustomizerClass();
    }

    public Component getSupportCustomizer() {
        return this.layoutDelegate.getSupportCustomizer();
    }

    public CodeGroup getLayoutCode() {
        return this.layoutDelegate.getLayoutCode();
    }

    public CodeGroup getComponentCode(int index) {
        return this.layoutDelegate.getComponentCode(index);
    }

    public CodeGroup getComponentCode(RADVisualComponent metacomp) {
        int index = this.metaContainer.getIndexOf(metacomp);
        return index >= 0 && index < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getComponentCode(index) : null;
    }

    public int getComponentCount() {
        return this.layoutDelegate.getComponentCount();
    }

    public void acceptNewComponents(RADVisualComponent[] components, LayoutConstraints[] constraints, int index) {
        CodeExpression[] compExps = new CodeExpression[components.length];
        for (int i = 0; i < components.length; ++i) {
            compExps[i] = components[i].getCodeExpression();
        }
        this.layoutDelegate.acceptNewComponents(compExps, constraints, index);
    }

    public void addComponents(RADVisualComponent[] components, LayoutConstraints[] constraints, int index) {
        int i;
        CodeExpression[] compExps = new CodeExpression[components.length];
        Component[] comps = new Component[components.length];
        for (i = 0; i < components.length; ++i) {
            compExps[i] = components[i].getCodeExpression();
            comps[i] = (Component)components[i].getBeanInstance();
            LayoutSupportManager.ensureFakePeerAttached(comps[i]);
        }
        if (index < 0) {
            index = this.layoutDelegate.getComponentCount();
        }
        this.layoutDelegate.addComponents(compExps, constraints, index);
        for (i = 0; i < components.length; ++i) {
            components[i].resetConstraintsProperties();
        }
        this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), comps, index);
    }

    public void removeComponent(RADVisualComponent metacomp, int index) {
        LayoutConstraints constr = this.layoutDelegate.getConstraints(index);
        if (constr != null) {
            metacomp.setLayoutConstraints(this.layoutDelegate.getClass(), constr);
        }
        CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(index).getStatementsIterator());
        this.layoutDelegate.removeComponent(index);
        if (!this.layoutDelegate.removeComponentFromContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), (Component)metacomp.getBeanInstance())) {
            this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
            RADVisualComponent[] metacomps = this.metaContainer.getSubComponents();
            if (metacomps.length > 1) {
                Component[] comps = new Component[metacomps.length - 1];
                for (int i = 0; i < metacomps.length; ++i) {
                    if (i == index) continue;
                    Component comp = (Component)metacomps[i].getBeanInstance();
                    LayoutSupportManager.ensureFakePeerAttached(comp);
                    comps[i < index ? i : i - 1] = comp;
                }
                this.layoutDelegate.addComponentsToContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate(), comps, 0);
            }
        }
    }

    public void removeAll() {
        int i;
        RADVisualComponent[] components = this.metaContainer.getSubComponents();
        for (i = 0; i < components.length; ++i) {
            LayoutConstraints constr = this.layoutDelegate.getConstraints(i);
            if (constr == null) continue;
            components[i].setLayoutConstraints(this.layoutDelegate.getClass(), constr);
        }
        int n = this.layoutDelegate.getComponentCount();
        for (i = 0; i < n; ++i) {
            CodeStructure.removeStatements(this.layoutDelegate.getComponentCode(i).getStatementsIterator());
        }
        this.layoutDelegate.removeAll();
        this.layoutDelegate.clearContainer(this.getPrimaryContainer(), this.getPrimaryContainerDelegate());
    }

    public boolean isLayoutChanged() {
        Container defaultContainer = (Container)BeanSupport.getDefaultInstance(this.metaContainer.getBeanClass());
        Container defaultContDelegate = this.metaContainer.getContainerDelegate(defaultContainer);
        return this.layoutDelegate.isLayoutChanged(defaultContainer, defaultContDelegate);
    }

    public LayoutConstraints getConstraints(int index) {
        return this.layoutDelegate.getConstraints(index);
    }

    public LayoutConstraints getConstraints(RADVisualComponent metacomp) {
        if (this.layoutDelegate == null) {
            return null;
        }
        int index = this.metaContainer.getIndexOf(metacomp);
        return index >= 0 && index < this.layoutDelegate.getComponentCount() ? this.layoutDelegate.getConstraints(index) : null;
    }

    public static LayoutConstraints storeConstraints(RADVisualComponent metacomp) {
        RADVisualContainer parent = metacomp.getParentContainer();
        if (parent == null) {
            return null;
        }
        LayoutSupportManager layoutSupport = parent.getLayoutSupport();
        if (layoutSupport == null) {
            return null;
        }
        LayoutConstraints constr = layoutSupport.getConstraints(metacomp);
        if (constr != null) {
            metacomp.setLayoutConstraints(layoutSupport.getLayoutDelegate().getClass(), constr);
        }
        return constr;
    }

    public LayoutConstraints getStoredConstraints(RADVisualComponent metacomp) {
        return metacomp.getLayoutConstraints(this.layoutDelegate.getClass());
    }

    public void setLayoutToContainer(Container container, Container containerDelegate) {
        this.layoutDelegate.setLayoutToContainer(container, containerDelegate);
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        this.layoutDelegate.addComponentsToContainer(container, containerDelegate, components, index);
    }

    public boolean removeComponentFromContainer(Container container, Container containerDelegate, Component component) {
        return this.layoutDelegate.removeComponentFromContainer(container, containerDelegate, component);
    }

    public boolean clearContainer(Container container, Container containerDelegate) {
        return this.layoutDelegate.clearContainer(container, containerDelegate);
    }

    public LayoutConstraints getNewConstraints(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        LayoutConstraints constraints = this.layoutDelegate.getNewConstraints(container, containerDelegate, component, index, posInCont, posInComp);
        String context = null;
        Object[] params = null;
        if (this.layoutDelegate instanceof AbstractLayoutSupport) {
            AbstractLayoutSupport support = (AbstractLayoutSupport)this.layoutDelegate;
            context = support.getAssistantContext();
            params = support.getAssistantParams();
        }
        context = context == null ? "generalPosition" : context;
        FormEditor.getAssistantModel(this.metaContainer.getFormModel()).setContext(context, params);
        return constraints;
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        return this.layoutDelegate.getNewIndex(container, containerDelegate, component, index, posInCont, posInComp);
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        return this.layoutDelegate.paintDragFeedback(container, containerDelegate, component, newConstraints, newIndex, g);
    }

    public int getResizableDirections(Container container, Container containerDelegate, Component component, int index) {
        return this.layoutDelegate.getResizableDirections(container, containerDelegate, component, index);
    }

    public LayoutConstraints getResizedConstraints(Container container, Container containerDelegate, Component component, int index, Rectangle originalBounds, Insets sizeChanges, Point posInCont) {
        return this.layoutDelegate.getResizedConstraints(container, containerDelegate, component, index, originalBounds, sizeChanges, posInCont);
    }

    public void processMouseClick(Point p, Container cont, Container contDelegate) {
        this.layoutDelegate.processMouseClick(p, cont, contDelegate);
    }

    public void selectComponent(int index) {
        this.layoutDelegate.selectComponent(index);
    }

    public void arrangeContainer(Container container, Container containerDelegate) {
        this.layoutDelegate.arrangeContainer(container, containerDelegate);
    }

    @Override
    public CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    @Override
    public CodeExpression getContainerCodeExpression() {
        if (this.containerCodeExpression == null) {
            this.containerCodeExpression = this.metaContainer.getCodeExpression();
            this.containerDelegateCodeExpression = null;
        }
        return this.containerCodeExpression;
    }

    @Override
    public CodeExpression getContainerDelegateCodeExpression() {
        if (this.containerDelegateCodeExpression == null) {
            this.containerDelegateCodeExpression = LayoutSupportManager.containerDelegateCodeExpression(this.metaContainer, this.codeStructure);
        }
        return this.containerDelegateCodeExpression;
    }

    public static CodeExpression containerDelegateCodeExpression(RADVisualContainer metaContainer, CodeStructure codeStructure) {
        CodeExpression containerDelegateCodeExpression;
        CodeExpression containerCodeExpression = metaContainer.getCodeExpression();
        Method delegateGetter = metaContainer.getContainerDelegateMethod();
        if (delegateGetter != null) {
            Iterator it = CodeStructure.getDefinedExpressionsIterator(containerCodeExpression);
            CodeExpression[] expressions = CodeStructure.filterExpressions(it, delegateGetter);
            if (expressions.length > 0) {
                containerDelegateCodeExpression = expressions[0];
            } else {
                CodeExpressionOrigin origin = CodeStructure.createOrigin(containerCodeExpression, delegateGetter, null);
                containerDelegateCodeExpression = codeStructure.createExpression(origin);
            }
        } else {
            containerDelegateCodeExpression = containerCodeExpression;
        }
        return containerDelegateCodeExpression;
    }

    @Override
    public Container getPrimaryContainer() {
        return (Container)this.metaContainer.getBeanInstance();
    }

    @Override
    public Container getPrimaryContainerDelegate() {
        Container defCont = (Container)this.metaContainer.getBeanInstance();
        if (this.primaryContainerDelegate == null || this.primaryContainer != defCont) {
            this.primaryContainer = defCont;
            this.primaryContainerDelegate = this.metaContainer.getContainerDelegate(defCont);
        }
        return this.primaryContainerDelegate;
    }

    @Override
    public LayoutManager getDefaultLayoutInstance() {
        return this.metaContainer.getDefaultLayout();
    }

    @Override
    public Component getPrimaryComponent(int index) {
        return (Component)this.metaContainer.getSubComponent(index).getBeanInstance();
    }

    @Override
    public void updatePrimaryContainer() {
        Container cont = this.getPrimaryContainer();
        Container contDel = this.getPrimaryContainerDelegate();
        this.layoutDelegate.clearContainer(cont, contDel);
        this.layoutDelegate.setLayoutToContainer(cont, contDel);
        RADVisualComponent[] components = this.metaContainer.getSubComponents();
        if (components.length > 0) {
            Component[] comps = new Component[components.length];
            for (int i = 0; i < components.length; ++i) {
                comps[i] = (Component)components[i].getBeanInstance();
                LayoutSupportManager.ensureFakePeerAttached(comps[i]);
            }
            this.layoutDelegate.addComponentsToContainer(cont, contDel, comps, 0);
        }
    }

    @Override
    public void containerLayoutChanged(PropertyChangeEvent ev) throws PropertyVetoException {
        if (ev != null && ev.getPropertyName() != null) {
            this.layoutDelegate.acceptContainerLayoutChange(LayoutSupportManager.getEventWithValues(ev));
            FormModel formModel = this.metaContainer.getFormModel();
            formModel.fireContainerLayoutChanged(this.metaContainer, ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        } else {
            this.propertySets = null;
        }
        LayoutNode node = this.metaContainer.getLayoutNodeReference();
        if (node != null) {
            if (ev != null && ev.getPropertyName() != null) {
                node.fireLayoutPropertiesChange();
            } else {
                node.fireLayoutPropertySetsChange();
            }
        }
    }

    @Override
    public void componentLayoutChanged(int index, PropertyChangeEvent ev) throws PropertyVetoException {
        RADVisualComponent metacomp = this.metaContainer.getSubComponent(index);
        if (ev != null && ev.getPropertyName() != null) {
            this.layoutDelegate.acceptComponentLayoutChange(index, LayoutSupportManager.getEventWithValues(ev));
            FormModel formModel = this.metaContainer.getFormModel();
            formModel.fireComponentLayoutChanged(metacomp, ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
            if (metacomp.getNodeReference() != null) {
                metacomp.getNodeReference().firePropertyChangeHelper(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
            }
        } else {
            if (metacomp.getNodeReference() != null) {
                metacomp.getNodeReference().fireComponentPropertySetsChange();
            }
            metacomp.resetConstraintsProperties();
        }
    }

    private static PropertyChangeEvent getEventWithValues(PropertyChangeEvent ev) {
        Object oldVal = ev.getOldValue();
        Object newVal = ev.getNewValue();
        if (oldVal instanceof FormProperty.ValueWithEditor) {
            ev = new PropertyChangeEvent(ev.getSource(), ev.getPropertyName(), ((FormProperty.ValueWithEditor)oldVal).getValue(), ((FormProperty.ValueWithEditor)newVal).getValue());
        }
        return ev;
    }

    private LayoutListener getLayoutListener() {
        if (this.layoutListener == null) {
            this.layoutListener = new LayoutListener();
        }
        return this.layoutListener;
    }

    private static void ensureFakePeerAttached(Component comp) {
        if (comp != null && comp.getParent() != null) {
            comp.getParent().remove(comp);
        }
        FakePeerSupport.attachFakePeer(comp);
        if (comp instanceof Container) {
            FakePeerSupport.attachFakePeerRecursively((Container)comp);
        }
    }

    private class LayoutListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private LayoutListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            Object source = ev.getSource();
            String eventName = ev.getPropertyName();
            if (source instanceof FormProperty && ("propertyValue".equals(eventName) || "propertyValueAndEditor".equals(eventName))) {
                ev = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, ((FormProperty)((Object)source)).getName(), ev.getOldValue(), ev.getNewValue());
                LayoutSupportManager.this.containerLayoutChanged(ev);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            Object source = ev.getSource();
            if (source instanceof FormProperty && "currentEditor".equals(ev.getPropertyName())) {
                ev = new PropertyChangeEvent(LayoutSupportManager.this.layoutDelegate, null, null, null);
                try {
                    LayoutSupportManager.this.containerLayoutChanged(ev);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

