/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.javadoc.Doc;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javadoc.DocEnv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.builder.ElementsService;

public final class ElementUtilities {
    private final Context ctx;
    private final ElementsService delegate;
    private final CompilationInfo info;
    private static final Set<Modifier> NOT_OVERRIDABLE = EnumSet.of(Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE);

    ElementUtilities(@NonNull CompilationInfo info) {
        this(info.impl.getJavacTask(), info);
    }

    ElementUtilities(@NonNull JavacTaskImpl jt) {
        this(jt, null);
    }

    private ElementUtilities(@NonNull JavacTaskImpl jt, @NullAllowed CompilationInfo info) {
        this.ctx = jt.getContext();
        this.delegate = ElementsService.instance(this.ctx);
        this.info = info;
    }

    public TypeElement enclosingTypeElement(Element element) throws IllegalArgumentException {
        return ElementUtilities.enclosingTypeElementImpl(element);
    }

    static TypeElement enclosingTypeElementImpl(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if ((element = element.getEnclosingElement()).getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public Element getImplementationOf(ExecutableElement method, TypeElement origin) {
        return this.delegate.getImplementationOf(method, origin);
    }

    public boolean isSynthetic(Element element) {
        return (((Symbol)element).flags() & 0x1000L) != 0L || (((Symbol)element).flags() & 0x1000000000L) != 0L;
    }

    public boolean overridesMethod(ExecutableElement element) {
        return this.delegate.overridesMethod(element);
    }

    public static String getBinaryName(TypeElement element) throws IllegalArgumentException {
        if (element instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)element)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Doc javaDocFor(Element element) {
        if (element != null) {
            DocEnv env = DocEnv.instance((Context)this.ctx);
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return env.getClassDoc((Symbol.ClassSymbol)element);
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    return env.getFieldDoc((Symbol.VarSymbol)element);
                }
                case METHOD: {
                    if (((Symbol.MethodSymbol)element).enclClass().getKind() == ElementKind.ANNOTATION_TYPE) {
                        return env.getAnnotationTypeElementDoc((Symbol.MethodSymbol)element);
                    }
                    return env.getMethodDoc((Symbol.MethodSymbol)element);
                }
                case CONSTRUCTOR: {
                    return env.getConstructorDoc((Symbol.MethodSymbol)element);
                }
                case PACKAGE: {
                    return env.getPackageDoc((Symbol.PackageSymbol)element);
                }
            }
        }
        return null;
    }

    public Element elementFor(Doc doc) {
        return doc instanceof JavadocEnv.ElementHolder ? ((JavadocEnv.ElementHolder)doc).getElement() : null;
    }

    public Iterable<? extends Element> getMembers(TypeMirror type, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        if (type != null) {
            JavacElements elements = JavacElements.instance(this.ctx);
            JavacTypes types = JavacTypes.instance(this.ctx);
            switch (type.getKind()) {
                case DECLARED: 
                case UNION: 
                case INTERSECTION: {
                    TypeElement te = (TypeElement)((DeclaredType)type).asElement();
                    if (te == null) break;
                    for (Element element : elements.getAllMembers(te)) {
                        if (acceptor != null && !acceptor.accept(element, type) || this.isHidden(element, members, elements, types)) continue;
                        members.add(element);
                    }
                    if (te.getKind().isClass() || te.getKind().isInterface() && Source.instance(this.ctx).allowDefaultMethods()) {
                        Symbol.VarSymbol thisPseudoMember = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._this, (Type.ClassType)te.asType(), (Symbol.ClassSymbol)te);
                        if (acceptor == null || acceptor.accept(thisPseudoMember, type)) {
                            members.add(thisPseudoMember);
                        }
                        if (te.getSuperclass().getKind() == TypeKind.DECLARED) {
                            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._super, (Type.ClassType)te.getSuperclass(), (Symbol.ClassSymbol)te);
                            if (acceptor == null || acceptor.accept(varSymbol, type)) {
                                members.add(varSymbol);
                            }
                        }
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)type) : List.nil();
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (acceptor != null && !acceptor.accept(classPseudoMember, type)) break;
                    members.add(classPseudoMember);
                    break;
                }
                case ARRAY: {
                    for (Element element : elements.getAllMembers((TypeElement)((Object)((Type)type).tsym))) {
                        if (acceptor != null && !acceptor.accept(element, type)) continue;
                        members.add(element);
                    }
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = Source.instance(this.ctx).allowGenerics() ? List.of((Type)type) : List.nil();
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (acceptor != null && !acceptor.accept(classPseudoMember, type)) break;
                    members.add(classPseudoMember);
                }
            }
        }
        return members;
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null) {
            TypeElement cls = scope.getEnclosingClass();
            if (cls != null) {
                for (Element element : scope.getLocalElements()) {
                    if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, members, elements, types)) continue;
                    members.add(element);
                }
                TypeMirror type = cls.asType();
                for (Element element : elements.getAllMembers(cls)) {
                    if (acceptor != null && !acceptor.accept(element, type) || this.isHidden(element, members, elements, types)) continue;
                    members.add(element);
                }
            } else {
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind().isClass() || element.getKind().isInterface() || acceptor != null && (element.getEnclosingElement() == null || !acceptor.accept(element, element.getEnclosingElement().asType())) || this.isHidden(element, members, elements, types)) continue;
                    members.add(element);
                }
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList<Element> members = new ArrayList<Element>();
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                if (acceptor != null && !acceptor.accept(element, null) || this.isHidden(element, members, elements, types)) continue;
                members.add(element);
            }
            scope = scope.getEnclosingScope();
        }
        return members;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor acceptor) {
        ArrayList<TypeElement> members = new ArrayList<TypeElement>();
        JavacTrees trees = JavacTrees.instance(this.ctx);
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        for (CompilationUnitTree unit : Collections.singletonList(this.info.getCompilationUnit())) {
            Scope scope;
            TreePath path = new TreePath(unit);
            for (scope = ((Trees)trees).getScope(path); scope != null && scope instanceof JavacScope && !((JavacScope)scope).isStarImportScope(); scope = scope.getEnclosingScope()) {
                for (Element element : scope.getLocalElements()) {
                    if (!element.getKind().isClass() && !element.getKind().isInterface() || this.isHidden(element, members, elements, types) || acceptor != null && !acceptor.accept(element, null)) continue;
                    members.add((TypeElement)element);
                }
            }
            Element element = ((Trees)trees).getElement(path);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                for (Element element2 : element.getEnclosedElements()) {
                    if (this.isHidden(element2, members, elements, types) || acceptor != null && !acceptor.accept(element2, null)) continue;
                    members.add((TypeElement)element2);
                }
            }
            while (scope != null) {
                for (Element element3 : scope.getLocalElements()) {
                    if (!element3.getKind().isClass() && !element3.getKind().isInterface() || this.isHidden(element3, members, elements, types) || acceptor != null && !acceptor.accept(element3, null)) continue;
                    members.add((TypeElement)element3);
                }
                scope = scope.getEnclosingScope();
            }
        }
        return members;
    }

    private boolean isHidden(Element member, java.util.List<? extends Element> members, Elements elements, Types types) {
        ListIterator<? extends Element> it = members.listIterator();
        while (it.hasNext()) {
            Element hider = it.next();
            if (hider == member) {
                return true;
            }
            if (!hider.getSimpleName().contentEquals(member.getSimpleName())) continue;
            if (elements.hides(member, hider)) {
                it.remove();
                continue;
            }
            if (member instanceof VariableElement && hider instanceof VariableElement && (!member.getKind().isField() || hider.getKind().isField())) {
                return true;
            }
            TypeMirror memberType = member.asType();
            TypeMirror hiderType = hider.asType();
            if (memberType.getKind() == TypeKind.EXECUTABLE && hiderType.getKind() == TypeKind.EXECUTABLE) {
                if (!types.isSubsignature((ExecutableType)hiderType, (ExecutableType)memberType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence name, ExecutableType method, TypeElement enclClass) {
        return this.delegate.alreadyDefinedIn(name, method, enclClass);
    }

    public boolean isMemberOf(Element e, TypeElement type) {
        return this.delegate.isMemberOf(e, type);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement method) {
        return this.delegate.getOverriddenMethod(method);
    }

    public boolean implementsMethod(ExecutableElement element) {
        return this.delegate.implementsMethod(element);
    }

    public java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl) {
        return this.findUnimplementedMethods(impl, impl);
    }

    public java.util.List<? extends ExecutableElement> findOverridableMethods(TypeElement type) {
        ArrayList<ExecutableElement> overridable = new ArrayList<ExecutableElement>();
        EnumSet<Modifier> notOverridable = EnumSet.copyOf(NOT_OVERRIDABLE);
        if (!type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            notOverridable.add(Modifier.ABSTRACT);
        }
        for (ExecutableElement ee : ElementFilter.methodsIn(this.info.getElements().getAllMembers(type))) {
            EnumSet<Modifier> set = EnumSet.copyOf(notOverridable);
            set.removeAll(ee.getModifiers());
            if (set.size() != notOverridable.size() || this.overridesPackagePrivateOutsidePackage(ee, type) || this.isOverridden(ee, type)) continue;
            overridable.add(ee);
        }
        Collections.reverse(overridable);
        return overridable;
    }

    public boolean hasGetter(TypeElement type, VariableElement field, CodeStyle codeStyle) {
        boolean isBoolean = field.asType().getKind() == TypeKind.BOOLEAN;
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String name = CodeStyleUtils.computeGetterName(field.getSimpleName(), isBoolean, isStatic, codeStyle);
        return this.delegate.alreadyDefinedIn(name, field.asType(), List.nil(), type);
    }

    public boolean hasSetter(TypeElement type, VariableElement field, CodeStyle codeStyle) {
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String name = CodeStyleUtils.computeSetterName(field.getSimpleName(), isStatic, codeStyle);
        return this.delegate.alreadyDefinedIn(name, this.info.getTypes().getNoType(TypeKind.VOID), List.of(field.asType()), type);
    }

    public boolean isErroneous(@NullAllowed Element e) {
        if (e == null) {
            return true;
        }
        TypeMirror type = e.asType();
        if (type == null) {
            return false;
        }
        if (type.getKind() == TypeKind.ERROR || type.getKind() == TypeKind.OTHER) {
            return true;
        }
        return type instanceof Type && ((Type)type).isErroneous();
    }

    public boolean isEffectivelyFinal(VariableElement e) {
        return (((Symbol)((Object)e)).flags() & 0x20000000010L) != 0L;
    }

    @CheckForNull
    public Element findElement(@NonNull String description) {
        TypeElement el;
        if (description.contains("(")) {
            String methodFullName = description.substring(0, description.indexOf(40));
            String className = methodFullName.substring(0, methodFullName.lastIndexOf(46));
            TypeElement clazz = this.info.getElements().getTypeElement(className);
            if (clazz == null) {
                return null;
            }
            String methodSimpleName = methodFullName.substring(methodFullName.lastIndexOf(46) + 1);
            boolean constructor = clazz.getSimpleName().contentEquals(methodSimpleName);
            String parameters = description.substring(description.indexOf(40) + 1, description.lastIndexOf(41) + 1);
            int lastParamStart = 0;
            int angleDepth = 0;
            ArrayList<TypeMirror> types = new ArrayList<TypeMirror>();
            block6: for (int paramIndex = 0; paramIndex < parameters.length(); ++paramIndex) {
                switch (parameters.charAt(paramIndex)) {
                    case '<': {
                        ++angleDepth;
                        continue block6;
                    }
                    case '>': {
                        --angleDepth;
                        continue block6;
                    }
                    case ',': {
                        if (angleDepth > 0) continue block6;
                    }
                    case ')': {
                        if (paramIndex <= lastParamStart) continue block6;
                        String type = parameters.substring(lastParamStart, paramIndex).replace("...", "[]");
                        types.add(this.info.getTypes().erasure(this.info.getTreeUtilities().parseType(type, this.info.getTopLevelElements().get(0))));
                        lastParamStart = paramIndex + 1;
                    }
                }
            }
            block7: for (ExecutableElement ee : constructor ? ElementFilter.constructorsIn(clazz.getEnclosedElements()) : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (!constructor && !ee.getSimpleName().contentEquals(methodSimpleName) || ee.getParameters().size() != types.size()) continue;
                Iterator<? extends TypeMirror> real = ((ExecutableType)this.info.getTypes().erasure(ee.asType())).getParameterTypes().iterator();
                Iterator expected = types.iterator();
                while (real.hasNext() && expected.hasNext()) {
                    if (this.info.getTypes().isSameType(real.next(), (TypeMirror)expected.next())) continue;
                    continue block7;
                }
                assert (real.hasNext() == expected.hasNext());
                return ee;
            }
        }
        if ((el = this.info.getElements().getTypeElement(description)) != null) {
            return el;
        }
        int dot = description.lastIndexOf(46);
        if (dot != -1) {
            String simpleName = description.substring(dot + 1);
            el = this.info.getElements().getTypeElement(description.substring(0, dot));
            if (el != null) {
                for (VariableElement var : ElementFilter.fieldsIn(el.getEnclosedElements())) {
                    if (!var.getSimpleName().contentEquals(simpleName)) continue;
                    return var;
                }
            }
        }
        return null;
    }

    private java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl, TypeElement element) {
        ArrayList<ExecutableElement> undef = new ArrayList<ExecutableElement>();
        JavacTypes types = JavacTypes.instance(this.ctx);
        com.sun.tools.javac.code.Types implTypes = com.sun.tools.javac.code.Types.instance(this.ctx);
        DeclaredType implType = (DeclaredType)impl.asType();
        if (element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element element2 : element.getEnclosedElements()) {
                ExecutableElement ee;
                Element element3;
                if (element2.getKind() != ElementKind.METHOD || !element2.getModifiers().contains((Object)Modifier.ABSTRACT) || (element3 = this.getImplementationOf(ee = (ExecutableElement)element2, impl)) != null && (element3 != ee || impl == element) || implTypes.asSuper((Type)((Object)implType), (Symbol)ee.getEnclosingElement()) == null) continue;
                undef.add(ee);
            }
        }
        for (TypeMirror typeMirror : types.directSupertypes(element.asType())) {
            for (ExecutableElement executableElement : this.findUnimplementedMethods(impl, (TypeElement)((DeclaredType)typeMirror).asElement())) {
                boolean exists = false;
                ExecutableType eeType = (ExecutableType)types.asMemberOf(implType, executableElement);
                for (ExecutableElement existing : undef) {
                    TypeMirror eeReturnType;
                    ExecutableType existingType;
                    if (!existing.getSimpleName().contentEquals(executableElement.getSimpleName()) || !types.isSubsignature(existingType = (ExecutableType)types.asMemberOf(implType, existing), eeType)) continue;
                    TypeMirror existingReturnType = existingType.getReturnType();
                    if (!types.isSubtype(existingReturnType, eeReturnType = eeType.getReturnType())) {
                        if (types.isSubtype(eeReturnType, existingReturnType)) {
                            undef.remove(existing);
                            undef.add(executableElement);
                        } else if (existingReturnType.getKind() == TypeKind.DECLARED && eeReturnType.getKind() == TypeKind.DECLARED) {
                            DeclaredType subType;
                            Env<AttrContext> env = Enter.instance(this.ctx).getClassEnv((Symbol.TypeSymbol)((Object)impl));
                            DeclaredType declaredType = subType = env != null ? this.findCommonSubtype((DeclaredType)existingReturnType, (DeclaredType)eeReturnType, env) : null;
                            if (subType != null) {
                                Type mt;
                                undef.remove(existing);
                                Symbol.MethodSymbol ms = ((Symbol.MethodSymbol)existing).clone((Symbol)((Object)impl));
                                ms.type = mt = implTypes.createMethodTypeWithReturn((Type.MethodType)ms.type, (Type)((Object)subType));
                                undef.add(ms);
                            }
                        }
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                undef.add(executableElement);
            }
        }
        return undef;
    }

    private DeclaredType findCommonSubtype(DeclaredType type1, DeclaredType type2, Env<AttrContext> env) {
        java.util.List<DeclaredType> subtypes1 = this.getSubtypes(type1, env);
        java.util.List<DeclaredType> subtypes2 = this.getSubtypes(type2, env);
        if (subtypes1 == null || subtypes2 == null) {
            return null;
        }
        Types types = this.info.getTypes();
        for (DeclaredType subtype1 : subtypes1) {
            for (DeclaredType subtype2 : subtypes2) {
                if (types.isSubtype(subtype1, subtype2)) {
                    return subtype1;
                }
                if (!types.isSubtype(subtype2, subtype1)) continue;
                return subtype2;
            }
        }
        return null;
    }

    private java.util.List<DeclaredType> getSubtypes(DeclaredType baseType, Env<AttrContext> env) {
        LinkedList<DeclaredType> subtypes = new LinkedList<DeclaredType>();
        HashSet<TypeElement> elems = new HashSet<TypeElement>();
        LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
        bases.add(baseType);
        ClassIndex index = this.info.getClasspathInfo().getClassIndex();
        Trees trees = this.info.getTrees();
        Types types = this.info.getTypes();
        Resolve resolve = Resolve.instance(this.ctx);
        while (!bases.isEmpty()) {
            DeclaredType head = (DeclaredType)bases.remove();
            TypeElement elem = (TypeElement)head.asElement();
            if (!elems.add(elem)) continue;
            subtypes.add(head);
            java.util.List<? extends TypeMirror> tas = head.getTypeArguments();
            boolean isRaw = !tas.iterator().hasNext();
            Set<ElementHandle<TypeElement>> implementors = index.getElements(ElementHandle.create(elem), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class));
            if (implementors == null) {
                return null;
            }
            block1: for (ElementHandle<TypeElement> eh : implementors) {
                TypeElement e = eh.resolve(this.info);
                if (e == null || !resolve.isAccessible(env, (Symbol.TypeSymbol)((Object)e))) continue;
                if (isRaw) {
                    DeclaredType dt = types.getDeclaredType(e, new TypeMirror[0]);
                    bases.add(dt);
                    continue;
                }
                HashMap<Element, TypeMirror> map = new HashMap<Element, TypeMirror>();
                TypeMirror sup = e.getSuperclass();
                if (sup.getKind() == TypeKind.DECLARED && ((DeclaredType)sup).asElement() == elem) {
                    DeclaredType dt = (DeclaredType)sup;
                    Iterator<? extends TypeMirror> iterator = tas.iterator();
                    Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                    while (it.hasNext() && iterator.hasNext()) {
                        TypeMirror stm;
                        TypeMirror basetm = iterator.next();
                        if (basetm == (stm = it.next())) continue;
                        if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                        map.put(((TypeVariable)stm).asElement(), basetm);
                    }
                    if (it.hasNext() != iterator.hasNext()) {
                        continue;
                    }
                } else {
                    for (TypeMirror typeMirror : e.getInterfaces()) {
                        if (((DeclaredType)typeMirror).asElement() != elem) continue;
                        DeclaredType dt = (DeclaredType)typeMirror;
                        Iterator<? extends TypeMirror> ittas = tas.iterator();
                        Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                        while (it.hasNext() && ittas.hasNext()) {
                            TypeMirror stm;
                            TypeMirror basetm = ittas.next();
                            if (basetm == (stm = it.next())) continue;
                            if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                            map.put(((TypeVariable)stm).asElement(), basetm);
                        }
                        if (it.hasNext() != ittas.hasNext()) continue block1;
                    }
                }
                bases.add(this.getDeclaredType(e, map, types));
            }
        }
        return subtypes;
    }

    private DeclaredType getDeclaredType(TypeElement e, HashMap<? extends Element, ? extends TypeMirror> map, Types types) {
        java.util.List<? extends TypeParameterElement> tpes = e.getTypeParameters();
        TypeMirror[] targs = new TypeMirror[tpes.size()];
        int i = 0;
        for (TypeParameterElement typeParameterElement : tpes) {
            TypeMirror t = map.get(typeParameterElement);
            targs[i++] = t != null ? t : typeParameterElement.asType();
        }
        Element encl = e.getEnclosingElement();
        if ((encl.getKind().isClass() || encl.getKind().isInterface()) && !((TypeElement)encl).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)encl, map, types), e, targs);
        }
        return types.getDeclaredType(e, targs);
    }

    private boolean isOverridden(ExecutableElement methodBase, TypeElement origin) {
        Element impl = this.getImplementationOf(methodBase, origin);
        return impl != null && (impl != methodBase || origin == methodBase.getEnclosingElement());
    }

    private boolean overridesPackagePrivateOutsidePackage(ExecutableElement ee, TypeElement impl) {
        Name elemPackageName = this.getPackageName(ee);
        Name currentPackageName = this.getPackageName(impl);
        return !ee.getModifiers().contains((Object)Modifier.PRIVATE) && !ee.getModifiers().contains((Object)Modifier.PUBLIC) && !ee.getModifiers().contains((Object)Modifier.PROTECTED) && !currentPackageName.contentEquals(elemPackageName);
    }

    private Name getPackageName(Element e) {
        while (e.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e.getEnclosingElement()).getQualifiedName();
    }

    private static class ElementNameVisitor
    extends SimpleElementVisitor8<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitExecutable(ExecutableElement e, Boolean p) {
            if (p != Boolean.TRUE || e.getEnclosingElement() == null) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(e.getSimpleName());
            }
            return e.getEnclosingElement().accept(this, p).append(".").append(e.getSimpleName());
        }

        @Override
        public StringBuilder visitVariable(VariableElement e, Boolean p) {
            if (p != Boolean.TRUE || e.getEnclosingElement() == null) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(e.getSimpleName());
            }
            return e.getEnclosingElement().accept(this, p).append(".").append(e.getSimpleName());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }
}

