/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.OpenBitSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.util.Pair;
import org.openide.util.Parameters;

class QueryUtil {
    QueryUtil() {
    }

    static Query createUsagesQuery(@NonNull String resourceName, @NonNull Set<? extends ClassIndexImpl.UsageType> mask, @NonNull BooleanClause.Occur operator) {
        Parameters.notNull((CharSequence)"resourceName", (Object)resourceName);
        Parameters.notNull((CharSequence)"mask", mask);
        Parameters.notNull((CharSequence)"operator", (Object)operator);
        if (operator == BooleanClause.Occur.SHOULD) {
            BooleanQuery query = new BooleanQuery();
            for (ClassIndexImpl.UsageType usageType : mask) {
                WildcardQuery subQuery = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, EnumSet.of(usageType), false));
                query.add((Query)subQuery, operator);
            }
            return query;
        }
        if (operator == BooleanClause.Occur.MUST) {
            return new WildcardQuery(DocumentUtil.referencesTerm(resourceName, mask, false));
        }
        throw new IllegalArgumentException();
    }

    @NonNull
    static Query createPackageUsagesQuery(@NonNull String packageName, @NonNull Set<? extends ClassIndexImpl.UsageType> mask, @NonNull BooleanClause.Occur operator) {
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        Parameters.notNull((CharSequence)"mask", mask);
        String pattern = Pattern.quote(packageName) + "\\.[^\\.]+";
        if (operator == BooleanClause.Occur.SHOULD) {
            BooleanQuery query = new BooleanQuery();
            for (ClassIndexImpl.UsageType usageType : mask) {
                Term t = DocumentUtil.referencesTerm(pattern, EnumSet.of(usageType), true);
                query.add(Queries.createQuery((String)t.field(), (String)t.field(), (String)t.text(), (Queries.QueryKind)Queries.QueryKind.REGEXP), operator);
            }
            return query;
        }
        if (operator == BooleanClause.Occur.MUST) {
            Term t = DocumentUtil.referencesTerm(pattern, mask, true);
            return Queries.createQuery((String)t.field(), (String)t.field(), (String)t.text(), (Queries.QueryKind)Queries.QueryKind.REGEXP);
        }
        throw new IllegalArgumentException();
    }

    @CheckForNull
    static Query scopeFilter(@NonNull Query q, @NonNull Set<? extends ClassIndex.SearchScopeType> scope) {
        assert (q != null);
        assert (scope != null);
        TreeSet<? extends String> pkgs = null;
        for (ClassIndex.SearchScopeType searchScopeType : scope) {
            Set<? extends String> sp = searchScopeType.getPackages();
            if (sp == null) continue;
            if (pkgs == null) {
                pkgs = new TreeSet<String>();
            }
            pkgs.addAll(sp);
        }
        if (pkgs == null) {
            return q;
        }
        switch (pkgs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                BooleanQuery qFiltered = new BooleanQuery();
                qFiltered.add((Query)new TermQuery(new Term("packageName", (String)pkgs.iterator().next())), BooleanClause.Occur.MUST);
                qFiltered.add(q, BooleanClause.Occur.MUST);
                return qFiltered;
            }
        }
        return new FilteredQuery(q, (Filter)new PackagesFilter((SortedSet<String>)pkgs));
    }

    static Pair<StoppableConvertor<Term, String>, Term> createPackageFilter(@NullAllowed String prefix, boolean directOnly) {
        Term startTerm = new Term("packageName", prefix);
        PackageFilter filter = new PackageFilter(startTerm, directOnly);
        return Pair.of((Object)filter, (Object)startTerm);
    }

    private static final class PackagesFilter
    extends Filter {
        private final SortedSet<String> pkgs;

        PackagesFilter(@NonNull SortedSet<String> pkgs) {
            assert (pkgs != null);
            this.pkgs = pkgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public DocIdSet getDocIdSet(@NonNull IndexReader reader) throws IOException {
            TermEnum enumerator = this.getTermEnum(reader);
            if (enumerator.term() == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            try {
                OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
                int[] docs = new int[32];
                int[] freqs = new int[32];
                try (TermDocs termDocs = reader.termDocs();){
                    do {
                        int count;
                        Term term;
                        if ((term = enumerator.term()) == null) {
                            break;
                        }
                        termDocs.seek(term);
                        while ((count = termDocs.read(docs, freqs)) != 0) {
                            for (int i = 0; i < count; ++i) {
                                bitSet.set((long)docs[i]);
                            }
                        }
                    } while (enumerator.next());
                }
                OpenBitSet openBitSet = bitSet;
                return openBitSet;
            }
            finally {
                enumerator.close();
            }
        }

        private TermEnum getTermEnum(@NonNull IndexReader reader) {
            return new TermEnum(){
                private Iterator<String> pkgsIt;
                private String current;
                {
                    this.pkgsIt = PackagesFilter.this.pkgs.iterator();
                    this.next();
                }

                public boolean next() {
                    if (this.pkgsIt == null) {
                        throw new IllegalStateException("Already closed.");
                    }
                    if (this.pkgsIt.hasNext()) {
                        this.current = this.pkgsIt.next();
                        return true;
                    }
                    this.current = null;
                    return false;
                }

                public Term term() {
                    return this.current == null ? null : new Term("packageName", this.current);
                }

                public int docFreq() {
                    return this.current == null ? -1 : 0;
                }

                public void close() throws IOException {
                    this.pkgsIt = null;
                }
            };
        }
    }

    private static final class PackageFilter
    implements StoppableConvertor<Term, String> {
        private static final StoppableConvertor.Stop STOP = new StoppableConvertor.Stop();
        private final boolean directOnly;
        private final boolean all;
        private final String fieldName;
        private final String value;

        PackageFilter(@NonNull Term startTerm, boolean directOnly) {
            this.fieldName = startTerm.field();
            this.value = startTerm.text();
            this.directOnly = directOnly;
            this.all = this.value.length() == 0;
        }

        public String convert(Term currentTerm) throws StoppableConvertor.Stop {
            if (this.fieldName != currentTerm.field()) {
                throw STOP;
            }
            String currentText = currentTerm.text();
            if (this.all || currentText.startsWith(this.value)) {
                int index;
                if (this.directOnly && (index = currentText.indexOf(46, this.value.length())) > 0) {
                    currentText = currentText.substring(0, index);
                }
                return currentText;
            }
            return null;
        }
    }
}

