/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.target.iterator.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.project.SourceGroup;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private Class target;
    BeanTreeView btv;
    private final InstanceContent selectionContent = new InstanceContent();
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private final AbstractLookup lookup;
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] folders, Class target, String preselectedFileName) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "ACSD_BrowseFolders" : "ACSD_BrowseFiles")));
        this.folders = folders;
        this.target = target;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders));
        this.manager.setRootContext((Node)rootNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedNodes")) {
                    Node[] newnodes;
                    Node[] oldnodes = (Node[])evt.getOldValue();
                    if (oldnodes != null) {
                        for (Node oldnode : oldnodes) {
                            DataObject dobj = (DataObject)oldnode.getLookup().lookup(DataObject.class);
                            if (dobj == null) continue;
                            BrowseFolders.this.selectionContent.remove((Object)dobj.getPrimaryFile());
                        }
                    }
                    if ((newnodes = (Node[])evt.getNewValue()) != null) {
                        for (Node newnode : newnodes) {
                            DataObject dobj = (DataObject)newnode.getLookup().lookup(DataObject.class);
                            if (dobj == null) continue;
                            BrowseFolders.this.selectionContent.add((Object)dobj.getPrimaryFile());
                        }
                    }
                }
            }
        });
        this.expandSelection(preselectedFileName);
        this.folderPanel.add((Component)this.btv, "Center");
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.selectionContent);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandSelection(String preselectedFileName) {
        int i;
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        Node sel = null;
        if (preselectedFileName != null && preselectedFileName.length() > 0) {
            for (i = 0; i < nodes.length; ++i) {
                try {
                    sel = NodeOp.findPath((Node)nodes[i], (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(preselectedFileName, "/"), String.class, (boolean)false));
                    break;
                }
                catch (NodeNotFoundException e) {
                    continue;
                }
            }
        }
        if (sel == null) {
            this.btv.expandNode(root);
            for (i = 0; i < nodes.length; ++i) {
                this.btv.expandNode(nodes[i]);
                if (i != 0) continue;
                sel = nodes[i];
            }
        }
        if (sel != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{sel});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] folders, Class target, String preselectedFileName) {
        BrowseFolders bf = new BrowseFolders(folders, target, preselectedFileName);
        JButton selectButton = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "LBL_SelectFolder" : "LBL_SelectFile")));
        selectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "ACSD_SelectFolder" : "ACSD_SelectFile")));
        JButton cancelButton = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_Cancel"));
        Object[] options = new JButton[]{selectButton, cancelButton};
        OptionsListener optionsListener = new OptionsListener(bf, target);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles")), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;
        private Class target;

        public OptionsListener(BrowseFolders browsePanel, Class target) {
            this.browsePanel = browsePanel;
            this.target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataObject dobj;
            Node[] selection;
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command) && (selection = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && selection.length > 0 && (dobj = (DataObject)selection[0].getLookup().lookup(DataObject.class)) != null && dobj.getClass().isAssignableFrom(this.target)) {
                this.result = dobj.getPrimaryFile();
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private static class FileObjectComparator
    implements Comparator<FileObject> {
        private FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            return fo1.getName().compareTo(fo2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] groups) {
            this.groups = groups;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            FileObject fObj = null;
            SourceGroup group = null;
            boolean isFile = false;
            if (key instanceof SourceGroup) {
                fObj = ((SourceGroup)key).getRootFolder();
                group = (SourceGroup)key;
            } else if (key instanceof Key) {
                fObj = ((Key)key).folder;
                group = ((Key)key).group;
                if (!fObj.isFolder()) {
                    isFile = true;
                }
            }
            try {
                FilterNode fn;
                DataObject dobj = DataObject.find((FileObject)fObj);
                FilterNode filterNode = fn = isFile ? new FilterNode(dobj.getNodeDelegate(), Children.LEAF) : new FilterNode(dobj.getNodeDelegate(), (Children)new SourceGroupsChildren(fObj, group));
                if (key instanceof SourceGroup) {
                    fn.setDisplayName(group.getDisplayName());
                }
                return new Node[]{fn};
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        private Collection getKeys() {
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] files = this.fo.getChildren();
            Arrays.sort(files, new FileObjectComparator());
            ArrayList<Key> children = new ArrayList<Key>(files.length);
            if (BrowseFolders.this.target == DataFolder.class) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isFolder() || !this.group.contains(files[i])) continue;
                    children.add(new Key(files[i], this.group));
                }
            } else {
                int i;
                for (i = 0; i < files.length; ++i) {
                    if (!this.group.contains(files[i]) || !files[i].isFolder()) continue;
                    children.add(new Key(files[i], this.group));
                }
                for (i = 0; i < files.length; ++i) {
                    if (!this.group.contains(files[i]) || files[i].isFolder()) continue;
                    children.add(new Key(files[i], this.group));
                }
            }
            return children;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }
}

