/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.IgnoreRule;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public abstract class IgnoreUnignoreCommand
extends GitCommand {
    protected final File[] files;
    private final ProgressMonitor monitor;
    private final Set<File> ignoreFiles;
    private final FileListener listener;
    protected static final Logger LOG = Logger.getLogger(IgnoreUnignoreCommand.class.getName());

    public IgnoreUnignoreCommand(Repository repository, GitClassFactory gitFactory, File[] files, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.files = files;
        this.monitor = monitor;
        this.ignoreFiles = new LinkedHashSet<File>();
        this.listener = listener;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String message = null;
            if (this.files.length == 0) {
                message = "Files to ignore must not be empty.";
            } else if (Arrays.asList(this.files).contains(this.getRepository().getWorkTree())) {
                message = "Cannot ignore working tree root.";
            }
            if (message != null) {
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    @Override
    protected void run() {
        File workTree = this.getRepository().getWorkTree();
        for (int i = 0; i < this.files.length && !this.monitor.isCanceled(); ++i) {
            File f = this.files[i];
            try {
                this.changeIgnoreStatus(f);
                this.listener.notifyFile(f, Utils.getRelativePath(workTree, f));
                continue;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                this.monitor.notifyError(ex.getLocalizedMessage());
            }
        }
    }

    private void changeIgnoreStatus(File f) throws IOException {
        File parent = f;
        boolean isDirectory = f.isDirectory();
        StringBuilder sb = new StringBuilder(47);
        if (isDirectory) {
            sb.append('/');
        }
        boolean cont = true;
        while (cont) {
            sb.insert(0, parent.getName()).insert(0, '/');
            parent = parent.getParentFile();
            String path = sb.toString();
            if (parent.equals(this.getRepository().getWorkTree())) {
                if (this.addStatement(new File(parent, ".gitignore"), path, isDirectory, false) && this.handleAdditionalIgnores(path, isDirectory)) {
                    this.addStatement(new File(parent, ".gitignore"), path, isDirectory, true);
                }
                cont = false;
                continue;
            }
            cont = this.addStatement(new File(parent, ".gitignore"), path, isDirectory, false);
        }
    }

    private boolean addStatement(File gitIgnore, String path, boolean isDirectory, boolean forceWrite) throws IOException {
        List<IgnoreRule> ignoreRules = this.parse(gitIgnore);
        return this.addStatement(ignoreRules, gitIgnore, path, isDirectory, forceWrite, true) == IgnoreNode.MatchResult.CHECK_PARENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void save(File gitIgnore, List<IgnoreRule> ignoreRules) throws IOException {
        BufferedWriter bw = null;
        File tmpFile = File.createTempFile(".gitignore", "tmp", gitIgnore.getParentFile());
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Constants.CHARSET));
            ListIterator<IgnoreRule> it = ignoreRules.listIterator();
            while (it.hasNext()) {
                String s = it.next().getPattern(false);
                bw.write(s, 0, s.length());
                if (!it.hasNext()) continue;
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
            if (!tmpFile.renameTo(gitIgnore)) {
                File tmpCopy = this.generateTempFile(".gitignore", gitIgnore.getParentFile());
                boolean success = false;
                if (gitIgnore.renameTo(tmpCopy)) {
                    success = tmpFile.renameTo(gitIgnore);
                    if (!success) {
                        tmpCopy.renameTo(gitIgnore);
                    }
                    tmpCopy.delete();
                }
                if (!success) {
                    tmpFile.delete();
                    throw new IOException("Cannot write to " + gitIgnore.getAbsolutePath());
                }
            }
        }
        this.ignoreFiles.add(gitIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IgnoreRule> parse(File gitIgnore) throws IOException {
        LinkedList<IgnoreRule> rules = new LinkedList<IgnoreRule>();
        if (gitIgnore.exists()) {
            BufferedReader br = null;
            try {
                String txt;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(gitIgnore), Constants.CHARSET));
                while ((txt = br.readLine()) != null) {
                    rules.add(new IgnoreRule(txt));
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return rules;
    }

    public File[] getModifiedIgnoreFiles() {
        return this.ignoreFiles.toArray(new File[this.ignoreFiles.size()]);
    }

    protected abstract IgnoreNode.MatchResult addStatement(List<IgnoreRule> var1, File var2, String var3, boolean var4, boolean var5, boolean var6) throws IOException;

    protected static String escapeChars(String path) {
        return path.replace("[", "[[]").replace("*", "[*]").replace("?", "[?]");
    }

    protected final IgnoreNode.MatchResult checkExcludeFile(String path, boolean isDirectory) throws IOException {
        File excludeFile = new File(this.getRepository().getDirectory(), "info/exclude");
        List<IgnoreRule> ignoreRules = this.parse(excludeFile);
        return this.addStatement(ignoreRules, excludeFile, path, isDirectory, false, true);
    }

    protected final IgnoreNode.MatchResult checkGlobalExcludeFile(String path, boolean directory) throws IOException {
        File excludeFile = this.getGlobalExcludeFile();
        if (excludeFile != null && excludeFile.canRead()) {
            List<IgnoreRule> ignoreRules = this.parse(excludeFile);
            return this.addStatement(ignoreRules, excludeFile, path, directory, false, false);
        }
        return IgnoreNode.MatchResult.NOT_IGNORED;
    }

    private File generateTempFile(String basename, File parent) {
        File tempFile = new File(parent, basename);
        while (tempFile.exists()) {
            tempFile = new File(parent, basename + Long.toString(System.currentTimeMillis()));
        }
        return tempFile;
    }

    private File getGlobalExcludeFile() {
        Repository repository = this.getRepository();
        String path = ((CoreConfig)repository.getConfig().get(CoreConfig.KEY)).getExcludesFile();
        File excludesfile = null;
        FS fs = repository.getFS();
        if (path != null) {
            excludesfile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
        }
        return excludesfile;
    }

    protected abstract boolean handleAdditionalIgnores(String var1, boolean var2) throws IOException;
}

