/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model;

import java.util.Comparator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;

public interface CsmOffsetable
extends CsmObject {
    public static final Comparator<? super CsmOffsetable> OFFSET_COMPARATOR = new OffsetableComparator<CsmOffsetable>();

    public CsmFile getContainingFile();

    public int getStartOffset();

    public int getEndOffset();

    public Position getStartPosition();

    public Position getEndPosition();

    public CharSequence getText();

    public static final class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        @Override
        public int compare(CsmOffsetable o1, CsmOffsetable o2) {
            int diff = o1.getStartOffset() - o2.getStartOffset();
            if (diff == 0) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
            return diff;
        }
    }

    public static interface Position {
        public int getOffset();

        public int getLine();

        public int getColumn();
    }
}

