/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT1Data;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1BlockReader;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class CadT1Dual {
    private static final boolean DEBUG = false;
    private static final boolean IDEBUG = false;
    private static final boolean PROTDEBUG = false;
    private static int INTERFACE_CONTACTED = 0;
    private static int INTERFACE_CONTACTLESS = 1;
    byte[] sendBuffer = new byte[40];
    byte[] recvBuffer = new byte[40];
    protected static final int MAX_IFS_SIZE = 32;
    private static final byte BLOCKPROTOCOL_POWERUP = -16;
    private static final byte BLOCKPROTOCOL_POWERDOWN = -32;
    private static final byte BLOCKPROTOCOL_COMMAND = -128;
    private static final int BLOCKPROTOCOL_OFFSET_OPCODE = 0;
    private static final int BLOCKPROTOCOL_OFFSET_LENGTH = 1;
    private static final int BLOCKPROTOCOL_OFFSET_MESSAGE = 3;
    private static final int BLOCKPROTOCOL_HEADER_SIZE = 3;
    private static final int BLOCKPROTOCOL_OVERHEAD_SIZE = 4;
    OutputStream contacted_out;
    OutputStream contactless_out;
    OutputStream out;
    ServerT1Data contacted_state = new ServerT1Data();
    ServerT1Data contactless_state = new ServerT1Data();
    ServerT1Data current_interface_state = this.contacted_state;
    byte[] contacted_atr;
    byte[] contactless_atr;
    T1BlockReader contacted_input_channel;
    T1BlockReader contactless_input_channel;
    T1BlockReader current_input_channel;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;
    private static final byte T1_EVENT_POWERRESET = 3;
    private byte secondaryInterfaceEvent = 0;
    private boolean waitingForTheFirstBlock = true;
    Vector<CadServerListener> listeners = new Vector();

    public void setContactedATR(byte[] byArray) {
        this.contacted_atr = byArray;
    }

    public void setContactlessATR(byte[] byArray) {
        this.contactless_atr = byArray;
    }

    public byte getSecondaryInterfaceEvent() {
        byte by = this.secondaryInterfaceEvent;
        this.secondaryInterfaceEvent = 0;
        return by;
    }

    private void switchToContacted() {
        this.out = this.contacted_out;
        this.current_interface_state = this.contacted_state;
        this.current_input_channel = this.contacted_input_channel;
    }

    private void switchToContactless() {
        if (this.contactless_out != null && this.out == this.contacted_out) {
            this.out = this.contactless_out;
            this.current_interface_state = this.contactless_state;
            this.current_input_channel = this.contactless_input_channel;
        }
    }

    public byte getActiveInterface() {
        if (this.out != null && this.out == this.contactless_out) {
            return (byte)INTERFACE_CONTACTLESS;
        }
        return (byte)INTERFACE_CONTACTED;
    }

    public CadT1Dual(Socket socket) {
        try {
            this.current_input_channel = this.contacted_input_channel = new T1BlockReader(socket);
            this.out = this.contacted_out = socket.getOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setContactlessSocket(Socket socket) {
        try {
            this.contactless_input_channel = new T1BlockReader(socket);
            this.contactless_out = socket.getOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void sendBlockProtocolMessage(int n) throws IOException, T1Exception {
        this.out.write(this.sendBuffer, 0, n);
        this.out.flush();
    }

    private synchronized int receiveBlockProtocolMessage(boolean bl) throws IOException, T1Exception {
        int n;
        while (true) {
            n = 0;
            if (this.waitingForTheFirstBlock || bl) {
                while (true) {
                    this.switchToContactless();
                    n = this.current_input_channel.readT1Block(this.recvBuffer, true);
                    if (n == 0) {
                        this.switchToContacted();
                        n = this.current_input_channel.readT1Block(this.recvBuffer, true);
                        if (n == 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    break;
                }
            } else {
                while ((n = this.current_input_channel.readT1Block(this.recvBuffer, false)) == 0) {
                }
            }
            if (this.recvBuffer[0] == -32) {
                this.powerDown();
                continue;
            }
            if (this.recvBuffer[0] != -16) break;
            this.powerUpAndSendATR();
        }
        if (this.recvBuffer[0] != -128) {
            throw new T1Exception(-126);
        }
        this.waitingForTheFirstBlock = false;
        return n;
    }

    private synchronized boolean exchangeBlock(T1Block t1Block, T1Block t1Block2, boolean bl) throws IOException, T1Exception {
        byte[] byArray = t1Block.toByteArray();
        int n = byArray.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(n >> 8);
        this.sendBuffer[2] = (byte)n;
        System.arraycopy(byArray, 0, this.sendBuffer, 3, n);
        this.sendBuffer[n + 3] = CadT1Dual.computeLRC(this.sendBuffer, 0, n + 3);
        this.sendBlockProtocolMessage(n + 4);
        n = this.receiveBlockProtocolMessage(bl);
        if (n == -1) {
            return false;
        }
        t1Block2.readBlockInstance(this.recvBuffer, 3, n - 4);
        return true;
    }

    public synchronized boolean receiveBlock(T1Block t1Block, boolean bl) throws IOException, T1Exception {
        int n = this.receiveBlockProtocolMessage(bl);
        t1Block.readBlockInstance(this.recvBuffer, 3, n - 4);
        return true;
    }

    private boolean sendATR(byte[] byArray) throws IOException, T1Exception {
        int n = byArray.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(n >> 8);
        this.sendBuffer[2] = (byte)n;
        System.arraycopy(byArray, 0, this.sendBuffer, 3, n);
        this.sendBuffer[n + 3] = CadT1Dual.computeLRC(this.sendBuffer, 0, n + 3);
        this.sendBlockProtocolMessage(n + 4);
        this.current_interface_state.serverState = 2;
        return true;
    }

    public int getMaxIFSSize() {
        return 32;
    }

    private static byte computeLRC(byte[] byArray, int n, int n2) {
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            by = (byte)(by ^ byArray[n + i]);
        }
        return by;
    }

    public boolean t1Wait() throws T1Exception {
        return this.t1Wait(this.current_interface_state);
    }

    public boolean t1Abort() throws T1Exception {
        return this.t1Abort(this.current_interface_state);
    }

    public boolean t1LastBlockReceived() {
        return this.current_interface_state.lastBlockFlag;
    }

    public void addCadServerListener(CadServerListener cadServerListener) {
        this.listeners.addElement(cadServerListener);
    }

    private void notifyPowerDown() {
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((CadServerListener)vector.elementAt(i)).powerDown(new CadEvent(this.current_interface_state));
        }
    }

    public static void discardIncomingGetLe(CadT1Dual cadT1Dual, short[] sArray, short s, short s2) {
        ServerT1Data serverT1Data = cadT1Dual.current_interface_state;
        byte[] byArray = serverT1Data.nextIBlock.getINFBytes();
        int n = serverT1Data.nextIBlock.getLEN() - serverT1Data.nextBlockDataOffset;
        sArray[0] = (short)n;
        serverT1Data.lastBlockFlag = serverT1Data.nextIBlock.isLastBlock();
        s2 = (short)(s2 + n);
        short s3 = (short)(s - s2);
        short s4 = 0;
        if (s3 < 0) {
            if (s3 == -1) {
                s4 = (short)(serverT1Data.nextBlockDataOffset + n - 1);
                sArray[1] = (short)(byArray[s4] & 0xFF);
            } else if (n >= 2) {
                s4 = (short)(serverT1Data.nextBlockDataOffset + n - 2);
                sArray[1] = (short)(byArray[s4] << 8);
                sArray[1] = (short)(sArray[1] + (short)(byArray[(short)(s4 + 1)] & 0xFF));
            } else {
                s4 = (short)(serverT1Data.nextBlockDataOffset + n - 1);
                sArray[1] = (short)(sArray[1] << 8);
                sArray[1] = (short)(sArray[1] + (short)(byArray[s4] & 0xFF));
            }
        }
        serverT1Data.nextIBlock = null;
        serverT1Data.nextBlockDataOffset = 0;
    }

    public static void placeDataInBuffer(CadT1Dual cadT1Dual, byte[] byArray, short[] sArray, short s, short s2) {
        ServerT1Data serverT1Data = cadT1Dual.current_interface_state;
        byte[] byArray2 = serverT1Data.nextIBlock.getINFBytes();
        int n = serverT1Data.nextIBlock.getLEN() - serverT1Data.nextBlockDataOffset;
        if (n + s > s2) {
            int n2 = s2 - s;
            System.arraycopy(byArray2, serverT1Data.nextBlockDataOffset, byArray, s, n2);
            sArray[0] = (short)n2;
            serverT1Data.nextBlockDataOffset += n2;
            serverT1Data.lastBlockFlag = false;
        } else {
            System.arraycopy(byArray2, serverT1Data.nextBlockDataOffset, byArray, s, n);
            sArray[0] = (short)n;
            serverT1Data.lastBlockFlag = serverT1Data.nextIBlock.isLastBlock();
            serverT1Data.nextIBlock = null;
            serverT1Data.nextBlockDataOffset = 0;
        }
    }

    private short t1ReplySBlock(ServerT1Data serverT1Data, boolean[] blArray) throws T1Exception, IOException {
        byte by = serverT1Data.blockIncoming.getSBlockType();
        switch (by) {
            case -64: 
            case -63: {
                throw new T1Exception(-125);
            }
            case -61: {
                throw new T1Exception(-124);
            }
            case -62: {
                boolean bl = true;
                while (bl) {
                    boolean bl2;
                    byte by2;
                    serverT1Data.blockOutgoing.setSBlock((byte)0, (byte)0, -30, 0);
                    boolean bl3 = this.exchangeBlock(serverT1Data.blockOutgoing, serverT1Data.blockIncoming, false);
                    if (!bl3) {
                        this.notifyPowerDown();
                    }
                    if ((by2 = serverT1Data.blockIncoming.getBlockType()) == 0) {
                        bl2 = serverT1Data.blockIncoming.getSequence();
                        if (bl2 != serverT1Data.numSeqRcv) {
                            serverT1Data.numSeqRcv = bl2;
                            serverT1Data.nextIBlock = serverT1Data.blockIncoming;
                            blArray[0] = false;
                            bl = false;
                            continue;
                        }
                        throw new T1Exception(-126);
                    }
                    if (by2 == -128) {
                        bl2 = serverT1Data.blockIncoming.getSequence();
                        if (bl2 != serverT1Data.numSeqTx) {
                            blArray[0] = true;
                            continue;
                        }
                        throw new T1Exception(-124);
                    }
                    throw new T1Exception(-126);
                }
                break;
            }
            default: {
                throw new T1Exception(-124);
            }
        }
        return 0;
    }

    public short t1SndBlockRcvAck(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws T1Exception {
        try {
            boolean bl3 = true;
            block7: while (bl3) {
                this.current_interface_state.blockOutgoing.setIBlock((byte)0, (byte)0, this.current_interface_state.numSeq, bl, byArray, n, n2);
                T1Block t1Block = new T1Block();
                boolean bl4 = this.exchangeBlock(this.current_interface_state.blockOutgoing, t1Block, bl2);
                this.current_interface_state.blockIncoming = t1Block;
                if (!bl4) {
                    this.notifyPowerDown();
                }
                if (this.current_interface_state.recvFirstBlock) {
                    this.current_interface_state.resetProtocol();
                    this.current_interface_state.recvFirstBlock = false;
                } else {
                    this.current_interface_state.numSeqTx = this.current_interface_state.numSeq;
                    this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                }
                byte by = this.current_interface_state.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        if (!bl) {
                            throw new T1Exception(-124);
                        }
                        boolean bl5 = this.current_interface_state.blockIncoming.getSequence();
                        if (bl5 != this.current_interface_state.numSeqRcv) {
                            this.current_interface_state.numSeqRcv = bl5;
                            this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                            bl3 = false;
                            this.current_interface_state.lastBlockFlag = false;
                            continue block7;
                        }
                        this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                        bl3 = true;
                        continue block7;
                    }
                    case -128: {
                        boolean bl5 = this.current_interface_state.blockIncoming.getSequence();
                        if (bl) {
                            if (bl5 != this.current_interface_state.numSeqTx) {
                                throw new T1Exception(-126);
                            }
                            this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                            bl3 = true;
                            continue block7;
                        }
                        if (bl5 != this.current_interface_state.numSeqTx) {
                            bl3 = false;
                            continue block7;
                        }
                        this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                        bl3 = true;
                        continue block7;
                    }
                    case -64: {
                        boolean[] blArray = new boolean[]{bl3};
                        short s = this.t1ReplySBlock(this.current_interface_state, blArray);
                        bl3 = blArray[0];
                        if (s == 0) continue block7;
                        return s;
                    }
                }
                throw new T1Exception(-126);
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public short t1RcvBlock(byte[] byArray, short[] sArray, short s, short s2) throws T1Exception {
        try {
            if (this.current_interface_state.nextIBlock == null) {
                boolean bl = true;
                block12: while (bl) {
                    boolean bl2;
                    boolean bl3;
                    if (this.current_interface_state.recvFirstBlock) {
                        T1Block t1Block = new T1Block();
                        bl3 = this.receiveBlock(t1Block, false);
                        this.current_interface_state.blockIncoming = t1Block;
                        if (!bl3) {
                            this.notifyPowerDown();
                        }
                        byte by = this.current_interface_state.blockIncoming.getBlockType();
                        switch (by) {
                            case 0: {
                                bl2 = this.current_interface_state.blockIncoming.getSequence();
                                if (this.current_interface_state.recvFirstBlock) {
                                    this.current_interface_state.resetProtocol();
                                    this.current_interface_state.recvFirstBlock = false;
                                }
                                if (bl2 != this.current_interface_state.numSeqRcv) {
                                    this.current_interface_state.numSeqRcv = bl2;
                                    this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                                    this.current_interface_state.nextBlockDataOffset = 0;
                                    bl = false;
                                    break;
                                }
                                bl = true;
                                break;
                            }
                            case -128: {
                                throw new T1Exception(-126);
                            }
                            case -64: {
                                throw new T1Exception(-126);
                            }
                            default: {
                                throw new T1Exception(-126);
                            }
                        }
                        continue;
                    }
                    this.current_interface_state.blockOutgoing.setRBlock((byte)0, (byte)0, !this.current_interface_state.numSeqRcv);
                    bl3 = this.exchangeBlock(this.current_interface_state.blockOutgoing, this.current_interface_state.blockIncoming, false);
                    if (!bl3) {
                        this.notifyPowerDown();
                    }
                    byte by = this.current_interface_state.blockIncoming.getBlockType();
                    switch (by) {
                        case 0: {
                            bl2 = this.current_interface_state.blockIncoming.getSequence();
                            if (bl2 != this.current_interface_state.numSeqRcv) {
                                this.current_interface_state.numSeqRcv = bl2;
                                this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                                this.current_interface_state.nextBlockDataOffset = 0;
                                bl = false;
                                continue block12;
                            }
                            bl = true;
                            continue block12;
                        }
                        case -128: {
                            bl = true;
                            continue block12;
                        }
                        case -64: {
                            boolean[] blArray = new boolean[]{bl};
                            short s3 = this.t1ReplySBlock(this.current_interface_state, blArray);
                            bl = blArray[0];
                            if (s3 == 0) continue block12;
                            return s3;
                        }
                    }
                    throw new T1Exception(-126);
                }
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    private boolean t1Abort(ServerT1Data serverT1Data) throws T1Exception {
        try {
            boolean bl = true;
            block7: while (bl) {
                this.current_interface_state.blockOutgoing.setSBlock((byte)0, (byte)0, -62, 0);
                boolean bl2 = this.exchangeBlock(this.current_interface_state.blockOutgoing, this.current_interface_state.blockIncoming, false);
                if (!bl2) {
                    this.notifyPowerDown();
                }
                byte by = this.current_interface_state.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean bl3 = this.current_interface_state.blockIncoming.getSequence();
                        if (bl3 != this.current_interface_state.numSeqTx) {
                            bl = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte by2 = this.current_interface_state.blockIncoming.getSBlockType();
                        if (by2 != -30) {
                            throw new T1Exception(-126);
                        }
                        serverT1Data.lastBlockFlag = false;
                        serverT1Data.nextIBlock = null;
                        serverT1Data.nextBlockDataOffset = 0;
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    private boolean t1Wait(ServerT1Data serverT1Data) throws T1Exception {
        try {
            boolean bl = true;
            block7: while (bl) {
                serverT1Data.blockOutgoing.setSBlock((byte)0, (byte)0, -61, 0);
                boolean bl2 = this.exchangeBlock(serverT1Data.blockOutgoing, serverT1Data.blockIncoming, false);
                if (!bl2) {
                    this.notifyPowerDown();
                }
                byte by = serverT1Data.blockIncoming.getBlockType();
                switch (by) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean bl3 = serverT1Data.blockIncoming.getSequence();
                        if (bl3 != serverT1Data.numSeqTx) {
                            bl = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte by2 = serverT1Data.blockIncoming.getSBlockType();
                        if (by2 != -29) {
                            throw new T1Exception(-126);
                        }
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException iOException) {
            throw new T1Exception(-126);
        }
    }

    public static byte t1GetNAD() {
        return 0;
    }

    public short t1GetIFSC() {
        return 32;
    }

    public short t1GetIFSD() {
        return 32;
    }

    private void powerUpAndSendATR() throws T1Exception, IOException {
        this.current_interface_state.resetProtocol();
        if (this.getActiveInterface() == INTERFACE_CONTACTLESS) {
            this.sendATR(this.contactless_atr);
            if (this.secondaryInterfaceEvent == 2) {
                this.secondaryInterfaceEvent = (byte)3;
            } else if (this.secondaryInterfaceEvent != 3) {
                this.secondaryInterfaceEvent = 1;
            }
        } else {
            this.sendATR(this.contacted_atr);
        }
    }

    private void powerDown() {
        this.current_interface_state.resetProtocol();
        if (this.getActiveInterface() == INTERFACE_CONTACTED) {
            this.notifyPowerDown();
        }
        this.secondaryInterfaceEvent = (byte)2;
        this.current_interface_state.serverState = 0;
    }
}

