/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.openide.util.WeakSet;

public final class NativeProjectRegistry {
    public static final String PROPERTY_OPEN_NATIVE_PROJECT = "openNativeProject";
    public static final String PROPERTY_CLOSE_NATIVE_PROJECT = "closeNativeProject";
    public static final String PROPERTY_DELETE_NATIVE_PROJECT = "deleteNativeProject";
    private static final NativeProjectRegistry INSTANCE = new NativeProjectRegistry();
    private static final Logger LOG = Logger.getLogger(NativeProjectRegistry.class.getName());
    private final Set<NativeProject> projects = new HashSet<NativeProject>();
    private final ReentrantReadWriteLock projectsLock = new ReentrantReadWriteLock();
    private final Set<PropertyChangeListener> listeners = new WeakSet();
    private final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();

    private NativeProjectRegistry() {
    }

    public static NativeProjectRegistry getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NativeProject> getOpenProjects() {
        this.projectsLock.readLock().lock();
        try {
            HashSet<NativeProject> hashSet = new HashSet<NativeProject>(this.projects);
            return hashSet;
        }
        finally {
            this.projectsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(NativeProject project) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Open native project {0}", project);
        }
        Collection<NativeProject> oldProjects = this.getOpenProjects();
        this.projectsLock.writeLock().lock();
        try {
            this.projects.add(project);
        }
        finally {
            this.projectsLock.writeLock().unlock();
        }
        Collection<NativeProject> newProjects = this.getOpenProjects();
        this.notifyListeners(oldProjects, newProjects, project, PROPERTY_OPEN_NATIVE_PROJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NativeProject project, boolean isDeleted) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Close native project {0}", project);
        }
        Collection<NativeProject> oldProjects = this.getOpenProjects();
        this.projectsLock.writeLock().lock();
        try {
            this.projects.remove(project);
        }
        finally {
            this.projectsLock.writeLock().unlock();
        }
        Collection<NativeProject> newProjects = this.getOpenProjects();
        if (isDeleted) {
            this.notifyListeners(oldProjects, newProjects, project, PROPERTY_DELETE_NATIVE_PROJECT);
        } else {
            this.notifyListeners(oldProjects, newProjects, project, PROPERTY_CLOSE_NATIVE_PROJECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Collection<NativeProject> oldProjects, Collection<NativeProject> newProjects, NativeProject project, String property) {
        ArrayList<PropertyChangeListener> listeners_copy;
        PropertyChangeEvent ev = new PropertyChangeEvent(project, property, oldProjects, newProjects);
        this.listenersLock.readLock().lock();
        try {
            listeners_copy = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        for (PropertyChangeListener listener : listeners_copy) {
            listener.propertyChange(ev);
        }
    }
}

