/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientParseUtils {
    private static final Logger LOGGER = Logger.getLogger(ClientParseUtils.class.getName());

    public static String getVersion(InputStream is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(FileObject fo) throws IOException, SAXException {
        InputStream inputStream = fo.getInputStream();
        try {
            String string = ParseUtils.getVersion(inputStream, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getVersion(InputSource is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParseException parse(FileObject fo) throws SAXException, IOException {
        InputStream inputStream = fo.getInputStream();
        try {
            SAXParseException sAXParseException = ClientParseUtils.parse(new InputSource(inputStream));
            return sAXParseException;
        }
        finally {
            inputStream.close();
        }
    }

    public static SAXParseException parse(InputSource is) throws SAXException, IOException {
        return ParseUtils.parseDD(is, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource inputSource, EntityResolver resolver) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, resolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if ("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN".equals(publicId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_3.dtd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application-client_5.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_5.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application-client_6.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_6.xsd");
            }
            return null;
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("application-client".equals(rawName)) {
                String version = this.parseVersion(atts.getValue("version"));
                String msg = version != null ? "version:" + version : "Invalid version: null";
                throw new SAXException(msg);
            }
        }

        private String parseVersion(String version) {
            if (version == null) {
                return null;
            }
            try {
                Double.valueOf(version);
                return version;
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.INFO, "Not a valid version: " + version, nfe);
                return null;
            }
        }
    }
}

