/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.AbsoluteOrdering;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrdering;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrderingItems;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.WebFragmentProvider;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.AnnotationHelpers;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngine;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngines;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.WebAppMetadataModelImpl;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public class WebAppMetadataImpl
implements WebAppMetadata {
    private static final Logger LOG = Logger.getLogger(WebAppMetadataImpl.class.getName());
    private WebAppMetadataModelImpl modelImpl;
    private AnnotationHelpers annoHelpers;
    private MetadataUnit metadataUnit;
    private WebApp webXml;
    private long webXmlLastModification = -1L;
    private Map<FileObject, FragmentRec> myRootToFragment = new HashMap<FileObject, FragmentRec>();
    private static final int OTHERS = -1;
    private static final int NOT_FOUND = -2;

    public WebAppMetadataImpl(MetadataUnit metadataUnit, WebAppMetadataModelImpl modelImpl) {
        this.metadataUnit = metadataUnit;
        this.modelImpl = modelImpl;
        this.refreshWebXml();
        this.collectFragments();
        this.registerListener();
    }

    @Override
    public WebApp getRoot() {
        this.refreshWebXml();
        return this.webXml;
    }

    @Override
    public List<WebFragment> getFragments() {
        ArrayList<WebFragment> res = new ArrayList<WebFragment>();
        for (FragmentRec fr : this.myRootToFragment.values()) {
            res.add(fr.fragment);
        }
        return WebAppMetadataImpl.sortFragments(this.webXml, res);
    }

    @Override
    public List<FileObject> getFragmentFiles() {
        ArrayList<FileObject> res = new ArrayList<FileObject>();
        for (FragmentRec fr : this.myRootToFragment.values()) {
            res.add(fr.source);
        }
        return res;
    }

    @Override
    public List<ServletInfo> getServlets() {
        return this.doMerging(MergeEngines.servletsEngine());
    }

    @Override
    public List<FilterInfo> getFilters() {
        return this.doMerging(MergeEngines.filtersEngine());
    }

    @Override
    public List<String> getSecurityRoles() {
        return this.doMerging(MergeEngines.securityRolesEngine());
    }

    @Override
    public List<ResourceRef> getResourceRefs() {
        return this.doMerging(MergeEngines.resourceRefsEngine());
    }

    @Override
    public List<ResourceEnvRef> getResourceEnvRefs() {
        return this.doMerging(MergeEngines.resourceEnvRefsEngine());
    }

    @Override
    public List<EnvEntry> getEnvEntries() {
        return this.doMerging(MergeEngines.resourceEnvEntriesEngine());
    }

    @Override
    public List<MessageDestinationRef> getMessageDestinationRefs() {
        return this.doMerging(MergeEngines.resourceMsgDestsEngine());
    }

    @Override
    public List<ServiceRef> getServiceRefs() {
        return this.doMerging(MergeEngines.resourceServicesEngine());
    }

    @Override
    public List<EjbLocalRef> getEjbLocalRefs() {
        return this.doMerging(MergeEngines.ejbLocalRefsEngine());
    }

    @Override
    public List<EjbRef> getEjbRefs() {
        return this.doMerging(MergeEngines.ejbRefsEngine());
    }

    private <T> List<T> doMerging(MergeEngine<T> eng) {
        eng.clean();
        this.refreshWebXml();
        if (this.webXml != null) {
            boolean complete;
            eng.addItems(this.webXml);
            try {
                complete = this.webXml.isMetadataComplete();
            }
            catch (VersionNotSupportedException ex) {
                complete = true;
            }
            if (complete) {
                return eng.getResult();
            }
        }
        for (WebFragment wf : this.getFragments()) {
            eng.addItems(wf);
        }
        eng.addAnnotations(this.getAnnotationHelpers());
        return eng.getResult();
    }

    private void refreshWebXml() {
        FileObject dd = this.metadataUnit.getDeploymentDescriptor();
        if (dd == null) {
            this.webXml = null;
            this.webXmlLastModification = -1L;
            return;
        }
        dd.refresh();
        long lastModif = dd.lastModified().getTime();
        if (lastModif > this.webXmlLastModification) {
            try {
                this.webXml = DDProvider.getDefault().getDDRoot(dd, true);
                this.webXmlLastModification = lastModif;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error during web.xml parsing!", ex);
                this.webXml = null;
            }
        }
    }

    private void registerListener() {
        this.metadataUnit.getCompilePath().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getPropertyName().equals("entries")) {
                    return;
                }
                try {
                    WebAppMetadataImpl.this.modelImpl.runReadAction(new MetadataModelAction<WebAppMetadata, Void>(){

                        public Void run(WebAppMetadata data) {
                            FileObject[] roots = WebAppMetadataImpl.this.metadataUnit.getCompilePath().getRoots();
                            HashSet<FileObject> rootsSet = new HashSet<FileObject>(Arrays.asList(roots));
                            HashSet oldRoots = new HashSet(WebAppMetadataImpl.this.myRootToFragment.keySet());
                            HashSet<FileObject> intersection = new HashSet<FileObject>(rootsSet);
                            intersection.retainAll(oldRoots);
                            oldRoots.removeAll(rootsSet);
                            for (FileObject fileObject : oldRoots) {
                                WebAppMetadataImpl.this.myRootToFragment.remove(fileObject);
                            }
                            rootsSet.removeAll(intersection);
                            for (FileObject fileObject : rootsSet) {
                                WebAppMetadataImpl.this.addFragmentRec(fileObject);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error during access to compile path", e);
                }
            }
        });
    }

    private void collectFragments() {
        FileObject[] roots;
        for (FileObject root : roots = this.metadataUnit.getCompilePath().getRoots()) {
            this.addFragmentRec(root);
        }
    }

    private void addFragmentRec(FileObject root) {
        FileObject fo = root.getFileObject("META-INF/web-fragment.xml");
        if (fo == null) {
            return;
        }
        fo.refresh();
        try {
            FragmentRec rec = new FragmentRec();
            rec.source = fo;
            rec.fragment = WebFragmentProvider.getDefault().getWebFragmentRoot(fo);
            this.myRootToFragment.put(root, rec);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "Error during web-fragment.xml parsing! File: " + fo + " in the classpath unit : " + root, ex);
        }
    }

    private FragmentRec findFragmentRec(FileObject fo) {
        for (FragmentRec fr : this.myRootToFragment.values()) {
            try {
                if (!fr.source.getURL().equals(fo.getURL())) continue;
                return fr;
            }
            catch (FileStateInvalidException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private AnnotationHelpers getAnnotationHelpers() {
        if (this.annoHelpers == null) {
            this.annoHelpers = new AnnotationHelpers(this.modelImpl.getHelper());
        }
        return this.annoHelpers;
    }

    static List<WebFragment> sortFragments(WebApp webXml, List<WebFragment> list) {
        assert (list != null);
        AbsoluteOrdering[] absOrder = null;
        try {
            if (webXml != null) {
                absOrder = webXml.getAbsoluteOrdering();
            }
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
        return absOrder == null ? WebAppMetadataImpl.sortFragmentsRelatively(list) : WebAppMetadataImpl.sortFragmentsAbsolutely(webXml, list);
    }

    private static List<WebFragment> sortFragmentsRelatively(List<WebFragment> frags) {
        List<Constraint> constraints = WebAppMetadataImpl.extractConstraints(frags);
        List<Integer> others = WebAppMetadataImpl.extractOthers(frags, constraints);
        List<Integer> sorted = WebAppMetadataImpl.sort(constraints);
        ArrayList<WebFragment> res = new ArrayList<WebFragment>();
        for (int f : sorted) {
            if (f == -1) {
                for (int o : others) {
                    res.add(frags.get(o));
                }
                continue;
            }
            res.add(frags.get(f));
        }
        return res;
    }

    private static List<Constraint> extractConstraints(List<WebFragment> list) {
        ArrayList<Constraint> res = new ArrayList<Constraint>();
        int no = -1;
        for (WebFragment f : list) {
            ++no;
            RelativeOrdering[] os = f.getOrdering();
            if (os == null) continue;
            for (RelativeOrdering o : os) {
                RelativeOrderingItems before;
                RelativeOrderingItems after = o.getAfter();
                if (after != null) {
                    int maxi = after.sizeName();
                    for (int i = 0; i < maxi; ++i) {
                        int fragNo = WebAppMetadataImpl.findFragment(list, after.getName(i));
                        if (fragNo == -2) continue;
                        res.add(new Constraint(fragNo, no));
                    }
                    if (after.getOthers() != null) {
                        res.add(new Constraint(-1, no));
                    }
                }
                if ((before = o.getBefore()) == null) continue;
                int maxi = before.sizeName();
                for (int i = 0; i < maxi; ++i) {
                    int fragNo = WebAppMetadataImpl.findFragment(list, before.getName(i));
                    if (fragNo == -2) continue;
                    res.add(new Constraint(no, fragNo));
                }
                if (before.getOthers() == null) continue;
                res.add(new Constraint(no, -1));
            }
        }
        return res;
    }

    private static List<Integer> extractOthers(List<WebFragment> list, List<Constraint> constraints) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int maxi = list.size();
        for (int i = 0; i < maxi; ++i) {
            boolean referenced = false;
            for (Constraint c : constraints) {
                if (!c.references(i)) continue;
                referenced = true;
                break;
            }
            if (referenced) continue;
            res.add(i);
        }
        return res;
    }

    private static List<Integer> sort(List<Constraint> constraints) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (!constraints.isEmpty()) {
            int item = -1;
            Constraint c = null;
            int maxi = constraints.size();
            for (int i = 0; i < maxi; ++i) {
                c = constraints.get(i);
                if (!WebAppMetadataImpl.isReady(constraints, c.op1, i)) continue;
                item = i;
                break;
            }
            if (item < 0) {
                return null;
            }
            constraints.remove(item);
            if (!res.contains(c.op1)) {
                res.add(c.op1);
            }
            if (WebAppMetadataImpl.isReferenced(constraints, c.op2)) continue;
            res.add(c.op2);
        }
        return res;
    }

    private static boolean isReady(List<Constraint> constraints, int f, int except) {
        int maxi = constraints.size();
        for (int i = 0; i < maxi; ++i) {
            if (i == except) continue;
            Constraint c = constraints.get(i);
            if (c.op2 != f) continue;
            return false;
        }
        return true;
    }

    private static boolean isReferenced(List<Constraint> constraints, int f) {
        for (Constraint c : constraints) {
            if (c.op1 != f && c.op2 != f) continue;
            return true;
        }
        return false;
    }

    private static int findFragment(List<WebFragment> list, String name) {
        int res = -1;
        for (WebFragment f : list) {
            ++res;
            try {
                String[] names = f.getName();
                if (names == null) continue;
                for (String n : names) {
                    if (!n.equals(name)) continue;
                    return res;
                }
            }
            catch (VersionNotSupportedException e) {
            }
        }
        return -2;
    }

    private static List<WebFragment> sortFragmentsAbsolutely(WebApp webXml, List<WebFragment> list) {
        assert (webXml != null);
        AbsoluteOrdering[] order = null;
        try {
            order = webXml.getAbsoluteOrdering();
        }
        catch (VersionNotSupportedException e) {
            LOG.log(Level.SEVERE, "sortFragmentsAbsolutely failed", e);
            return null;
        }
        assert (order != null);
        List<Integer> res = new ArrayList<Integer>();
        for (AbsoluteOrdering o : order) {
            WebAppMetadataImpl.addFragmentsIntoResult(res, list, o.getName());
        }
        res = WebAppMetadataImpl.insertOthers(res, list);
        ArrayList<WebFragment> finalResult = new ArrayList<WebFragment>();
        for (int i : res) {
            finalResult.add(list.get(i));
        }
        return finalResult;
    }

    private static void addFragmentsIntoResult(List<Integer> res, List<WebFragment> list, String[] names) {
        if (names != null) {
            for (String name : names) {
                if (name.equals("<others>")) {
                    res.add(-1);
                    continue;
                }
                int x = WebAppMetadataImpl.findFragment(list, name);
                if (x == -2) continue;
                res.add(x);
            }
        }
    }

    private static List<Integer> insertOthers(List<Integer> res, List<WebFragment> list) {
        ArrayList<Integer> others = new ArrayList<Integer>();
        int maxi = list.size();
        for (int i = 0; i < maxi; ++i) {
            if (res.contains(i)) continue;
            others.add(i);
        }
        ArrayList<Integer> finalResult = new ArrayList<Integer>();
        for (int i : res) {
            if (i == -1) {
                finalResult.addAll(others);
                continue;
            }
            finalResult.add(i);
        }
        return finalResult;
    }

    private static class Constraint {
        int op1;
        int op2;

        Constraint(int op1, int op2) {
            this.op1 = op1;
            this.op2 = op2;
        }

        boolean references(int no) {
            return this.op1 == no || this.op2 == no;
        }
    }

    private static class FragmentRec {
        WebFragment fragment;
        FileObject source;

        private FragmentRec() {
        }
    }
}

