/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;

public final class LineSeparatorDetector {
    private static final char LS = '\u2028';
    private static final char PS = '\u2029';
    private static final String LS_LS = String.valueOf('\u2028');
    private static final String LS_PS = String.valueOf('\u2029');
    private static final int AFTER_CR_STATUS = -1;
    private static final int INITIAL_STATUS = 0;
    private static final int CR_SEPARATOR = 1;
    private static final int LF_SEPARATOR = 2;
    private static final int CRLF_SEPARATOR = 3;
    private static final int LS_SEPARATOR = 4;
    private static final int PS_SEPARATOR = 5;
    private int status = 0;
    private String defaultSeparator = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineSeparatorDetector(FileObject fo, FileObject projectDir) {
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileObject)projectDir);
        if (executionEnvironment.isRemote()) {
            this.defaultSeparator = "\n";
        }
        if (fo != null && fo.isValid()) {
            InputStream stream = null;
            try {
                int c;
                stream = fo.getInputStream();
                while ((c = stream.read()) != -1) {
                    this.resolveSeparator((char)c);
                    if (!this.isSeparatorResolved()) continue;
                    break;
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    public String getInitialSeparator() {
        String separator;
        switch (this.status) {
            case 1: {
                separator = "\r";
                break;
            }
            case 2: {
                separator = "\n";
                break;
            }
            case 3: {
                separator = "\r\n";
                break;
            }
            case -1: {
                separator = "\r";
                break;
            }
            case 4: {
                separator = LS_LS;
                break;
            }
            case 5: {
                separator = LS_PS;
                break;
            }
            default: {
                separator = this.defaultSeparator;
            }
        }
        return separator;
    }

    private void resolveSeparator(char ch) {
        block0 : switch (this.status) {
            case 0: {
                switch (ch) {
                    case '\r': {
                        this.status = -1;
                        break;
                    }
                    case '\n': {
                        this.status = 2;
                        break;
                    }
                    case '\u2028': {
                        this.status = 4;
                        break;
                    }
                    case '\u2029': {
                        this.status = 5;
                    }
                }
                break;
            }
            case -1: {
                switch (ch) {
                    case '\n': {
                        this.status = 3;
                        break block0;
                    }
                }
                this.status = 1;
                break;
            }
            default: {
                switch (ch) {
                    case '\r': {
                        this.status = -1;
                        break block0;
                    }
                    case '\n': {
                        this.status = 2;
                    }
                }
            }
        }
    }

    private boolean isSeparatorResolved() {
        return this.status > 0;
    }
}

