/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryNotifyListener;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.commands.SynchronizeQueryCommand;
import org.netbeans.modules.team.commons.LogUtils;
import org.netbeans.modules.team.spi.OwnerInfo;

public class BugzillaQuery {
    public static final String BUGZILLA_ADHOC_QUERY_PREFIX = "bugzilla ad-hoc query nr. ";
    private String name;
    private final BugzillaRepository repository;
    protected QueryController controller;
    private final Set<String> issues = new HashSet<String>();
    protected String urlParameters;
    private boolean initialUrlDef;
    private boolean firstRun = true;
    private ColumnDescriptor[] columnDescriptors;
    private OwnerInfo info;
    private boolean saved;
    protected long lastRefresh;
    private IRepositoryQuery iquery;
    private List<QueryNotifyListener> notifyListeners;

    public BugzillaQuery(BugzillaRepository repository) {
        this(null, null, repository, null, false, false, true);
    }

    public BugzillaQuery(String name, BugzillaRepository repository, String urlParameters, boolean saved, boolean urlDef, boolean initControler) {
        this(name, null, repository, urlParameters, saved, urlDef, initControler);
    }

    public BugzillaQuery(String name, IRepositoryQuery query, BugzillaRepository repository, String urlParameters, boolean saved, boolean urlDef, boolean initControler) {
        this.repository = repository;
        this.saved = saved;
        this.name = name;
        this.iquery = query;
        this.urlParameters = urlParameters;
        this.initialUrlDef = urlDef;
        this.lastRefresh = BugzillaConfig.getInstance().getLastQueryRefresh(repository, this.getStoredQueryName());
        if (initControler) {
            this.controller = this.createControler(repository, this, urlParameters);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " - " + this.repository.getDisplayName();
    }

    public synchronized QueryController getController() {
        if (this.controller == null) {
            this.controller = this.createControler(this.repository, this, this.urlParameters);
        }
        return this.controller;
    }

    public BugzillaRepository getRepository() {
        return this.repository;
    }

    protected QueryController createControler(BugzillaRepository r, BugzillaQuery q, String parameters) {
        return new QueryController(r, q, parameters, this.initialUrlDef);
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = BugzillaIssue.getColumnDescriptors(this.repository);
        }
        return this.columnDescriptors;
    }

    boolean refreshIntern(final boolean autoRefresh) {
        assert (this.urlParameters != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final boolean[] ret = new boolean[1];
        this.executeQuery(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Bugzilla.LOG.log(Level.FINE, "refresh start - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                try {
                    QueryProgressListener list;
                    block13: {
                        BugzillaQuery.this.issues.clear();
                        if (BugzillaQuery.this.isSaved() && !BugzillaQuery.this.wasRun() && !BugzillaQuery.this.issues.isEmpty()) {
                            Bugzilla.LOG.log(Level.WARNING, "query {0} supposed to be run for the first time yet already contains issues.", BugzillaQuery.this.getDisplayName());
                            assert (false);
                        }
                        BugzillaQuery.this.firstRun = false;
                        StringBuilder url = new StringBuilder();
                        url.append("/buglist.cgi?query_format=advanced");
                        url.append(BugzillaQuery.this.urlParameters);
                        if (BugzillaQuery.this.iquery == null) {
                            String qName = BugzillaQuery.this.getStoredQueryName();
                            if (qName == null || BugzillaQuery.this.name == null) {
                                qName = BugzillaQuery.BUGZILLA_ADHOC_QUERY_PREFIX + System.currentTimeMillis();
                            }
                            BugzillaQuery.this.iquery = MylynSupport.getInstance().getRepositoryQuery(BugzillaQuery.this.repository.getTaskRepository(), qName);
                            if (BugzillaQuery.this.iquery == null) {
                                BugzillaQuery.this.iquery = MylynSupport.getInstance().createNewQuery(BugzillaQuery.this.repository.getTaskRepository(), qName);
                                MylynSupport.getInstance().addQuery(BugzillaQuery.this.repository.getTaskRepository(), BugzillaQuery.this.iquery);
                            }
                        }
                        String queryUrl = url.toString();
                        BugzillaQuery.this.iquery.setUrl(queryUrl);
                        SynchronizeQueryCommand queryCmd = MylynSupport.getInstance().getCommandFactory().createSynchronizeQueriesCommand(BugzillaQuery.this.repository.getTaskRepository(), BugzillaQuery.this.iquery);
                        list = new QueryProgressListener();
                        queryCmd.addCommandProgressListener((SynchronizeQueryCommand.CommandProgressListener)list);
                        BugzillaQuery.this.repository.getExecutor().execute((BugtrackingCommand)queryCmd, !autoRefresh);
                        ret[0] = queryCmd.hasFailed();
                        if (!ret[0]) break block13;
                        if (BugzillaQuery.this.isSaved()) {
                            for (NbTask t : MylynSupport.getInstance().getTasks(BugzillaQuery.this.iquery)) {
                                BugzillaIssue bzIssue = BugzillaQuery.this.getRepository().getIssueForTask(t);
                                if (bzIssue == null) continue;
                                BugzillaQuery.this.issues.add(bzIssue.getID());
                            }
                        }
                        list.notifyIssues(BugzillaQuery.this.issues);
                        BugzillaConfig.getInstance().putLastQueryRefresh(BugzillaQuery.this.repository, BugzillaQuery.this.getStoredQueryName(), System.currentTimeMillis());
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                        Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                        return;
                    }
                    try {
                        list.notifyIssues(BugzillaQuery.this.issues);
                    }
                    catch (CoreException ex) {
                        Bugzilla.LOG.log(Level.INFO, null, ex);
                        ret[0] = true;
                    }
                    BugzillaConfig.getInstance().putLastQueryRefresh(BugzillaQuery.this.repository, BugzillaQuery.this.getStoredQueryName(), System.currentTimeMillis());
                    BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                }
                catch (Throwable throwable) {
                    BugzillaConfig.getInstance().putLastQueryRefresh(BugzillaQuery.this.repository, BugzillaQuery.this.getStoredQueryName(), System.currentTimeMillis());
                    BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                    Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    throw throwable;
                }
                Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
            }
        });
        return ret[0];
    }

    public String getStoredQueryName() {
        return this.getDisplayName();
    }

    protected void logQueryEvent(int count, boolean autoRefresh) {
        LogUtils.logQueryEvent((String)BugzillaConnector.getConnectorName(), (String)this.name, (int)count, (boolean)false, (boolean)autoRefresh);
    }

    void refresh(String urlParameters, boolean autoReresh) {
        assert (urlParameters != null);
        this.urlParameters = urlParameters;
        this.refreshIntern(autoReresh);
    }

    public void remove() {
        this.repository.removeQuery(this);
    }

    public void setOwnerInfo(OwnerInfo info) {
        this.info = info;
    }

    public OwnerInfo getOwnerInfo() {
        return this.info;
    }

    public IssueStatusProvider.Status getIssueStatus(String id) {
        return this.repository.getIssueCache().getIssue(id).getStatus();
    }

    int getSize() {
        return this.issues.size();
    }

    public String getUrlParameters() {
        return this.getController().getUrlParameters(false);
    }

    public boolean isUrlDefined() {
        return this.getController().isUrlDefined();
    }

    public void setName(String name) {
        this.name = name;
        if (this.iquery != null) {
            this.iquery.setSummary(name);
        }
    }

    public void setSaved(boolean saved) {
        if (saved) {
            this.info = null;
        }
        this.saved = saved;
    }

    public boolean isSaved() {
        return this.saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BugzillaIssue> getIssues() {
        if (this.issues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        Set<String> set = this.issues;
        synchronized (set) {
            ids.addAll(this.issues);
        }
        ArrayList<BugzillaIssue> ret = new ArrayList<BugzillaIssue>();
        for (String id : ids) {
            BugzillaIssue issue = this.repository.getIssueCache().getIssue(id);
            if (issue == null) continue;
            ret.add(issue);
        }
        return ret;
    }

    boolean wasRun() {
        return !this.firstRun;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public boolean canRemove() {
        return true;
    }

    void delete() {
        if (this.iquery != null) {
            MylynSupport.getInstance().deleteQuery(this.iquery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.remove(l);
        }
    }

    protected void fireNotifyDataAdded(BugzillaIssue issue) {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.notifyDataAdded(issue);
        }
    }

    protected void fireNotifyDataRemoved(BugzillaIssue issue) {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.notifyDataRemoved(issue);
        }
    }

    protected void fireStarted() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.started();
        }
    }

    protected void fireFinished() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(Runnable r) {
        this.fireStarted();
        try {
            r.run();
        }
        finally {
            this.fireFinished();
            this.lastRefresh = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryNotifyListener[] getListeners() {
        QueryNotifyListener[] listeners;
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            listeners = list.toArray(new QueryNotifyListener[list.size()]);
        }
        return listeners;
    }

    private List<QueryNotifyListener> getNotifyListeners() {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList<QueryNotifyListener>();
        }
        return this.notifyListeners;
    }

    private class QueryProgressListener
    implements SynchronizeQueryCommand.CommandProgressListener {
        private final Set<String> addedIds = new HashSet<String>();

        private QueryProgressListener() {
        }

        public void queryRefreshStarted(Collection<NbTask> tasks) {
            for (NbTask task : tasks) {
                this.taskAdded(task);
            }
        }

        public void tasksRefreshStarted(Collection<NbTask> tasks) {
            BugzillaQuery.this.getController().switchToDeterminateProgress(tasks.size());
        }

        public void taskAdded(NbTask task) {
            BugzillaQuery.this.issues.add(task.getTaskId());
        }

        public void taskRemoved(NbTask task) {
            BugzillaQuery.this.issues.remove(task.getTaskId());
            BugzillaIssue issue = BugzillaQuery.this.repository.getIssueForTask(task);
            if (issue != null) {
                BugzillaQuery.this.fireNotifyDataRemoved(issue);
            }
        }

        public void taskSynchronized(NbTask task) {
            BugzillaQuery.this.getController().addProgressUnit(BugzillaIssue.getDisplayName(task));
        }

        private void notifyIssues(Set<String> issues) {
            MylynSupport supp = MylynSupport.getInstance();
            try {
                for (String taskId : issues) {
                    BugzillaIssue issue;
                    NbTask task = supp.getTask(BugzillaQuery.this.repository.getUrl(), taskId);
                    if (task == null || (issue = BugzillaQuery.this.repository.getIssueForTask(task)) == null || !this.addedIds.add(task.getTaskId())) continue;
                    BugzillaQuery.this.fireNotifyDataAdded(issue);
                }
            }
            catch (CoreException ex) {
                Bugzilla.LOG.log(Level.INFO, null, ex);
            }
        }
    }
}

