/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.TemplateDiffTypes;
import org.clang.basic.impl.DiagnosticStatics;
import org.clang.basic.tok;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.raw_svector_ostream;

public class Diagnostic {
    private DiagnosticsEngine DiagObj;
    private StringRef StoredDiagMessage;

    public Diagnostic(DiagnosticsEngine DO) {
        this.DiagObj = DO;
        this.StoredDiagMessage = new StringRef();
    }

    public Diagnostic(DiagnosticsEngine DO, StringRef storedDiagMessage) {
        this.DiagObj = DO;
        this.StoredDiagMessage = new StringRef(storedDiagMessage);
    }

    public DiagnosticsEngine getDiags() {
        return this.DiagObj;
    }

    public int getID() {
        return (int)this.DiagObj.CurDiagID;
    }

    public SourceLocation getLocation() {
        return this.DiagObj.CurDiagLoc;
    }

    public boolean hasSourceManager() {
        return this.DiagObj.hasSourceManager();
    }

    public SourceManager getSourceManager() {
        return this.DiagObj.getSourceManager();
    }

    public int getNumArgs() {
        return this.DiagObj.NumDiagArgs;
    }

    public DiagnosticsEngine.ArgumentKind getArgKind(int Idx) {
        assert (Idx < this.getNumArgs()) : "Argument index out of range!";
        return this.DiagObj.DiagArgumentsKind[Idx];
    }

    public std.string getArgStdStr(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_std_string) : "invalid argument accessor!";
        return this.DiagObj.DiagArgumentsStr[Idx];
    }

    public char.ptr getArgCStr(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_c_string) : "invalid argument accessor!";
        return (char.ptr)this.DiagObj.DiagArgumentsVal[Idx];
    }

    public int getArgSInt(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_sint) : "invalid argument accessor!";
        return ((Long)this.DiagObj.DiagArgumentsVal[Idx]).intValue();
    }

    public long getArgUInt(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_uint) : "invalid argument accessor!";
        return (Long)this.DiagObj.DiagArgumentsVal[Idx];
    }

    public IdentifierInfo getArgIdentifier(int Idx) {
        assert (this.getArgKind(Idx) == DiagnosticsEngine.ArgumentKind.ak_identifierinfo) : "invalid argument accessor!";
        return (IdentifierInfo)((Object)this.DiagObj.DiagArgumentsVal[Idx]);
    }

    public Object getRawArg(int Idx) {
        assert (this.getArgKind(Idx) != DiagnosticsEngine.ArgumentKind.ak_std_string) : "invalid argument accessor!";
        return this.DiagObj.DiagArgumentsVal[Idx];
    }

    public long getNumRanges() {
        return this.DiagObj.DiagRanges.size();
    }

    public CharSourceRange getRange(long Idx) {
        assert (Idx < this.getNumRanges()) : "Invalid diagnostic range index!";
        return (CharSourceRange)this.DiagObj.DiagRanges.$at(Idx);
    }

    public ArrayRef<CharSourceRange> getRanges() {
        return new ArrayRef(this.DiagObj.DiagRanges);
    }

    public long getNumFixItHints() {
        return this.DiagObj.DiagFixItHints.size();
    }

    public FixItHint getFixItHint(long Idx) {
        assert (Idx < this.getNumFixItHints()) : "Invalid index!";
        return (FixItHint)this.DiagObj.DiagFixItHints.$at(Idx);
    }

    public ArrayRef<FixItHint> getFixItHints() {
        return new ArrayRef(this.DiagObj.DiagFixItHints);
    }

    public void FormatDiagnostic(SmallString OutStr) {
        if (!this.StoredDiagMessage.empty()) {
            OutStr.append(this.StoredDiagMessage);
            return;
        }
        StringRef Diag = ((DiagnosticIDs)((Object)this.getDiags().getDiagnosticIDs().$arrow())).getDescription(this.getID());
        this.FormatDiagnostic(Diag.begin(), Diag.end(), OutStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FormatDiagnostic(char.ptr DiagStr, char.ptr DiagEnd, SmallString OutStr) {
        SmallVector FormattedArgs = null;
        SmallVector QualTypeVals = null;
        SmallString Tree = null;
        DiagStr = Native.$tryClone((char.ptr)DiagStr);
        try {
            FormattedArgs = new SmallVector(8, (Object)new std.pair((Object)DiagnosticsEngine.ArgumentKind.ak_std_string, null));
            QualTypeVals = new SmallVector(2, null);
            Tree = new SmallString(64);
            int e = this.getNumArgs();
            for (int i = 0; i < e; ++i) {
                if (this.getArgKind(i) != DiagnosticsEngine.ArgumentKind.ak_qualtype) continue;
                QualTypeVals.push_back(this.getRawArg(i));
            }
            block16: while (DiagStr.$noteq((Object)DiagEnd)) {
                if (DiagStr.$at(0) != NativePointer.$((char)'%')) {
                    char.ptr StrEnd = std.find((char.ptr)DiagStr, (char.ptr)DiagEnd, (char)'%');
                    OutStr.append(DiagStr, StrEnd.$index() - DiagStr.$index());
                    DiagStr = StrEnd;
                    continue;
                }
                if (ClangGlobals.isPunctuation(DiagStr.$at(1))) {
                    OutStr.push_back(DiagStr.$at(1));
                    DiagStr.$inc(2);
                    continue;
                }
                DiagStr.$preInc();
                char.ptr Modifier = null;
                char.ptr Argument = null;
                int ModifierLen = 0;
                int ArgumentLen = 0;
                if (!ClangGlobals.isDigit(DiagStr.$at(0))) {
                    Modifier = Native.$tryClone((char.ptr)DiagStr);
                    while (DiagStr.$at(0) == NativePointer.$((char)'-') || DiagStr.$at(0) >= NativePointer.$((char)'a') && DiagStr.$at(0) <= NativePointer.$((char)'z')) {
                        DiagStr.$preInc();
                    }
                    ModifierLen = DiagStr.$sub((abstract_iterator)Modifier);
                    if (DiagStr.$at(0) == NativePointer.$((char)'{')) {
                        DiagStr.$preInc();
                        Argument = Native.$tryClone((char.ptr)DiagStr);
                        DiagStr = DiagnosticStatics.ScanFormat(DiagStr, DiagEnd, NativePointer.$((char)'}'));
                        assert (DiagStr.$noteq((Object)DiagEnd)) : "Mismatched {}'s in diagnostic string!";
                        ArgumentLen = DiagStr.$sub((abstract_iterator)Argument);
                        DiagStr.$preInc();
                    }
                }
                assert (ClangGlobals.isDigit(DiagStr.$star())) : "Invalid format for argument in diagnostic";
                int ArgNo = DiagStr.$star() - 48;
                DiagStr.$preInc();
                int ArgNo2 = ArgNo;
                DiagnosticsEngine.ArgumentKind Kind2 = this.getArgKind(ArgNo);
                if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "diff")) {
                    assert (DiagStr.$star() == NativePointer.$((char)',') && ClangGlobals.isDigit(((char.ptr)DiagStr.$add(1)).$star())) : "Invalid format for diff modifier";
                    DiagStr.$preInc();
                    ArgNo2 = DiagStr.$star() - 48;
                    DiagStr.$preInc();
                    DiagnosticsEngine.ArgumentKind Kind22 = this.getArgKind(ArgNo2);
                    if (Kind2 == DiagnosticsEngine.ArgumentKind.ak_qualtype && Kind22 == DiagnosticsEngine.ArgumentKind.ak_qualtype) {
                        Kind2 = DiagnosticsEngine.ArgumentKind.ak_qualtype_pair;
                    } else {
                        char.ptr Pipe = DiagnosticStatics.ScanFormat(Argument, (char.ptr)Argument.$add(ArgumentLen), NativePointer.$((char)'|'));
                        char.ptr FirstDollar = DiagnosticStatics.ScanFormat(Argument, Pipe, NativePointer.$((char)'$'));
                        char.ptr SecondDollar = DiagnosticStatics.ScanFormat((char.ptr)FirstDollar.$add(1), Pipe, NativePointer.$((char)'$'));
                        char.ptr.array ArgStr1 = new char.ptr.array(new byte[]{37, (byte)(48 + ArgNo)});
                        char.ptr.array ArgStr2 = new char.ptr.array(new byte[]{37, (byte)(48 + ArgNo2)});
                        this.FormatDiagnostic(Argument, FirstDollar, OutStr);
                        this.FormatDiagnostic((char.ptr)ArgStr1, (char.ptr)ArgStr1.$add(2), OutStr);
                        this.FormatDiagnostic((char.ptr)FirstDollar.$add(1), SecondDollar, OutStr);
                        this.FormatDiagnostic((char.ptr)ArgStr2, (char.ptr)ArgStr2.$add(2), OutStr);
                        this.FormatDiagnostic((char.ptr)SecondDollar.$add(1), Pipe, OutStr);
                        continue;
                    }
                }
                switch (Kind2) {
                    case ak_std_string: {
                        std.string S = this.getArgStdStr(ArgNo);
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        OutStr.append(S);
                        break;
                    }
                    case ak_c_string: {
                        std.string S = this.getArgCStr(ArgNo);
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        if (S == null) {
                            S = NativePointer.$((String)"(null)");
                        }
                        OutStr.append((char.ptr)S, std.strlen((char.ptr)S));
                        break;
                    }
                    case ak_sint: {
                        int Val = this.getArgSInt(ArgNo);
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "select")) {
                            DiagnosticStatics.HandleSelectModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "s")) {
                            DiagnosticStatics.HandleIntegerSModifier(Val, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "plural")) {
                            DiagnosticStatics.HandlePluralModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "ordinal")) {
                            DiagnosticStatics.HandleOrdinalModifier(Val, OutStr);
                            break;
                        }
                        assert (ModifierLen == 0) : "Unknown integer modifier";
                        new raw_svector_ostream(OutStr).$out(Val).$destroy();
                        break;
                    }
                    case ak_uint: {
                        long Val = this.getArgUInt(ArgNo);
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "select")) {
                            DiagnosticStatics.HandleSelectModifier(this, Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "s")) {
                            DiagnosticStatics.HandleIntegerSModifier(Val, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "plural")) {
                            DiagnosticStatics.HandlePluralModifier(this, (int)Val, Argument, ArgumentLen, OutStr);
                            break;
                        }
                        if (DiagnosticStatics.ModifierIs(Modifier, ModifierLen, "ordinal")) {
                            DiagnosticStatics.HandleOrdinalModifier(Val, OutStr);
                            break;
                        }
                        assert (ModifierLen == 0) : "Unknown integer modifier";
                        new raw_svector_ostream(OutStr).$out(Val).$destroy();
                        break;
                    }
                    case ak_tokenkind: {
                        raw_svector_ostream Out = null;
                        try {
                            short Kind1 = (Short)this.getRawArg(ArgNo);
                            assert (ModifierLen == 0) : "No modifiers for token kinds yet";
                            Out = new raw_svector_ostream(OutStr);
                            char.ptr S = Native.$tryClone((char.ptr)tok.getPunctuatorSpelling(Kind1));
                            if (S != null) {
                                Out.$out(NativePointer.$((char)'\'')).$out(S).$out(NativePointer.$((char)'\''));
                            } else {
                                S = Native.$tryClone((char.ptr)tok.getKeywordSpelling(Kind1));
                                if (S != null) {
                                    Out.$out(S);
                                } else {
                                    S = Native.$tryClone((char.ptr)DiagnosticStatics.getTokenDescForDiagnostic(Kind1));
                                    if (S != null) {
                                        Out.$out(S);
                                    } else {
                                        S = Native.$tryClone((char.ptr)tok.getTokenName(Kind1));
                                        if (S != null) {
                                            Out.$out(NativePointer.$((char)'<')).$out(S).$out(NativePointer.$((char)'>'));
                                        } else {
                                            Out.$out(NativePointer.$((String)"(null)"));
                                        }
                                    }
                                }
                            }
                            if (Out == null) break;
                        }
                        catch (Throwable throwable) {
                            if (Out != null) {
                                Out.$destroy();
                            }
                            throw throwable;
                        }
                        Out.$destroy();
                        break;
                    }
                    case ak_identifierinfo: {
                        IdentifierInfo II = this.getArgIdentifier(ArgNo);
                        assert (ModifierLen == 0) : "No modifiers for strings yet";
                        if (II == null) {
                            String S = "(null)";
                            OutStr.append((CharSequence)S);
                            continue block16;
                        }
                        new raw_svector_ostream(OutStr).$out('\'').$out(II.getName()).$out('\'').$destroy();
                        break;
                    }
                    case ak_qualtype: 
                    case ak_declarationname: 
                    case ak_nameddecl: 
                    case ak_nestednamespec: 
                    case ak_declcontext: {
                        this.getDiags().ConvertArgToString(Kind2, this.getRawArg(ArgNo), Modifier, ModifierLen, Argument, ArgumentLen, FormattedArgs.data(), FormattedArgs.size(), OutStr, new ArrayRef((SmallVectorImpl)QualTypeVals));
                        break;
                    }
                    case ak_qualtype_pair: {
                        TemplateDiffTypes TDT = new TemplateDiffTypes();
                        TDT.FromType = this.getRawArg(ArgNo);
                        TDT.ToType = this.getRawArg(ArgNo2);
                        TDT.ElideType = this.getDiags().ElideType;
                        TDT.ShowColors = this.getDiags().ShowColors;
                        TDT.TemplateDiffUsed = false;
                        int val = Casts.reinterpret_cast_int((Object)TDT);
                        char.ptr ArgumentEnd = (char.ptr)Argument.$add(ArgumentLen);
                        char.ptr Pipe = DiagnosticStatics.ScanFormat(Argument, ArgumentEnd, NativePointer.$((char)'|'));
                        if (this.getDiags().PrintTemplateTree && Tree.empty()) {
                            TDT.PrintFromType = true;
                            TDT.PrintTree = true;
                            this.getDiags().ConvertArgToString(Kind2, val, Modifier, ModifierLen, Argument, ArgumentLen, FormattedArgs.data(), FormattedArgs.size(), Tree, new ArrayRef((SmallVectorImpl)QualTypeVals));
                            if (!Tree.empty()) {
                                this.FormatDiagnostic((char.ptr)Pipe.$add(1), ArgumentEnd, OutStr);
                                break;
                            }
                        }
                        char.ptr FirstDollar = DiagnosticStatics.ScanFormat(Argument, ArgumentEnd, NativePointer.$((char)'$'));
                        char.ptr SecondDollar = DiagnosticStatics.ScanFormat((char.ptr)FirstDollar.$add(1), ArgumentEnd, NativePointer.$((char)'$'));
                        this.FormatDiagnostic(Argument, FirstDollar, OutStr);
                        TDT.PrintTree = false;
                        TDT.PrintFromType = true;
                        this.getDiags().ConvertArgToString(Kind2, val, Modifier, ModifierLen, Argument, ArgumentLen, FormattedArgs.data(), FormattedArgs.size(), OutStr, new ArrayRef((SmallVectorImpl)QualTypeVals));
                        if (!TDT.TemplateDiffUsed) {
                            FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_qualtype), (Object)TDT.FromType));
                        }
                        this.FormatDiagnostic((char.ptr)FirstDollar.$add(1), SecondDollar, OutStr);
                        TDT.PrintFromType = false;
                        this.getDiags().ConvertArgToString(Kind2, val, Modifier, ModifierLen, Argument, ArgumentLen, FormattedArgs.data(), FormattedArgs.size(), OutStr, new ArrayRef((SmallVectorImpl)QualTypeVals));
                        if (!TDT.TemplateDiffUsed) {
                            FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_qualtype), (Object)TDT.ToType));
                        }
                        this.FormatDiagnostic((char.ptr)SecondDollar.$add(1), Pipe, OutStr);
                    }
                }
                if (Kind2 == DiagnosticsEngine.ArgumentKind.ak_qualtype_pair) continue;
                if (Kind2 != DiagnosticsEngine.ArgumentKind.ak_std_string) {
                    FormattedArgs.push_back((Object)std.make_pair((Object)((Object)Kind2), (Object)this.getRawArg(ArgNo)));
                    continue;
                }
                FormattedArgs.push_back((Object)std.make_pair((Object)((Object)DiagnosticsEngine.ArgumentKind.ak_c_string), (Object)this.getArgStdStr(ArgNo).c_str()));
            }
            OutStr.append((SmallVectorImplChar)Tree);
        }
        finally {
            if (Tree != null) {
                Tree.$destroy();
            }
            if (QualTypeVals != null) {
                QualTypeVals.$destroy();
            }
            if (FormattedArgs != null) {
                FormattedArgs.$destroy();
            }
        }
    }

    public String toString() {
        return "Diagnostic{" + this.StoredDiagMessage + '}';
    }
}

