/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import java.util.Arrays;
import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticMapping;
import org.clang.basic.DiagnosticMappingInfo;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.FixItHint;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.OverloadsShown;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.StoredDiagnostic;
import org.clang.basic.diag;
import org.clang.basic.impl.DiagnosticIDsStatics;
import org.clang.basic.impl.DiagnosticStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfoUIntImpl;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.adt.aliases.DenseMapIteratorUIntType;
import org.llvm.adt.aliases.DenseMapUIntType;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;

public class DiagnosticsEngine
extends RefCountedBase<DiagnosticsEngine>
implements Destructors.ClassWithDestructor {
    byte AllExtensionsSilenced;
    boolean IgnoreAllWarnings;
    boolean WarningsAsErrors;
    boolean EnableAllWarnings;
    boolean ErrorsAsFatal;
    boolean SuppressSystemWarnings;
    boolean SuppressAllDiagnostics;
    boolean ElideType;
    boolean PrintTemplateTree;
    boolean ShowColors;
    private OverloadsShown ShowOverloads;
    int ErrorLimit;
    private int TemplateBacktraceLimit;
    private int ConstexprBacktraceLimit;
    diag.Severity ExtBehavior;
    private IntrusiveRefCntPtr<DiagnosticIDs> Diags;
    private IntrusiveRefCntPtr<DiagnosticOptions> DiagOpts;
    DiagnosticConsumer Client;
    private std_ptr.unique_ptr<DiagnosticConsumer> Owner;
    private boolean OwnsDiagClient;
    private SourceManager SourceMgr;
    private std.list<DiagState> DiagStates;
    private static final Native.ComparatorLower<DiagStatePoint, DiagStatePoint> DiagStatePointComparator = new Native.ComparatorLower<DiagStatePoint, DiagStatePoint>(){

        public boolean $less(DiagStatePoint one, DiagStatePoint other) {
            return one.$less(other);
        }
    };
    private std.vector<DiagStatePoint> DiagStatePoints;
    private std.vector<DiagState> DiagStateOnPushStack;
    boolean ErrorOccurred;
    boolean UncompilableErrorOccurred;
    boolean FatalErrorOccurred;
    boolean UnrecoverableErrorOccurred;
    int TrapNumErrorsOccurred;
    int TrapNumUnrecoverableErrorsOccurred;
    DiagnosticIDs.Level LastDiagLevel;
    int NumWarnings;
    int NumErrors;
    int NumErrorsSuppressed;
    private void.ptr ArgToStringCookie;
    private ArgToStringFn ArgToStringFn;
    private ArgToStringFn DummyArgToStringFn = new ArgToStringFn(){

        @Override
        public void $call(ArgumentKind AK, Object QT, char.ptr Modifier, long ML, char.ptr Argument, long ArgLen, type.ptr<std.pair<ArgumentKind, ?>> PrevArgs, long NumPrevArgs, SmallString Output, void.ptr Cookie, ArrayRef QualTypeVals) {
            DiagnosticStatics.DummyArgToStringFn(AK, QT, Modifier, ML, Argument, ArgLen, PrevArgs, NumPrevArgs, Output, Cookie, QualTypeVals);
        }
    };
    private int DelayedDiagID;
    private std.string DelayedDiagArg1;
    private std.string DelayedDiagArg2;
    std.string FlagValue;
    SourceLocation CurDiagLoc;
    long CurDiagID;
    byte NumDiagArgs;
    byte NumDiagRanges;
    byte NumDiagFixItHints;
    ArgumentKind[] DiagArgumentsKind = new ArgumentKind[10];
    std.string[] DiagArgumentsStr = new std.string[10];
    Object[] DiagArgumentsVal = new Object[10];
    SmallVector<CharSourceRange> DiagRanges;
    SmallVector<FixItHint> DiagFixItHints;

    private DiagState GetCurDiagState() {
        assert (!this.DiagStatePoints.empty());
        return ((DiagStatePoint)this.DiagStatePoints.back()).State;
    }

    private void PushDiagStatePoint(DiagState State, SourceLocation L) {
        FullSourceLoc Loc = new FullSourceLoc(L, this.getSourceManager());
        assert (Loc.isValid()) : "Adding invalid loc point";
        assert (!this.DiagStatePoints.empty() && (((DiagStatePoint)this.DiagStatePoints.back()).Loc.isInvalid() || ((DiagStatePoint)this.DiagStatePoints.back()).Loc.isBeforeInTranslationUnitThan(Loc))) : "Previous point loc comes after or is the same as new one";
        this.DiagStatePoints.push_back((Object)new DiagStatePoint(State, Loc));
    }

    DiagStatePoint GetDiagStatePointForLoc(SourceLocation L) {
        assert (!this.DiagStatePoints.empty());
        return (DiagStatePoint)this.DiagStatePoints.$at(this.GetDiagStatePointForLocIndex(L));
    }

    int GetDiagStatePointForLocIndex(SourceLocation L) {
        assert (!this.DiagStatePoints.empty());
        assert (((DiagStatePoint)this.DiagStatePoints.front()).Loc.isInvalid()) : "Should have created a DiagStatePoint for command-line";
        int size = this.DiagStatePoints.size();
        if (this.SourceMgr == null) {
            return size - 1;
        }
        FullSourceLoc Loc = new FullSourceLoc(L, this.SourceMgr);
        if (Loc.isInvalid()) {
            return size - 1;
        }
        int Pos = size;
        FullSourceLoc LastStateChangePos = ((DiagStatePoint)this.DiagStatePoints.back()).Loc;
        if (LastStateChangePos.isValid() && Loc.isBeforeInTranslationUnitThan(LastStateChangePos)) {
            Pos = ((StdVector.iterator)std.upper_bound((type.iterator)this.DiagStatePoints.begin(), (type.iterator)this.DiagStatePoints.end(), (Object)new DiagStatePoint(null, Loc))).$index();
        }
        return --Pos;
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts) {
        this(diags, DiagOpts, null, true);
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts, DiagnosticConsumer client) {
        this(diags, DiagOpts, client, true);
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts, DiagnosticConsumer client, boolean ShouldOwnClient) {
        this.Diags = new IntrusiveRefCntPtr(diags);
        this.DiagOpts = new IntrusiveRefCntPtr((Object)DiagOpts);
        this.Client = client;
        this.Owner = new std_ptr.unique_ptr();
        this.SourceMgr = null;
        this.DiagStates = new std.list();
        this.DiagStatePoints = new std.vector((Object)new DiagStatePoint());
        this.DiagStateOnPushStack = new std.vector((Object)new DiagState());
        this.DelayedDiagArg1 = new std.string();
        this.DelayedDiagArg2 = new std.string();
        this.FlagValue = new std.string();
        this.CurDiagLoc = new SourceLocation();
        this.DiagArgumentsStr = new std.string[10];
        this.DiagRanges = new SmallVector(8);
        this.DiagFixItHints = new SmallVector(8, (Object)new FixItHint());
        this.setClient(client, ShouldOwnClient);
        this.ArgToStringFn = this.DummyArgToStringFn;
        this.ArgToStringCookie = null;
        this.AllExtensionsSilenced = 0;
        this.IgnoreAllWarnings = false;
        this.WarningsAsErrors = false;
        this.EnableAllWarnings = false;
        this.ErrorsAsFatal = false;
        this.SuppressSystemWarnings = false;
        this.SuppressAllDiagnostics = false;
        this.ElideType = true;
        this.PrintTemplateTree = false;
        this.ShowColors = false;
        this.ShowOverloads = OverloadsShown.Ovl_All;
        this.ExtBehavior = diag.Severity.Ignored;
        this.ErrorLimit = 0;
        this.TemplateBacktraceLimit = 0;
        this.ConstexprBacktraceLimit = 0;
        this.Reset();
    }

    public void $destroy() {
        if (this.OwnsDiagClient && this.Client != null) {
            this.Client.$destroy();
        }
    }

    public IntrusiveRefCntPtr<DiagnosticIDs> getDiagnosticIDs() {
        return this.Diags;
    }

    public DiagnosticOptions getDiagnosticOptions() {
        return (DiagnosticOptions)((Object)this.DiagOpts.$star());
    }

    public DiagnosticConsumer getClient() {
        return this.Client;
    }

    public boolean ownsClient() {
        return std.$noteq_unique_ptr_nullptr_t(this.Owner, null);
    }

    public std_ptr.unique_ptr<DiagnosticConsumer> takeClient() {
        return std.move(this.Owner);
    }

    public boolean hasSourceManager() {
        return this.SourceMgr != null;
    }

    public SourceManager getSourceManager() {
        assert (this.SourceMgr != null) : "SourceManager not set!";
        return this.SourceMgr;
    }

    public void setSourceManager(SourceManager SrcMgr2) {
        this.SourceMgr = SrcMgr2;
    }

    public void pushMappings(SourceLocation Loc) {
        this.DiagStateOnPushStack.push_back((Object)this.GetCurDiagState());
    }

    public boolean popMappings(SourceLocation Loc) {
        if (this.DiagStateOnPushStack.empty()) {
            return false;
        }
        if (this.DiagStateOnPushStack.back() != this.GetCurDiagState()) {
            this.PushDiagStatePoint((DiagState)this.DiagStateOnPushStack.back(), Loc);
        }
        this.DiagStateOnPushStack.pop_back();
        return true;
    }

    public void setClient(DiagnosticConsumer client) {
        this.setClient(client, true);
    }

    public void setClient(DiagnosticConsumer client, boolean ShouldOwnClient) {
        this.Owner.reset((Object)(ShouldOwnClient ? client : null));
        this.Client = client;
    }

    public void setErrorLimit(int Limit) {
        this.ErrorLimit = Limit;
    }

    public void setTemplateBacktraceLimit(int Limit) {
        this.TemplateBacktraceLimit = Limit;
    }

    public int getTemplateBacktraceLimit() {
        return this.TemplateBacktraceLimit;
    }

    public void setConstexprBacktraceLimit(int Limit) {
        this.ConstexprBacktraceLimit = Limit;
    }

    public int getConstexprBacktraceLimit() {
        return this.ConstexprBacktraceLimit;
    }

    public void setIgnoreAllWarnings(boolean Val) {
        this.IgnoreAllWarnings = Val;
    }

    public boolean getIgnoreAllWarnings() {
        return this.IgnoreAllWarnings;
    }

    public void setEnableAllWarnings(boolean Val) {
        this.EnableAllWarnings = Val;
    }

    public boolean getEnableAllWarnings() {
        return this.EnableAllWarnings;
    }

    public void setWarningsAsErrors(boolean Val) {
        this.WarningsAsErrors = Val;
    }

    public boolean getWarningsAsErrors() {
        return this.WarningsAsErrors;
    }

    public void setErrorsAsFatal(boolean Val) {
        this.ErrorsAsFatal = Val;
    }

    public boolean getErrorsAsFatal() {
        return this.ErrorsAsFatal;
    }

    public void setSuppressSystemWarnings(boolean Val) {
        this.SuppressSystemWarnings = Val;
    }

    public boolean getSuppressSystemWarnings() {
        return this.SuppressSystemWarnings;
    }

    public void setSuppressAllDiagnostics() {
        this.setSuppressAllDiagnostics(true);
    }

    public void setSuppressAllDiagnostics(boolean Val) {
        this.SuppressAllDiagnostics = Val;
    }

    public boolean getSuppressAllDiagnostics() {
        return this.SuppressAllDiagnostics;
    }

    public void setElideType() {
        this.setElideType(true);
    }

    public void setElideType(boolean Val) {
        this.ElideType = Val;
    }

    public boolean getElideType() {
        return this.ElideType;
    }

    public void setPrintTemplateTree() {
        this.setPrintTemplateTree(false);
    }

    public void setPrintTemplateTree(boolean Val) {
        this.PrintTemplateTree = Val;
    }

    public boolean getPrintTemplateTree() {
        return this.PrintTemplateTree;
    }

    public void setShowColors() {
        this.setShowColors(false);
    }

    public void setShowColors(boolean Val) {
        this.ShowColors = Val;
    }

    public boolean getShowColors() {
        return this.ShowColors;
    }

    public void setShowOverloads(OverloadsShown Val) {
        this.ShowOverloads = Val;
    }

    public OverloadsShown getShowOverloads() {
        return this.ShowOverloads;
    }

    public void setLastDiagnosticIgnored() {
        if (this.LastDiagLevel == DiagnosticIDs.Level.Fatal) {
            this.FatalErrorOccurred = true;
        }
        this.LastDiagLevel = DiagnosticIDs.Level.Ignored;
    }

    public boolean isLastDiagnosticIgnored() {
        return this.LastDiagLevel == DiagnosticIDs.Level.Ignored;
    }

    public void setExtensionHandlingBehavior(diag.Severity H) {
        this.ExtBehavior = H;
    }

    public diag.Severity getExtensionHandlingBehavior() {
        return this.ExtBehavior;
    }

    public void setSeverity(long Diag, diag.Severity Map2, SourceLocation L) {
        DiagnosticMapping Info2;
        assert (Diag < 4720L) : "Can only map builtin diagnostics";
        if (!$assertionsDisabled) {
            DiagnosticIDs cfr_ignored_0 = (DiagnosticIDs)((Object)this.Diags.$arrow());
            if (!DiagnosticIDs.isBuiltinWarningOrExtension(Diag) && Map2 != diag.Severity.Fatal && Map2 != diag.Severity.Error) {
                throw new AssertionError((Object)"Cannot map errors into warnings!");
            }
        }
        assert (!this.DiagStatePoints.empty());
        assert (L.isInvalid() || this.SourceMgr != null) : "No SourceMgr for valid location";
        FullSourceLoc Loc = this.SourceMgr != null ? new FullSourceLoc(L, this.SourceMgr) : new FullSourceLoc();
        FullSourceLoc LastStateChangePos = ((DiagStatePoint)this.DiagStatePoints.back()).Loc;
        if (Map2 == diag.Severity.Warning && ((Info2 = this.GetCurDiagState().getOrAddMapping(Diag)).getSeverity() == diag.Severity.Error || Info2.getSeverity() == diag.Severity.Fatal)) {
            Map2 = Info2.getSeverity();
        }
        DiagnosticMapping Mapping2 = this.makeUserMapping(Map2, L);
        if (Loc.isInvalid() || ClangGlobals.$eq_FullSourceLoc(Loc, LastStateChangePos)) {
            this.GetCurDiagState().setMapping(Diag, Mapping2);
            return;
        }
        if (Loc.isValid() && LastStateChangePos.isInvalid() || LastStateChangePos.isBeforeInTranslationUnitThan(Loc)) {
            this.DiagStates.push_back((Object)this.GetCurDiagState());
            this.PushDiagStatePoint((DiagState)this.DiagStates.back(), Loc);
            this.GetCurDiagState().setMapping(Diag, Mapping2);
            return;
        }
        int $Pos = this.GetDiagStatePointForLocIndex(Loc);
        assert ($Pos != this.DiagStatePoints.size());
        DiagStatePoint $at$Pos = (DiagStatePoint)this.DiagStatePoints.$at($Pos);
        int E = this.DiagStatePoints.size();
        for (int I = $Pos + 1; I != E; ++I) {
            this.GetCurDiagState().setMapping(Diag, Mapping2);
        }
        if (ClangGlobals.$eq_FullSourceLoc($at$Pos.Loc, Loc)) {
            this.GetCurDiagState().setMapping(Diag, Mapping2);
            return;
        }
        assert ($at$Pos.Loc.isBeforeInTranslationUnitThan(Loc));
        this.DiagStates.push_back((Object)$at$Pos.State);
        DiagState NewState = (DiagState)this.DiagStates.back();
        this.GetCurDiagState().setMapping(Diag, Mapping2);
        StdVector.iterator Pos$Add$1 = this.DiagStatePoints.begin().$add($Pos + 1);
        this.DiagStatePoints.insert(Pos$Add$1, (Object)new DiagStatePoint(NewState, new FullSourceLoc(Loc, this.SourceMgr)));
    }

    public boolean setSeverityForGroup(diag.Flavor Flavor2, StringRef Group, diag.Severity Map2) {
        return this.setSeverityForGroup(Flavor2, Group, Map2, new SourceLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSeverityForGroup(diag.Flavor Flavor2, StringRef Group, diag.Severity Map2, SourceLocation Loc) {
        SmallVectorUInt GroupDiags = null;
        try {
            GroupDiags = new SmallVectorUInt(256);
            if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(Flavor2, Group, (SmallVectorImplUInt)GroupDiags)) {
                boolean bl = true;
                return bl;
            }
            for (long Diag : GroupDiags.$array()) {
                this.setSeverity(Diag, Map2, Loc);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (GroupDiags != null) {
                GroupDiags.$destroy();
            }
        }
    }

    public void IncrementAllExtensionsSilenced() {
        this.AllExtensionsSilenced = (byte)(this.AllExtensionsSilenced + 1);
    }

    public void DecrementAllExtensionsSilenced() {
        this.AllExtensionsSilenced = (byte)(this.AllExtensionsSilenced - 1);
    }

    public boolean hasAllExtensionsSilenced() {
        return this.AllExtensionsSilenced != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDiagnosticGroupWarningAsError(StringRef Group, boolean Enabled) {
        SmallVectorUInt GroupDiags = null;
        try {
            if (Enabled) {
                boolean bl = this.setSeverityForGroup(diag.Flavor.WarningOrError, Group, diag.Severity.Error);
                return bl;
            }
            GroupDiags = new SmallVectorUInt(8, 0L);
            if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(diag.Flavor.WarningOrError, Group, (SmallVectorImplUInt)GroupDiags)) {
                boolean bl = true;
                return bl;
            }
            long e = GroupDiags.size();
            for (long i = 0L; i != e; ++i) {
                DiagnosticMapping Info2 = this.GetCurDiagState().getOrAddMapping(GroupDiags.$at(i));
                if (Info2.getSeverity() == diag.Severity.Error || Info2.getSeverity() == diag.Severity.Fatal) {
                    Info2.setSeverity(diag.Severity.Warning);
                }
                Info2.setNoWarningAsError(true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (GroupDiags != null) {
                GroupDiags.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDiagnosticGroupErrorAsFatal(StringRef Group, boolean Enabled) {
        SmallVectorUInt GroupDiags = null;
        try {
            if (Enabled) {
                boolean bl = this.setSeverityForGroup(diag.Flavor.WarningOrError, Group, diag.Severity.Fatal);
                return bl;
            }
            GroupDiags = new SmallVectorUInt(8, 0L);
            if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(diag.Flavor.WarningOrError, Group, (SmallVectorImplUInt)GroupDiags)) {
                boolean bl = true;
                return bl;
            }
            long e = GroupDiags.size();
            for (long i = 0L; i != e; ++i) {
                DiagnosticMapping Info2 = this.GetCurDiagState().getOrAddMapping(GroupDiags.$at(i));
                if (Info2.getSeverity() == diag.Severity.Fatal) {
                    Info2.setSeverity(diag.Severity.Error);
                }
                Info2.setNoErrorAsFatal(true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (GroupDiags != null) {
                GroupDiags.$destroy();
            }
        }
    }

    public void setSeverityForAll(diag.Flavor Flavor2, diag.Severity Map2) {
        this.setSeverityForAll(Flavor2, Map2, new SourceLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeverityForAll(diag.Flavor Flavor2, diag.Severity Map2, SourceLocation Loc) {
        SmallVectorUInt AllDiags = null;
        try {
            AllDiags = new SmallVectorUInt(64, 0L);
            ((DiagnosticIDs)((Object)this.Diags.$arrow())).getAllDiagnostics(Flavor2, (SmallVectorImplUInt)AllDiags);
            long e = AllDiags.size();
            for (long i = 0L; i != e; ++i) {
                DiagnosticIDs cfr_ignored_0 = (DiagnosticIDs)((Object)this.Diags.$arrow());
                if (!DiagnosticIDs.isBuiltinWarningOrExtension(AllDiags.$at(i))) continue;
                this.setSeverity(AllDiags.$at(i), Map2, Loc);
            }
        }
        finally {
            if (AllDiags != null) {
                AllDiags.$destroy();
            }
        }
    }

    public boolean hasErrorOccurred() {
        return this.ErrorOccurred;
    }

    public boolean hasUncompilableErrorOccurred() {
        return this.UncompilableErrorOccurred;
    }

    public boolean hasFatalErrorOccurred() {
        return this.FatalErrorOccurred;
    }

    public boolean hasUnrecoverableErrorOccurred() {
        return this.FatalErrorOccurred || this.UnrecoverableErrorOccurred;
    }

    public int getNumWarnings() {
        return this.NumWarnings;
    }

    public void setNumWarnings(int NumWarnings) {
        this.NumWarnings = NumWarnings;
    }

    public long getCustomDiagID(Level L, StringRef Message) {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).getCustomDiagID(DiagnosticIDs.Level.valueOf(L.getValue()), Message);
    }

    public void ConvertArgToString(ArgumentKind Kind2, Object Val, char.ptr Modifier, long ModLen, char.ptr Argument, long ArgLen, type.ptr<std.pair<ArgumentKind, ?>> PrevArgs, long NumPrevArgs, SmallString Output, ArrayRef QualTypeVals) {
        this.ArgToStringFn.$call(Kind2, Val, Modifier, ModLen, Argument, ArgLen, PrevArgs, NumPrevArgs, Output, this.ArgToStringCookie, QualTypeVals);
    }

    public void SetArgToStringFn(ArgToStringFn Fn, void.ptr Cookie) {
        this.ArgToStringFn = Fn;
        this.ArgToStringCookie = Cookie;
    }

    public void notePriorDiagnosticFrom(DiagnosticsEngine Other) {
        this.LastDiagLevel = Other.LastDiagLevel;
    }

    public void Reset() {
        this.ErrorOccurred = false;
        this.UncompilableErrorOccurred = false;
        this.FatalErrorOccurred = false;
        this.UnrecoverableErrorOccurred = false;
        this.NumWarnings = 0;
        this.NumErrors = 0;
        this.TrapNumErrorsOccurred = 0;
        this.TrapNumUnrecoverableErrorsOccurred = 0;
        this.CurDiagID = -1L;
        this.LastDiagLevel = DiagnosticIDs.Level.Ignored;
        this.DelayedDiagID = 0;
        this.DiagStates.clear();
        this.DiagStatePoints.clear();
        this.DiagStateOnPushStack.clear();
        this.DiagStates.push_back((Object)new DiagState());
        this.DiagStatePoints.push_back((Object)new DiagStatePoint((DiagState)this.DiagStates.back(), new FullSourceLoc()));
    }

    public boolean isIgnored(long DiagID, SourceLocation Loc) {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticSeverity(DiagID, Loc, this) == diag.Severity.Ignored;
    }

    public boolean isIgnored(long DiagID, int Loc) {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticSeverity(DiagID, new SourceLocation(Loc), this) == diag.Severity.Ignored;
    }

    public Level getDiagnosticLevel(int DiagID, int Loc) {
        return this.getDiagnosticLevel(DiagID, SourceLocation.getFromRawEncoding(Loc));
    }

    public Level getDiagnosticLevel(int DiagID, SourceLocation Loc) {
        return Level.valueOf(((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticLevel(DiagID, Loc, this).getValue());
    }

    public DiagnosticBuilder Report(SourceLocation Loc, long DiagID) {
        assert (this.CurDiagID == -1L) : "Multiple diagnostics in flight at once!";
        this.CurDiagLoc.$assign(Loc);
        this.CurDiagID = DiagID;
        this.FlagValue.clear();
        return new DiagnosticBuilder(this);
    }

    public DiagnosticBuilder Report(int Loc, long DiagID) {
        assert (this.CurDiagID == -1L) : "Multiple diagnostics in flight at once!" + this.CurDiagID;
        this.CurDiagLoc.$assign(Loc);
        this.CurDiagID = DiagID;
        return new DiagnosticBuilder(this);
    }

    public DiagnosticBuilder Report(long DiagID) {
        return this.Report(new SourceLocation(), DiagID);
    }

    public void Report(StoredDiagnostic storedDiag) {
        assert (this.CurDiagID == -1L) : "Multiple diagnostics in flight at once!";
        this.CurDiagLoc.$assign(storedDiag.getLocation());
        this.CurDiagID = storedDiag.getID();
        this.NumDiagArgs = 0;
        this.DiagRanges.clear();
        this.DiagRanges.reserve(storedDiag.range_size());
        StdVector.iterator RI = (StdVector.iterator)Native.$tryClone(storedDiag.range_begin());
        StdVector.iterator RE = (StdVector.iterator)Native.$tryClone(storedDiag.range_end());
        while (std.$noteq___normal_iterator((StdVector.iterator)RI, (StdVector.iterator)RE)) {
            this.DiagRanges.push_back(RI.$star());
            RI.$preInc();
        }
        this.DiagFixItHints.clear();
        this.DiagFixItHints.reserve(storedDiag.fixit_size());
        StdVector.iterator FI = (StdVector.iterator)Native.$tryClone(storedDiag.fixit_begin());
        StdVector.iterator FE = (StdVector.iterator)Native.$tryClone(storedDiag.fixit_end());
        while (std.$noteq___normal_iterator((StdVector.iterator)FI, (StdVector.iterator)FE)) {
            this.DiagFixItHints.push_back(FI.$star());
            FI.$preInc();
        }
        assert (this.Client != null) : "DiagnosticConsumer not set!";
        Level DiagLevel = storedDiag.getLevel();
        Diagnostic Info2 = new Diagnostic(this, storedDiag.getMessage());
        this.Client.HandleDiagnostic(DiagLevel, Info2);
        if (this.Client.IncludeInDiagnosticCounts() && DiagLevel == Level.Warning) {
            ++this.NumWarnings;
        }
        this.CurDiagID = -1L;
    }

    public boolean isDiagnosticInFlight() {
        return this.CurDiagID != -1L;
    }

    public void SetDelayedDiagnostic(int DiagID) {
        this.SetDelayedDiagnostic(DiagID, StringRef.EMPTY, StringRef.EMPTY);
    }

    public void SetDelayedDiagnostic(int DiagID, StringRef Arg1) {
        this.SetDelayedDiagnostic(DiagID, Arg1, StringRef.EMPTY);
    }

    public void SetDelayedDiagnostic(int DiagID, StringRef Arg1, StringRef Arg2) {
        if (this.DelayedDiagID != 0) {
            return;
        }
        this.DelayedDiagID = DiagID;
        this.DelayedDiagArg1.$assign(Arg1.str());
        this.DelayedDiagArg2.$assign(Arg2.str());
    }

    public void Clear() {
        this.CurDiagID = -1L;
    }

    public StringRef getFlagValue() {
        return new StringRef(this.FlagValue);
    }

    private void ReportDelayed() {
        ClangGlobals.$out_DiagnosticBuilder_StringRef(ClangGlobals.$out_DiagnosticBuilder_StringRef(this.Report(this.DelayedDiagID), new StringRef(this.DelayedDiagArg1)), new StringRef(this.DelayedDiagArg2)).$destroy();
        this.DelayedDiagID = 0;
        this.DelayedDiagArg1.clear();
        this.DelayedDiagArg2.clear();
    }

    private DiagnosticMappingInfo makeMappingInfo(diag.Mapping Map2, SourceLocation L) {
        boolean isPragma = L.isValid();
        DiagnosticMappingInfo MappingInfo = DiagnosticMappingInfo.Make(Map2, true, isPragma);
        if (isPragma) {
            MappingInfo.setNoWarningAsError(true);
            MappingInfo.setNoErrorAsFatal(true);
        }
        return MappingInfo;
    }

    private DiagnosticMapping makeUserMapping(diag.Severity Map2, SourceLocation L) {
        boolean isPragma = L.isValid();
        DiagnosticMapping Mapping2 = DiagnosticMapping.Make(Map2, true, isPragma);
        if (isPragma) {
            Mapping2.setNoWarningAsError(true);
            Mapping2.setNoErrorAsFatal(true);
        }
        return Mapping2;
    }

    private boolean ProcessDiag() {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).ProcessDiag(this);
    }

    protected boolean EmitCurrentDiagnostic() {
        return this.EmitCurrentDiagnostic(false);
    }

    protected boolean EmitCurrentDiagnostic(boolean Force) {
        boolean Emitted;
        assert (this.getClient() != null) : "DiagnosticClient not set!";
        if (Force) {
            Diagnostic Info2 = new Diagnostic(this);
            DiagnosticIDs.Level DiagLevel = ((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticLevel(Info2.getID(), Info2.getLocation(), this);
            boolean bl = Emitted = DiagLevel != DiagnosticIDs.Level.Ignored;
            if (Emitted) {
                ((DiagnosticIDs)((Object)this.Diags.$arrow())).EmitDiag(this, DiagLevel);
            }
        } else {
            Emitted = this.ProcessDiag();
        }
        long DiagID = this.CurDiagID;
        this.Clear();
        if (!Force && this.DelayedDiagID != 0 && (long)this.DelayedDiagID != DiagID) {
            this.ReportDelayed();
        }
        return Emitted;
    }

    protected long getCurrentDiagID() {
        return this.CurDiagID;
    }

    protected SourceLocation getCurrentDiagLoc() {
        return this.CurDiagLoc;
    }

    public String toString() {
        return "DiagnosticsEngine{\n AllExtensionsSilenced=" + this.AllExtensionsSilenced + "\n IgnoreAllWarnings=" + this.IgnoreAllWarnings + "\n WarningsAsErrors=" + this.WarningsAsErrors + "\n EnableAllWarnings=" + this.EnableAllWarnings + "\n ErrorsAsFatal=" + this.ErrorsAsFatal + "\n SuppressSystemWarnings=" + this.SuppressSystemWarnings + "\n SuppressAllDiagnostics=" + this.SuppressAllDiagnostics + "\n ElideType=" + this.ElideType + "\n PrintTemplateTree=" + this.PrintTemplateTree + "\n ShowColors=" + this.ShowColors + "\n ShowOverloads=" + (Object)((Object)this.ShowOverloads) + "\n ErrorLimit=" + this.ErrorLimit + "\n TemplateBacktraceLimit=" + this.TemplateBacktraceLimit + "\n ConstexprBacktraceLimit=" + this.ConstexprBacktraceLimit + "\n ExtBehavior=" + (Object)((Object)this.ExtBehavior) + "\n OwnsDiagClient=" + this.OwnsDiagClient + "\n DiagStates=" + this.DiagStates + "\n DiagStatePoints=" + this.DiagStatePoints + "\n DiagStateOnPushStack=" + this.DiagStateOnPushStack + "\n ErrorOccurred=" + this.ErrorOccurred + "\n UncompilableErrorOccurred=" + this.UncompilableErrorOccurred + "\n FatalErrorOccurred=" + this.FatalErrorOccurred + "\n UnrecoverableErrorOccurred=" + this.UnrecoverableErrorOccurred + "\n TrapNumErrorsOccurred=" + this.TrapNumErrorsOccurred + "\n TrapNumUnrecoverableErrorsOccurred=" + this.TrapNumUnrecoverableErrorsOccurred + "\n LastDiagLevel=" + (Object)((Object)this.LastDiagLevel) + "\n NumWarnings=" + this.NumWarnings + "\n NumErrors=" + this.NumErrors + "\n NumErrorsSuppressed=" + this.NumErrorsSuppressed + "\n ArgToStringCookie=" + this.ArgToStringCookie + "\n ArgToStringFn=" + this.ArgToStringFn + "\n DummyArgToStringFn=" + this.DummyArgToStringFn + "\n DelayedDiagID=" + this.DelayedDiagID + "\n DelayedDiagArg1=" + this.DelayedDiagArg1 + "\n DelayedDiagArg2=" + this.DelayedDiagArg2 + "\n CurDiagLoc=" + this.CurDiagLoc + "\n CurDiagID=" + this.CurDiagID + "\n NumDiagArgs=" + this.NumDiagArgs + "\n NumDiagRanges=" + this.NumDiagRanges + "\n NumDiagFixItHints=" + this.NumDiagFixItHints + "\n DiagArgumentsKind=" + Arrays.toString((Object[])this.DiagArgumentsKind) + "\n DiagArgumentsStr=" + Arrays.toString(this.DiagArgumentsStr) + "\n DiagArgumentsVal=" + Arrays.deepToString(this.DiagArgumentsVal) + "\n DiagRanges=" + this.DiagRanges + "\n DiagFixItHints=" + this.DiagFixItHints + "\n Diags=" + this.Diags + "\n DiagOpts=" + this.DiagOpts + "\n Client=" + this.Client + "\n SourceMgr=" + (Object)((Object)this.SourceMgr) + "\n}";
    }

    static final class Unnamed_enum3
    extends Enum<Unnamed_enum3> {
        public static final /* enum */ Unnamed_enum3 MaxArguments = new Unnamed_enum3(10);
        public static final /* enum */ Unnamed_enum3 MaxRanges = new Unnamed_enum3(10);
        public static final /* enum */ Unnamed_enum3 MaxFixItHints = new Unnamed_enum3(10);
        private final int value;
        private static final /* synthetic */ Unnamed_enum3[] $VALUES;

        public static Unnamed_enum3[] values() {
            return (Unnamed_enum3[])$VALUES.clone();
        }

        public static Unnamed_enum3 valueOf(String name) {
            return Enum.valueOf(Unnamed_enum3.class, name);
        }

        public static Unnamed_enum3 valueOf(int val) {
            Unnamed_enum3 out;
            Unnamed_enum3 unnamed_enum3 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum3(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum3[]{MaxArguments, MaxRanges, MaxFixItHints};
        }

        private static final class Values {
            private static final Unnamed_enum3[] VALUES;
            private static final Unnamed_enum3[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum3 kind : Unnamed_enum3.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum3[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum3[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum3 kind : Unnamed_enum3.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum3)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum3)kind).value] = kind;
                }
            }
        }
    }

    public static interface ArgToStringFn {
        public void $call(ArgumentKind var1, Object var2, char.ptr var3, long var4, char.ptr var6, long var7, type.ptr<std.pair<ArgumentKind, ?>> var9, long var10, SmallString var12, void.ptr var13, ArrayRef var14);
    }

    static class DiagStatePoint {
        public DiagState State;
        public FullSourceLoc Loc;

        public DiagStatePoint() {
        }

        public DiagStatePoint(DiagState State, FullSourceLoc Loc) {
            this.State = State;
            this.Loc = new FullSourceLoc(Loc);
        }

        public boolean $less(DiagStatePoint RHS) {
            if (RHS.Loc.isInvalid()) {
                return false;
            }
            if (this.Loc.isInvalid()) {
                return true;
            }
            return this.Loc.isBeforeInTranslationUnitThan(RHS.Loc);
        }

        public DiagStatePoint(DiagStatePoint $Prm0) {
            this.State = $Prm0.State;
            this.Loc = new FullSourceLoc($Prm0.Loc);
        }

        public DiagStatePoint $assign(DiagStatePoint $Prm0) {
            this.State = $Prm0.State;
            this.Loc.$assign($Prm0.Loc);
            return this;
        }

        public String toString() {
            return "DiagStatePoint{\nLoc=" + this.Loc + "\nState=" + this.State + "\n}";
        }
    }

    static class DiagState
    implements Destructors.ClassWithDestructor {
        private DenseMapUIntType<DiagnosticMapping> DiagMap;

        public void setMapping(long Diag, DiagnosticMapping Info2) {
            std.pairUIntType Result = this.DiagMap.FindAndConstruct(Diag);
            if (Result.second == null) {
                Result.second = Info2;
            } else {
                ((DiagnosticMapping)Result.second).$assign(Info2);
            }
        }

        public DiagnosticMapping getOrAddMapping(long Diag) {
            std.pairUIntType Result = this.DiagMap.FindAndConstruct(Diag);
            if (Result.second == null) {
                Result.second = DiagnosticIDsStatics.GetDefaultDiagMapping(Diag);
            }
            return (DiagnosticMapping)Result.second;
        }

        public DenseMapIteratorUIntType<DiagnosticMapping> begin() {
            return this.DiagMap.begin();
        }

        public DenseMapIteratorUIntType<DiagnosticMapping> end() {
            return this.DiagMap.end();
        }

        public DiagState(DiagState $Prm0) {
            this.DiagMap = new DenseMapUIntType($Prm0.DiagMap);
        }

        public void $destroy() {
        }

        public DiagState() {
            this.DiagMap = new DenseMapUIntType((DenseMapInfoUInt)new DenseMapInfoUIntImpl(), null);
        }

        public String toString() {
            return "DiagMap=" + this.DiagMap;
        }
    }

    public final class ArgumentValue
    extends std.pairTypeInt<ArgumentKind> {
        public ArgumentValue(ArgumentKind first, int second) {
            super((Object)first, second);
        }

        public std.pairTypeInt<ArgumentKind> clone() {
            return new ArgumentValue((ArgumentKind)((Object)this.first), this.second);
        }
    }

    public static final class ArgumentKind
    extends Enum<ArgumentKind> {
        public static final /* enum */ ArgumentKind ak_std_string = new ArgumentKind(0L);
        public static final /* enum */ ArgumentKind ak_c_string = new ArgumentKind(ak_std_string.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_sint = new ArgumentKind(ak_c_string.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_uint = new ArgumentKind(ak_sint.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_tokenkind = new ArgumentKind(ak_uint.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_identifierinfo = new ArgumentKind(ak_tokenkind.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_qualtype = new ArgumentKind(ak_identifierinfo.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_declarationname = new ArgumentKind(ak_qualtype.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_nameddecl = new ArgumentKind(ak_declarationname.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_nestednamespec = new ArgumentKind(ak_nameddecl.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_declcontext = new ArgumentKind(ak_nestednamespec.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_qualtype_pair = new ArgumentKind(ak_declcontext.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_attr = new ArgumentKind(ak_qualtype_pair.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ArgumentKind[] $VALUES;

        public static ArgumentKind[] values() {
            return (ArgumentKind[])$VALUES.clone();
        }

        public static ArgumentKind valueOf(String name) {
            return Enum.valueOf(ArgumentKind.class, name);
        }

        public static ArgumentKind valueOf(int val) {
            ArgumentKind out;
            ArgumentKind argumentKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ArgumentKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ArgumentKind[]{ak_std_string, ak_c_string, ak_sint, ak_uint, ak_tokenkind, ak_identifierinfo, ak_qualtype, ak_declarationname, ak_nameddecl, ak_nestednamespec, ak_declcontext, ak_qualtype_pair, ak_attr};
        }

        private static final class Values {
            private static final ArgumentKind[] VALUES;
            private static final ArgumentKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ArgumentKind kind : ArgumentKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ArgumentKind[min < 0 ? 1 - min : 0];
                VALUES = new ArgumentKind[max >= 0 ? 1 + max : 0];
                for (ArgumentKind kind : ArgumentKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ArgumentKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ArgumentKind)kind).value] = kind;
                }
            }
        }
    }

    public static final class ExtensionHandling
    extends Enum<ExtensionHandling> {
        public static final /* enum */ ExtensionHandling Ext_Ignore = new ExtensionHandling(0);
        public static final /* enum */ ExtensionHandling Ext_Warn = new ExtensionHandling(1);
        public static final /* enum */ ExtensionHandling Ext_Error = new ExtensionHandling(2);
        private final int value;
        private static final /* synthetic */ ExtensionHandling[] $VALUES;

        public static ExtensionHandling[] values() {
            return (ExtensionHandling[])$VALUES.clone();
        }

        public static ExtensionHandling valueOf(String name) {
            return Enum.valueOf(ExtensionHandling.class, name);
        }

        public static ExtensionHandling valueOf(int val) {
            ExtensionHandling out;
            ExtensionHandling extensionHandling = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ExtensionHandling(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ExtensionHandling[]{Ext_Ignore, Ext_Warn, Ext_Error};
        }

        private static final class Values {
            private static final ExtensionHandling[] VALUES;
            private static final ExtensionHandling[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ExtensionHandling kind : ExtensionHandling.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ExtensionHandling[min < 0 ? 1 - min : 0];
                VALUES = new ExtensionHandling[max >= 0 ? 1 + max : 0];
                for (ExtensionHandling kind : ExtensionHandling.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ExtensionHandling)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ExtensionHandling)kind).value] = kind;
                }
            }
        }
    }

    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level Ignored = new Level(DiagnosticIDs.Level.Ignored.getValue());
        public static final /* enum */ Level Note = new Level(DiagnosticIDs.Level.Note.getValue());
        public static final /* enum */ Level Remark = new Level(DiagnosticIDs.Level.Remark.getValue());
        public static final /* enum */ Level Warning = new Level(DiagnosticIDs.Level.Warning.getValue());
        public static final /* enum */ Level Error = new Level(DiagnosticIDs.Level.Error.getValue());
        public static final /* enum */ Level Fatal = new Level(DiagnosticIDs.Level.Fatal.getValue());
        private final int value;
        private static final /* synthetic */ Level[] $VALUES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String name) {
            return Enum.valueOf(Level.class, name);
        }

        public static Level valueOf(int val) {
            Level out;
            Level level = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Level(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Level[]{Ignored, Note, Remark, Warning, Error, Fatal};
        }

        private static final class Values {
            private static final Level[] VALUES;
            private static final Level[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Level kind : Level.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Level[min < 0 ? 1 - min : 0];
                VALUES = new Level[max >= 0 ? 1 + max : 0];
                for (Level kind : Level.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Level)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Level)kind).value] = kind;
                }
            }
        }
    }
}

