/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.FileData;
import org.clang.basic.impl.FileSystemStatCacheStatics;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.aliases.char;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;

public abstract class FileSystemStatCache
implements Destructors.ClassWithDestructor {
    protected std_ptr.unique_ptr<FileSystemStatCache> NextStatCache = new std_ptr.unique_ptr((Object)null);

    protected void anchor() {
    }

    public void $destroy() {
        this.NextStatCache.$destroy();
    }

    public static boolean get(char.ptr Path, int PathLen, FileData Data, boolean isFile, std_ptr.unique_ptr<File> F, FileSystemStatCache Cache, FileSystem FS) {
        LookupResult R;
        boolean isForDir;
        boolean bl = isForDir = !isFile;
        if (Cache != null) {
            R = Cache.getStat(Path, PathLen, Data, isFile, F, FS);
        } else if (isForDir || F == null) {
            ErrorOr<Status> Status2 = FS.status(new Twine(Path));
            if (!Status2.$boolean()) {
                R = LookupResult.CacheMissing;
            } else {
                R = LookupResult.CacheExists;
                FileSystemStatCacheStatics.copyStatusToFileData((Status)Status2.$star(), Data);
            }
        } else {
            ErrorOr<std_ptr.unique_ptr<File>> OwnedFile = FS.openFileForRead(new Twine(Path));
            if (!OwnedFile.$boolean()) {
                R = LookupResult.CacheMissing;
            } else {
                ErrorOr<Status> Status3 = ((File)((std_ptr.unique_ptr)OwnedFile.$star()).$arrow()).status();
                if (Status3.$boolean()) {
                    R = LookupResult.CacheExists;
                    FileSystemStatCacheStatics.copyStatusToFileData((Status)Status3.$star(), Data);
                    F.$assignRvalue(std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)OwnedFile.$star())));
                } else {
                    R = LookupResult.CacheMissing;
                    F.$assignNullptr(null);
                }
            }
        }
        if (R == LookupResult.CacheMissing) {
            return true;
        }
        if (Data.IsDirectory != isForDir) {
            if (F != null) {
                F.$assignNullptr(null);
            }
            return true;
        }
        return false;
    }

    public void setNextStatCache(std_ptr.unique_ptr<FileSystemStatCache> Cache) {
        this.NextStatCache.$assignRvalue(std.move(Cache));
    }

    public FileSystemStatCache getNextStatCache() {
        return (FileSystemStatCache)this.NextStatCache.get();
    }

    public std_ptr.unique_ptr<FileSystemStatCache> takeNextStatCache() {
        return std.move(this.NextStatCache);
    }

    protected abstract LookupResult getStat(char.ptr var1, int var2, FileData var3, boolean var4, std_ptr.unique_ptr<File> var5, FileSystem var6);

    protected LookupResult statChained(char.ptr Path, int PathLen, FileData Data, boolean isFile, std_ptr.unique_ptr<File> F, FileSystem FS) {
        FileSystemStatCache Next = this.getNextStatCache();
        if (Next != null) {
            return Next.getStat(Path, PathLen, Data, isFile, F, FS);
        }
        return FileSystemStatCache.get(Path, PathLen, Data, isFile, F, null, FS) ? LookupResult.CacheMissing : LookupResult.CacheExists;
    }

    public String toString() {
        return "NextStatCache=" + this.NextStatCache;
    }

    public static final class LookupResult
    extends Enum<LookupResult> {
        public static final /* enum */ LookupResult CacheExists = new LookupResult(0L);
        public static final /* enum */ LookupResult CacheMissing = new LookupResult(CacheExists.getValue() + 1);
        private final int value;
        private static final /* synthetic */ LookupResult[] $VALUES;

        public static LookupResult[] values() {
            return (LookupResult[])$VALUES.clone();
        }

        public static LookupResult valueOf(String name) {
            return Enum.valueOf(LookupResult.class, name);
        }

        public static LookupResult valueOf(int val) {
            LookupResult out;
            LookupResult lookupResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private LookupResult(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new LookupResult[]{CacheExists, CacheMissing};
        }

        private static final class Values {
            private static final LookupResult[] VALUES;
            private static final LookupResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LookupResult kind : LookupResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LookupResult[min < 0 ? 1 - min : 0];
                VALUES = new LookupResult[max >= 0 ? 1 + max : 0];
                for (LookupResult kind : LookupResult.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((LookupResult)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((LookupResult)kind).value] = kind;
                }
            }
        }
    }
}

