/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.OnDiskChainedHashTable;
import org.clang.basic.io;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.raw_ostream;

public class OnDiskChainedHashTableGenerator<external_key_type, internal_key_type, data_type>
implements Destructors.ClassWithDestructor {
    private int NumBuckets;
    private int NumEntries;
    private final EmitInfoInterface<external_key_type, internal_key_type, data_type> InfoObj;
    private BumpPtrAllocator BA;
    private Bucket<external_key_type, internal_key_type, data_type>[] Buckets;

    private void insert(Bucket[] b, long size, Item E) {
        long idx = E.hash & size - 1L;
        Bucket B = b[(int)idx];
        E.next = B.head;
        ++B.length;
        B.head = E;
    }

    private void resize(int newsize) {
        Bucket[] newBuckets = new Bucket[newsize];
        for (int i = 0; i < this.NumBuckets; ++i) {
            Item E = this.Buckets[i].head;
            while (E != null) {
                Item N = E.next;
                E.next = null;
                this.insert(newBuckets, newsize, E);
                E = N;
            }
        }
        std.free(this.Buckets);
        this.NumBuckets = newsize;
        this.Buckets = newBuckets;
    }

    public void insert(internal_key_type key, data_type data) {
        this.insert(key, data, this.InfoObj);
    }

    public void insert(internal_key_type key, data_type data, OnDiskChainedHashTable.InfoInterface InfoObj) {
        ++this.NumEntries;
        if (4 * this.NumEntries >= 3 * this.NumBuckets) {
            this.resize(this.NumBuckets * 2);
        }
        this.insert(this.Buckets, this.NumBuckets, new Item(key, data, InfoObj));
    }

    public long Emit(raw_ostream out) {
        return this.Emit(out, this.InfoObj);
    }

    public long Emit(raw_ostream out, EmitInfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        for (int i = 0; i < this.NumBuckets; ++i) {
            Bucket<external_key_type, internal_key_type, data_type> B = this.Buckets[i];
            if (B.head == null) continue;
            B.off = out.tell();
            assert (B.off != 0L) : "Cannot write a bucket at offset 0. Please add padding.";
            io.Emit16(out, B.length);
            assert (B.length != 0) : "Bucket has a head but zero length?";
            Item I = B.head;
            while (I != null) {
                io.Emit32(out, I.hash);
                std.pairUIntUInt Len = InfoObj.EmitKeyDataLength(out, I.key, I.data);
                InfoObj.EmitKey(out, I.key, Len.first);
                InfoObj.EmitData(out, I.key, I.data, Len.second);
                I = I.next;
            }
        }
        io.Pad(out, 4);
        long TableOff = out.tell();
        io.Emit32(out, this.NumBuckets);
        io.Emit32(out, this.NumEntries);
        for (int i = 0; i < this.NumBuckets; ++i) {
            io.Emit32(out, this.Buckets[i].off);
        }
        return TableOff;
    }

    public OnDiskChainedHashTableGenerator(EmitInfoInterface<external_key_type, internal_key_type, data_type> InfoObj) {
        this.InfoObj = InfoObj;
        this.NumEntries = 0;
        this.NumBuckets = 64;
        this.Buckets = new Bucket[this.NumBuckets];
    }

    public void $destroy() {
        std.free(this.Buckets);
    }

    public static interface EmitInfoInterface<external_key_type, internal_key_type, data_type>
    extends OnDiskChainedHashTable.InfoInterface<external_key_type, internal_key_type, data_type> {
        public std.pairUIntUInt EmitKeyDataLength(raw_ostream var1, internal_key_type var2, data_type var3);

        public void EmitKey(raw_ostream var1, internal_key_type var2, long var3);

        public void EmitData(raw_ostream var1, internal_key_type var2, data_type var3, long var4);
    }

    private static class Bucket<external_key_type, internal_key_type, data_type> {
        public long off;
        public Item<external_key_type, internal_key_type, data_type> head;
        public int length;
    }

    private static class Item<external_key_type, internal_key_type, data_type> {
        public internal_key_type key;
        public data_type data;
        public Item<external_key_type, internal_key_type, data_type> next;
        public long hash;

        public Item(internal_key_type k, data_type d, OnDiskChainedHashTable.InfoInterface InfoObj) {
            this.key = k;
            this.data = d;
            this.next = null;
            this.hash = InfoObj.ComputeHash(k);
        }
    }
}

