/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.CrashRecoveryContext;
import org.llvm.support.llvm;

public class PartialDiagnostic
implements Destructors.ClassWithDestructor {
    private int DiagID;
    private Storage DiagStorage;
    private StorageAllocator Allocator;

    private Storage getStorage() {
        if (this.DiagStorage != null) {
            return this.DiagStorage;
        }
        if (this.Allocator != null) {
            this.DiagStorage = this.Allocator.Allocate();
        } else {
            assert (this.Allocator != Casts.reinterpret_cast(StorageAllocator.class, (long)-1L));
            this.DiagStorage = new Storage();
        }
        return this.DiagStorage;
    }

    private void freeStorage() {
        if (this.DiagStorage == null) {
            return;
        }
        this.freeStorageSlow();
    }

    private void freeStorageSlow() {
        if (this.Allocator != null) {
            this.Allocator.Deallocate(this.DiagStorage);
        } else if (this.Allocator != Casts.reinterpret_cast(StorageAllocator.class, (long)-1L) && this.DiagStorage != null) {
            this.DiagStorage.$destroy();
        }
        this.DiagStorage = null;
    }

    private void AddSourceRange(CharSourceRange R) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (this.DiagStorage.NumDiagRanges < llvm.array_lengthof((Object[])this.DiagStorage.DiagRanges)) : "Too many arguments to diagnostic!";
        byte by = this.DiagStorage.NumDiagRanges;
        this.DiagStorage.NumDiagRanges = (byte)(by + 1);
        this.DiagStorage.DiagRanges[by].$assign(R);
    }

    private void AddFixItHint(FixItHint Hint) {
        if (Hint.isNull()) {
            return;
        }
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        this.DiagStorage.FixItHints.push_back((Object)Hint);
    }

    public PartialDiagnostic(NullDiagnostic $Prm0) {
        this.DiagID = 0;
        this.DiagStorage = null;
        this.Allocator = null;
    }

    public PartialDiagnostic(int DiagID, StorageAllocator Allocator2) {
        this.DiagID = DiagID;
        this.DiagStorage = null;
        this.Allocator = Allocator2;
    }

    public PartialDiagnostic(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = null;
        this.Allocator = Other.Allocator;
        if (Other.DiagStorage != null) {
            this.DiagStorage = this.getStorage();
            this.DiagStorage.$assign(Other.DiagStorage);
        }
    }

    public PartialDiagnostic(PartialDiagnostic Other, Storage DiagStorage) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = DiagStorage;
        this.Allocator = (StorageAllocator)Casts.reinterpret_cast(StorageAllocator.class, (long)-1L);
        if (Other.DiagStorage != null) {
            this.DiagStorage.$assign(Other.DiagStorage);
        }
    }

    public PartialDiagnostic(Diagnostic Other, StorageAllocator Allocator2) {
        long I;
        this.DiagID = Other.getID();
        this.DiagStorage = null;
        this.Allocator = Allocator2;
        int N = Other.getNumArgs();
        for (int I2 = 0; I2 != N; ++I2) {
            if (Other.getArgKind(I2) == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                this.AddString(new StringRef(Other.getArgStdStr(I2)));
                continue;
            }
            this.AddTaggedVal(Other.getRawArg(I2), Other.getArgKind(I2));
        }
        long N2 = Other.getNumRanges();
        for (I = 0L; I != N2; ++I) {
            this.AddSourceRange(Other.getRange(I));
        }
        N2 = Other.getNumFixItHints();
        for (I = 0L; I != N2; ++I) {
            this.AddFixItHint(Other.getFixItHint(I));
        }
    }

    public PartialDiagnostic $assign(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        if (Other.DiagStorage != null) {
            if (this.DiagStorage == null) {
                this.DiagStorage = this.getStorage();
            }
            this.DiagStorage.$assign(Other.DiagStorage);
        } else {
            this.freeStorage();
        }
        return this;
    }

    public void $destroy() {
        this.freeStorage();
    }

    public void swap(PartialDiagnostic PD) {
        int DiagIDPrev = this.DiagID;
        this.DiagID = PD.DiagID;
        PD.DiagID = DiagIDPrev;
        Storage DiagStoragePrev = this.DiagStorage;
        this.DiagStorage = PD.DiagStorage;
        PD.DiagStorage = DiagStoragePrev;
        StorageAllocator AllocatorPrev = this.Allocator;
        this.Allocator = PD.Allocator;
        PD.Allocator = AllocatorPrev;
    }

    public int getDiagID() {
        return this.DiagID;
    }

    public void AddTaggedVal(Object V, DiagnosticsEngine.ArgumentKind Kind2) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (this.DiagStorage.NumDiagArgs < Storage.Unnamed_enum.MaxArguments.getValue()) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = Kind2;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsVal[by] = V;
    }

    public void AddString(StringRef V) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (this.DiagStorage.NumDiagArgs < Storage.Unnamed_enum.MaxArguments.getValue()) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = DiagnosticsEngine.ArgumentKind.ak_std_string;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsStr[by].$assign(V.$basic_string());
    }

    public void Emit(DiagnosticBuilder DB) {
        int i;
        if (this.DiagStorage == null) {
            return;
        }
        int e = this.DiagStorage.NumDiagArgs;
        for (i = 0; i != e; ++i) {
            if (this.DiagStorage.DiagArgumentsKind[i] == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                DB.AddString(new StringRef(this.DiagStorage.DiagArgumentsStr[i]));
                continue;
            }
            DB.AddTaggedVal(this.DiagStorage.DiagArgumentsVal[i], this.DiagStorage.DiagArgumentsKind[i]);
        }
        e = this.DiagStorage.NumDiagRanges;
        for (i = 0; i != e; ++i) {
            DB.AddSourceRange(this.DiagStorage.DiagRanges[i]);
        }
        e = this.DiagStorage.FixItHints.size();
        for (i = 0; i != e; ++i) {
            DB.AddFixItHint((FixItHint)this.DiagStorage.FixItHints.$at(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitToString(DiagnosticsEngine Diags, SmallString Buf) {
        DiagnosticBuilder DB = null;
        try {
            DB = new DiagnosticBuilder(Diags.Report(this.getDiagID()));
            this.Emit(DB);
            DB.FlushCounts();
            new Diagnostic(Diags).FormatDiagnostic(Buf);
            DB.Clear();
            Diags.Clear();
        }
        finally {
            if (DB != null) {
                DB.$destroy();
            }
        }
    }

    public void Reset() {
        this.Reset(0);
    }

    public void Reset(int DiagID) {
        this.DiagID = DiagID;
        this.freeStorage();
    }

    public boolean hasStorage() {
        return this.DiagStorage != null;
    }

    public static class NullDiagnostic {
    }

    public static class StorageAllocator
    implements Destructors.ClassWithDestructor {
        private static int NumCached = 16;
        private Storage[] Cached = new Storage[16];
        private Storage[] FreeList = new Storage[16];
        private int NumFreeListEntries;

        public StorageAllocator() {
            this.Cached = new Storage[16];
            for (int I = 0; I != NumCached; ++I) {
                this.FreeList[I] = this.Cached[I];
            }
            this.NumFreeListEntries = NumCached;
        }

        public void $destroy() {
            assert (this.NumFreeListEntries == NumCached || CrashRecoveryContext.isRecoveringFromCrash()) : "A partial is on the lamb";
        }

        public Storage Allocate() {
            if (this.NumFreeListEntries == 0) {
                return new Storage();
            }
            Storage Result = this.FreeList[--this.NumFreeListEntries];
            Result.NumDiagArgs = 0;
            Result.NumDiagRanges = 0;
            Result.FixItHints.clear();
            return Result;
        }

        public void Deallocate(Storage S) {
            for (Storage storage : this.Cached) {
                if (storage != S) continue;
                this.FreeList[this.NumFreeListEntries++] = S;
                return;
            }
            if (S != null) {
                S.$destroy();
            }
        }
    }

    public static class Storage
    implements Destructors.ClassWithDestructor {
        public byte NumDiagArgs = 0;
        public byte NumDiagRanges;
        public DiagnosticsEngine.ArgumentKind[] DiagArgumentsKind = new DiagnosticsEngine.ArgumentKind[10];
        public Object[] DiagArgumentsVal = new Object[10];
        public std.string[] DiagArgumentsStr = new std.string[10];
        public CharSourceRange[] DiagRanges = new CharSourceRange[10];
        public SmallVector<FixItHint> FixItHints;

        public Storage() {
            this.DiagArgumentsStr = new std.string[10];
            this.DiagRanges = new CharSourceRange[10];
            this.FixItHints = new SmallVector(6, (Object)new FixItHint());
        }

        public Storage $assign(Storage $Prm0) {
            this.NumDiagArgs = $Prm0.NumDiagArgs;
            this.NumDiagRanges = $Prm0.NumDiagRanges;
            std.memcpy((Object[])this.DiagArgumentsKind, (Object[])$Prm0.DiagArgumentsKind, (int)$Prm0.DiagArgumentsKind.length);
            std.memcpy((Object[])this.DiagArgumentsVal, (Object[])$Prm0.DiagArgumentsVal, (int)$Prm0.DiagArgumentsVal.length);
            for (int __i0 = 0; __i0 != $Prm0.DiagArgumentsStr.length; ++__i0) {
                this.DiagArgumentsStr[__i0].$assign($Prm0.DiagArgumentsStr[__i0]);
            }
            std.memcpy((Object[])this.DiagRanges, (Object[])$Prm0.DiagRanges, (int)$Prm0.DiagRanges.length);
            this.FixItHints.$assign($Prm0.FixItHints);
            return this;
        }

        public void $destroy() {
        }

        public static final class Unnamed_enum
        extends Enum<Unnamed_enum> {
            public static final /* enum */ Unnamed_enum MaxArguments = new Unnamed_enum(org.clang.basic.PartialDiagnostic$Unnamed_enum.MaxArguments.getValue());
            private final int value;
            private static final /* synthetic */ Unnamed_enum[] $VALUES;

            public static Unnamed_enum[] values() {
                return (Unnamed_enum[])$VALUES.clone();
            }

            public static Unnamed_enum valueOf(String name) {
                return Enum.valueOf(Unnamed_enum.class, name);
            }

            public static Unnamed_enum valueOf(int val) {
                Unnamed_enum out;
                Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
                assert (out != null) : "no value for " + val;
                return out;
            }

            private Unnamed_enum(int val) {
                this.value = val;
            }

            public int getValue() {
                return this.value;
            }

            static {
                $VALUES = new Unnamed_enum[]{MaxArguments};
            }

            private static final class Values {
                private static final Unnamed_enum[] VALUES;
                private static final Unnamed_enum[] _VALUES;

                private Values() {
                }

                static {
                    int max = 0;
                    int min = 0;
                    for (Unnamed_enum kind : Unnamed_enum.values()) {
                        if (kind.value > max) {
                            max = kind.value;
                        }
                        if (kind.value >= min) continue;
                        min = kind.value;
                    }
                    _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                    VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                    for (Unnamed_enum kind : Unnamed_enum.values()) {
                        if (kind.value < 0) {
                            Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                            continue;
                        }
                        Values.VALUES[((Unnamed_enum)kind).value] = kind;
                    }
                }
            }
        }
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum MaxArguments = new Unnamed_enum(DiagnosticsEngine.Unnamed_enum3.MaxArguments.getValue());
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{MaxArguments};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

