/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.NoneType;
import org.llvm.adt.Optional;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorInt;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.sys.fs;

public final class SourceManagerStatics {
    public static final boolean CACHE_LINES_OFFSETS = Boolean.valueOf(System.getProperty("clank.cache.lines.offsets", "true"));
    private static final SmallVector<SmallVectorInt> $LineOffsetsPool = new SmallVector(2 * Native.availableProcessors(), null);

    public static boolean isInvalid(SourceLocation Loc, bool.ptr Invalid) {
        return SourceManagerStatics.isInvalid(Loc.getRawEncodingUInt(), Invalid);
    }

    public static boolean isInvalid(int Loc, bool.ptr Invalid) {
        boolean MyInvalid = SourceLocation.isInvalid(Loc);
        if (Invalid != null) {
            Invalid.$set(MyInvalid);
        }
        return MyInvalid;
    }

    public static boolean ComputeLineNumbers(DiagnosticsEngine Diag, SrcMgr.ContentCache FI, BumpPtrAllocator Alloc, SourceManager SM, bool.ptr Invalid) {
        SmallVectorInt $LineOffsets = SourceManagerStatics.$getLineOffsets();
        boolean out = SourceManagerStatics.ComputeLineNumbers(Diag, FI, Alloc, SM, $LineOffsets, Invalid);
        SourceManagerStatics.$releaseLineOffsets($LineOffsets);
        return out;
    }

    private static boolean ComputeLineNumbers(DiagnosticsEngine Diag, SrcMgr.ContentCache FI, BumpPtrAllocator Alloc, SourceManager SM, SmallVectorInt LineOffsets, bool.ptr Invalid) {
        assert (Invalid == null) : "use return value \"true\" as marker of invalid computation";
        MemoryBuffer Buffer2 = FI.getBuffer(Diag, SM, SourceLocation.getInvalid(), Invalid);
        if (Buffer2.isInvalid()) {
            return true;
        }
        if (CACHE_LINES_OFFSETS) {
            FI.SourceLineCache = Buffer2.getSourceLineCache();
            if (FI.SourceLineCache != null) {
                FI.NumLines = FI.SourceLineCache.length;
                return false;
            }
        }
        assert (LineOffsets != null);
        LineOffsets.push_back(0);
        char.ptr $Buf = Buffer2.getBufferStart();
        int Buf = 0;
        int End = Buffer2.getBufferEnd().$index() - $Buf.$index();
        int Offs = 0;
        while (true) {
            int NextBuf = ++Buf;
            while ($Buf.$at(NextBuf) != NativePointer.$LF && $Buf.$at(NextBuf) != NativePointer.$CR && $Buf.$at(NextBuf) != NativePointer.$TERM) {
                ++NextBuf;
            }
            Offs += NextBuf - Buf;
            Buf = NextBuf;
            if ($Buf.$at(Buf) == NativePointer.$LF || $Buf.$at(Buf) == NativePointer.$CR) {
                if (($Buf.$at(Buf + 1) == NativePointer.$LF || $Buf.$at(Buf + 1) == NativePointer.$CR) && $Buf.$at(Buf) != $Buf.$at(Buf + 1)) {
                    ++Offs;
                    ++Buf;
                }
                ++Buf;
                assert (++Offs >= 0) : "must be unsigned int";
                LineOffsets.push_back(Offs);
                continue;
            }
            if (Buf == End) break;
            ++Offs;
        }
        FI.NumLines = LineOffsets.size();
        if (CACHE_LINES_OFFSETS) {
            FI.SourceLineCache = NativePointer.new$int((int)FI.NumLines);
        } else {
            int.ptr AllocateIntPtr = Alloc.AllocateInt(LineOffsets.size());
            assert (AllocateIntPtr.$index() == 0) : "only zero-based arrays are supported (introduce index field if plan to use int[] from Slabs)";
            FI.SourceLineCache = AllocateIntPtr.$array();
            assert (FI.NumLines == FI.SourceLineCache.length) : "same size is expected " + FI.NumLines + " vs. " + FI.SourceLineCache.length;
        }
        std.copy((int[])LineOffsets.$array(), (int)0, (int)LineOffsets.size(), (int[])FI.SourceLineCache, (int)0);
        if (CACHE_LINES_OFFSETS) {
            Buffer2.setSourceLineCache(FI.SourceLineCache, FI.NumLines);
        }
        return false;
    }

    public static Optional<fs.UniqueID> getActualFileUID(FileEntry File2) {
        if (File2 == null) {
            return new Optional(NoneType.None);
        }
        fs.UniqueID ID2 = new fs.UniqueID();
        if (fs.getUniqueID((Twine)new Twine(File2.getName()), (fs.UniqueID)ID2).$Void2Void() != null) {
            return new Optional(NoneType.None);
        }
        return new Optional((Object)ID2);
    }

    public static boolean MoveUpIncludeHierarchy(std.pairIntInt Loc, SourceManager SM) {
        long UpperLoc = SM.getDecomposedIncludedLoc(Loc.first);
        if (FileID.isInvalid(ClangGlobals.$first_FileID(UpperLoc))) {
            return true;
        }
        Loc.$assign(UpperLoc);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SmallVectorInt $getLineOffsets() {
        SmallVector<SmallVectorInt> smallVector = $LineOffsetsPool;
        synchronized (smallVector) {
            if (!$LineOffsetsPool.empty()) {
                return (SmallVectorInt)$LineOffsetsPool.pop_back_val();
            }
        }
        return new SmallVectorInt(NativeMemory.Allocator.PageSize, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void $releaseLineOffsets(SmallVectorInt LineOffsets) {
        LineOffsets.resize(0);
        SmallVector<SmallVectorInt> smallVector = $LineOffsetsPool;
        synchronized (smallVector) {
            $LineOffsetsPool.push_back((Object)LineOffsets);
        }
    }
}

