/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import org.clang.basic.ClangGlobals;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.Lexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clang.tools.services.support.FileInfoCallback;
import org.llvm.adt.SmallString;
import org.netbeans.modules.cnd.apt.impl.support.APTCommentToken;
import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteIdToken;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteLiteralToken;
import org.netbeans.modules.cnd.apt.impl.support.MacroExpandedToken;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankToAPTUtils;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.CharSequences;

class ClankToAPTToken
implements APTToken {
    private static final int FAKE_LINE = 333;
    private static final int FAKE_COLUMN = 111;
    private final int endOffset;
    private final int aptTokenType;
    private final int offset;
    private final CharSequence textID;

    static APTToken[] convertToAPT(Preprocessor PP, SmallVectorToken toks, boolean needLineColumns) {
        int nrTokens = toks.size();
        Token[] tokens = toks.$array();
        APTToken[] out = new APTToken[nrTokens];
        SmallString spell = new SmallString(1024);
        long lastExpansionRange = -1L;
        int lastExpandedStartOffset = 0;
        APTCommentToken lastEndOffsetToken = null;
        for (int i = 0; i < nrTokens; ++i) {
            int offset;
            APTToken converted;
            boolean needToWrapAsMacro;
            assert (PP != null);
            SourceManager SM = PP.getSourceManager();
            assert (SM != null);
            Token token = tokens[i];
            FileInfoCallback.MacroExpansionInfo info = null;
            if (token.isAnnotation() && token.getAnnotationValue() instanceof FileInfoCallback.MacroExpansionInfo) {
                info = (FileInfoCallback.MacroExpansionInfo)token.getAnnotationValue();
            }
            int rawLocation = token.getRawLocation();
            boolean isFromRealMacro = info == null && SourceLocation.isMacroID((int)rawLocation);
            APTCommentToken endOffsetToken = null;
            boolean bl = needToWrapAsMacro = isFromRealMacro || info != null;
            if (info != null) {
                converted = ClankToAPTToken.convertAnnotation(PP, token, info, needLineColumns);
                lastExpandedStartOffset = info.getStartOffset();
                lastExpansionRange = info.getRawExpansionRange();
                endOffsetToken = lastEndOffsetToken = (APTCommentToken)converted;
                needToWrapAsMacro = true;
                assert (APTUtils.isCommentToken(converted)) : "annotated token must be comment";
            } else if (isFromRealMacro) {
                long curExpansionRange = SM.getExpansionRange(rawLocation);
                if (lastExpansionRange != curExpansionRange) {
                    long decomposedRangeStart = SM.getDecomposedLoc(ClangGlobals.$first_SourceLocation((long)curExpansionRange));
                    long decomposedRangeEnd = SM.getDecomposedLoc(ClangGlobals.$second_SourceLocation((long)curExpansionRange));
                    lastExpandedStartOffset = ClangGlobals.$second_offset((long)decomposedRangeStart);
                    int TokSize = Lexer.MeasureTokenLength((int)ClangGlobals.$second_SourceLocation((long)curExpansionRange), (SourceManager)SM, (LangOptions)PP.getLangOpts());
                    int expandedEndOffset = ClangGlobals.$second_offset((long)decomposedRangeEnd);
                    expandedEndOffset += TokSize;
                    int tokenEndLine = 333;
                    int tokenEndColumn = 111;
                    if (needLineColumns) {
                        tokenEndLine = SM.getLineNumber(ClangGlobals.$first_FileID((long)decomposedRangeEnd), ClangGlobals.$second_offset((long)decomposedRangeEnd), null);
                        tokenEndColumn = SM.getColumnNumber(ClangGlobals.$first_FileID((long)decomposedRangeEnd), ClangGlobals.$second_offset((long)decomposedRangeEnd), null);
                    }
                    lastEndOffsetToken = new APTCommentToken();
                    lastEndOffsetToken.setType(485);
                    lastEndOffsetToken.setOffset(expandedEndOffset);
                    lastEndOffsetToken.setTextLength(0);
                    lastEndOffsetToken.setColumn(tokenEndColumn);
                    lastEndOffsetToken.setLine(tokenEndLine);
                    lastExpansionRange = curExpansionRange;
                }
                endOffsetToken = lastEndOffsetToken;
                offset = lastExpandedStartOffset;
                converted = ClankToAPTToken.convert(PP, token, offset, spell, needLineColumns);
                needToWrapAsMacro = true;
            } else {
                long decomposedLoc = SM.getDecomposedLoc(rawLocation);
                offset = ClangGlobals.$second_offset((long)decomposedLoc);
                converted = ClankToAPTToken.convert(PP, token, offset, spell, needLineColumns);
            }
            if (needToWrapAsMacro) {
                assert (endOffsetToken != null);
                converted = new MacroExpandedToken(converted, converted, endOffsetToken);
                assert (info == null || APTUtils.isCommentToken(converted)) : "annotated token must be macro expanded comment";
            }
            out[i] = converted;
        }
        return out;
    }

    private static APTToken convertAnnotation(Preprocessor PP, Token token, FileInfoCallback.MacroExpansionInfo info, boolean needLineColumns) {
        int tokenLine = 333;
        int tokenColumn = 111;
        if (needLineColumns) {
            SourceManager SM = PP.getSourceManager();
            long LocInfo = SM.getDecomposedExpansionLoc(token.getRawLocation());
            tokenLine = SM.getLineNumber(ClangGlobals.$first_FileID((long)LocInfo), ClangGlobals.$second_offset((long)LocInfo), null);
            tokenColumn = SM.getColumnNumber(ClangGlobals.$first_FileID((long)LocInfo), ClangGlobals.$second_offset((long)LocInfo), null);
        }
        APTCommentToken out = new APTCommentToken();
        out.setType(485);
        out.setOffset(info.getStartOffset());
        out.setTextLength(info.getEndOffset() - info.getStartOffset());
        out.setColumn(tokenColumn);
        out.setLine(tokenLine);
        return out;
    }

    static APTToken convert(Preprocessor PP, Token token, int offset, SmallString spell, boolean needLineColumns) {
        int aptTokenType;
        if (token.is((short)1)) {
            return APTUtils.EOF_TOKEN;
        }
        int tokenLine = 333;
        int tokenColumn = 111;
        if (needLineColumns) {
            SourceManager SM = PP.getSourceManager();
            long LocInfo = SM.getDecomposedExpansionLoc(token.getRawLocation());
            tokenLine = SM.getLineNumber(ClangGlobals.$first_FileID((long)LocInfo), ClangGlobals.$second_offset((long)LocInfo), null);
            tokenColumn = SM.getColumnNumber(ClangGlobals.$first_FileID((long)LocInfo), ClangGlobals.$second_offset((long)LocInfo), null);
        }
        if (APTLiteConstTextToken.isApplicable(aptTokenType = ClankToAPTUtils.convertClankToAPTTokenKind(token.getKind()), offset, tokenColumn, tokenLine)) {
            APTLiteConstTextToken out = new APTLiteConstTextToken(aptTokenType, offset, tokenColumn, tokenLine);
            return out;
        }
        if (aptTokenType == 485) {
            APTCommentToken out = new APTCommentToken();
            out.setType(485);
            out.setOffset(offset);
            out.setTextLength(token.getLength());
            out.setColumn(tokenColumn);
            out.setLine(tokenLine);
            return out;
        }
        CharSequence textID = ClankToAPTUtils.getTokenText(token, PP, spell);
        int literalType = aptTokenType;
        if (aptTokenType > 109 && aptTokenType < 266) {
            aptTokenType = 91;
        } else if (aptTokenType == 67 && textID.length() > 0 && textID.charAt(0) == '0') {
            aptTokenType = 66;
        }
        if (APTLiteLiteralToken.isApplicable(91, offset, tokenColumn, tokenLine, literalType)) {
            CharSequence LiteText = APTConstTextToken.getConstTextID(literalType);
            if (CharSequences.comparator().compare(textID, LiteText) == 0) {
                return new APTLiteLiteralToken(offset, tokenColumn, tokenLine, literalType);
            }
        }
        if (APTLiteIdToken.isApplicable(aptTokenType, offset, tokenColumn, tokenLine)) {
            return new APTLiteIdToken(offset, tokenColumn, tokenLine, textID);
        }
        if (needLineColumns) {
            return new ClankToAPTTokenWithLineAndColumn(token, aptTokenType, offset, tokenColumn, tokenLine, textID);
        }
        return new ClankToAPTToken(token, aptTokenType, offset, textID);
    }

    private ClankToAPTToken(Token token, int tokenType, int offset, CharSequence text) {
        this.offset = offset;
        assert (offset >= 0) : "negative " + offset + " for " + token;
        this.endOffset = this.offset + token.getLength();
        this.aptTokenType = tokenType;
        assert (!APTLiteConstTextToken.isLiteConstTextType(this.aptTokenType));
        assert (!APTLiteLiteralToken.isApplicable(91, offset, 111, 333, this.aptTokenType));
        assert (!APTLiteIdToken.isApplicable(this.aptTokenType, offset, 111, 333));
        assert (text != null);
        assert (CharSequences.isCompact((CharSequence)text));
        assert (token.isNot((short)4));
        this.textID = TextCache.getManager().getString(text);
        assert (this.textID.length() <= token.getLength()) : this.textID + "\n vs. \n" + token;
    }

    public int getType() {
        return this.aptTokenType;
    }

    @Override
    public String getText() {
        return this.getTextID().toString();
    }

    @Override
    public CharSequence getTextID() {
        return this.textID;
    }

    public String toString() {
        return "ClankToAPTToken{offset=" + this.offset + "; aptType=" + APTUtils.getAPTTokenName(this.aptTokenType) + ":" + this.textID + '}';
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndColumn() {
        return 222;
    }

    @Override
    public void setEndColumn(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndLine() {
        return 444;
    }

    @Override
    public void setEndLine(int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTextID(CharSequence id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(Object key) {
        throw new UnsupportedOperationException();
    }

    public int getColumn() {
        return 111;
    }

    public void setColumn(int c) {
        throw new UnsupportedOperationException();
    }

    public int getLine() {
        return 333;
    }

    public void setLine(int l) {
        throw new UnsupportedOperationException();
    }

    public String getFilename() {
        return null;
    }

    public void setFilename(String name) {
        throw new UnsupportedOperationException();
    }

    public void setText(String t) {
        throw new UnsupportedOperationException();
    }

    public void setType(int t) {
        throw new UnsupportedOperationException();
    }

    private static final class ClankToAPTTokenWithLineAndColumn
    extends ClankToAPTToken {
        private final int line;
        private final int column;
        private final int endColumn;

        public ClankToAPTTokenWithLineAndColumn(Token token, int tokenType, int offset, int column, int line, CharSequence text) {
            super(token, tokenType, offset, text);
            this.line = line;
            this.column = column;
            this.endColumn = column + token.getLength();
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getEndLine() {
            return this.line;
        }

        @Override
        public int getColumn() {
            return this.column;
        }

        @Override
        public int getEndColumn() {
            return this.endColumn;
        }
    }
}

