/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.APTCommentToken;
import org.netbeans.modules.cnd.apt.impl.support.MacroExpandedToken;
import org.netbeans.modules.cnd.apt.support.APTExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTMacroExpandedStream
extends APTExpandedStream {
    private final boolean emptyExpansionAsComment;
    private int generatedTokens = 0;
    private static final int EOF_MARKER = -1;
    private static final int MAX_GENERATED_TOKENS = Integer.getInteger("apt.limit.tokens", 8000000);
    private static final int MIN_REPORTED_TOKENS = Integer.getInteger("apt.report.tokens", Integer.MAX_VALUE);

    public APTMacroExpandedStream(TokenStream stream, APTMacroCallback callback, boolean emptyExpansionAsComment) {
        super(stream, callback);
        this.emptyExpansionAsComment = emptyExpansionAsComment;
    }

    @Override
    protected APTTokenStream createMacroBodyWrapper(APTToken token, APTMacro macro) throws TokenStreamException, RecognitionException {
        APTTokenStream origExpansion = super.createMacroBodyWrapper(token, macro);
        APTToken last = this.getLastExtractedParamRPAREN();
        if (last == null) {
            last = token;
        }
        MacroExpandWrapper expandedMacros = new MacroExpandWrapper(token, origExpansion, last, this.emptyExpansionAsComment);
        return expandedMacros;
    }

    @Override
    public APTToken nextToken() {
        if (this.generatedTokens == -1) {
            return APTUtils.EOF_TOKEN;
        }
        if (++this.generatedTokens > MAX_GENERATED_TOKENS) {
            APTUtils.LOG.log(Level.SEVERE, "stop ({0} is too much) generating tokens {1}", new Object[]{MAX_GENERATED_TOKENS, Thread.currentThread().getName()});
            this.generatedTokens = -1;
            return APTUtils.EOF_TOKEN;
        }
        APTToken token = super.nextToken();
        if (token == APTUtils.EOF_TOKEN) {
            if (this.generatedTokens > MIN_REPORTED_TOKENS) {
                APTUtils.LOG.log(Level.SEVERE, "generated {0} tokens for {1}", new Object[]{this.generatedTokens, Thread.currentThread().getName()});
            }
            this.generatedTokens = -1;
        }
        return token;
    }

    private static final class MacroExpandWrapper
    implements TokenStream,
    APTTokenStream {
        private final APTToken expandedFrom;
        private final APTTokenStream expandedMacros;
        private final APTToken endOffsetToken;
        private boolean firstToken = true;
        private final boolean emptyExpansionAsComment;

        public MacroExpandWrapper(APTToken expandedFrom, APTTokenStream expandedMacros, APTToken endOffsetToken, boolean emptyExpansionAsComment) {
            this.expandedFrom = expandedFrom;
            this.expandedMacros = expandedMacros;
            assert (endOffsetToken != null) : "end offset token must be valid";
            this.endOffsetToken = endOffsetToken;
            this.emptyExpansionAsComment = emptyExpansionAsComment;
        }

        @Override
        public APTToken nextToken() {
            APTToken expandedTo = this.expandedMacros.nextToken();
            if (this.emptyExpansionAsComment && this.firstToken && APTUtils.isEOF(expandedTo)) {
                expandedTo = new APTCommentToken();
                expandedTo.setType(485);
            }
            this.firstToken = false;
            MacroExpandedToken outToken = new MacroExpandedToken(this.expandedFrom, expandedTo, this.endOffsetToken);
            return outToken;
        }
    }
}

