/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.LinkedList;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTStream;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public abstract class APTWalker {
    private final APTMacroMap macros;
    private final APTFile root;
    private Boolean walkerUsedForTokenStreamGeneration = null;
    private boolean stopped = false;
    private APTFile curFile;
    private APT curAPT;
    private boolean curWasInChild;
    private static final int INVALID_INDEX = -2;
    private static final int EMPTY_INDEX = -1;
    private int curIncludeDirectiveFileIndex = -2;
    private LinkedList<TokenStream> tokens = new LinkedList();
    private LinkedList<WalkerState> visits = new LinkedList();

    public APTWalker(APTFile apt, APTMacroMap macros) {
        assert (apt != null) : "how can we work on null tree?";
        this.root = apt;
        this.macros = macros;
    }

    public void visit() {
        this.init(false);
        while (!this.finished()) {
            this.toNextNode();
        }
        this.onEOF();
    }

    public TokenStream getTokenStream() {
        return new WalkerTokenStream();
    }

    protected final boolean isTokenProducer() {
        return this.walkerUsedForTokenStreamGeneration == Boolean.TRUE;
    }

    protected void onInclude(APT apt) {
        assert (this.curIncludeDirectiveFileIndex != -2) : "must not be invalid ";
        ++this.curIncludeDirectiveFileIndex;
    }

    protected void onIncludeNext(APT apt) {
        assert (this.curIncludeDirectiveFileIndex != -2) : "must not be invalid ";
        ++this.curIncludeDirectiveFileIndex;
    }

    protected abstract void onDefine(APT var1);

    protected abstract void onUndef(APT var1);

    protected abstract boolean onIf(APT var1);

    protected abstract boolean onIfdef(APT var1);

    protected abstract boolean onIfndef(APT var1);

    protected abstract boolean onElif(APT var1, boolean var2);

    protected abstract boolean onElse(APT var1, boolean var2);

    protected abstract void onEndif(APT var1, boolean var2);

    protected abstract void onPragmaNode(APT var1);

    protected void onStreamNode(APT apt) {
    }

    protected void onErrorNode(APT apt) {
    }

    protected void onOtherNode(APT apt) {
    }

    protected void onEOF() {
    }

    protected boolean stopOnErrorDirective() {
        return true;
    }

    protected boolean onAPT(APT node, boolean wasInBranch) {
        boolean visitChild = false;
        switch (node.getType()) {
            case 9: {
                visitChild = this.onIf(node);
                break;
            }
            case 7: {
                visitChild = this.onIfdef(node);
                break;
            }
            case 8: {
                visitChild = this.onIfndef(node);
                break;
            }
            case 10: {
                visitChild = this.onElif(node, wasInBranch);
                break;
            }
            case 11: {
                visitChild = this.onElse(node, wasInBranch);
                break;
            }
            case 12: {
                this.onEndif(node, wasInBranch);
                break;
            }
            case 5: {
                this.onDefine(node);
                break;
            }
            case 6: {
                this.onUndef(node);
                break;
            }
            case 3: {
                this.onInclude(node);
                break;
            }
            case 4: {
                this.onIncludeNext(node);
                break;
            }
            case 2: {
                this.onStreamNode(node);
                break;
            }
            case 15: {
                this.onErrorNode(node);
                break;
            }
            case 13: {
                this.onPragmaNode(node);
                break;
            }
            case 0: 
            case 14: 
            case 16: {
                this.onOtherNode(node);
                break;
            }
            default: {
                assert (false) : "unsupported " + APTTraceUtils.getTypeName(node);
                break;
            }
        }
        if (APTUtils.LOG.isLoggable(Level.FINE)) {
            APTUtils.LOG.log(Level.FINE, "onAPT: {0}; {1} {2}", new Object[]{node, wasInBranch ? "Was before;" : "", visitChild ? "Will visit children" : ""});
        }
        this.fillTokensIfNeeded(node);
        return visitChild;
    }

    protected final void pushState() {
        this.visits.addLast(new WalkerState(this.curFile, this.curAPT, this.curWasInChild, this.curIncludeDirectiveFileIndex));
    }

    protected void preInit() {
    }

    private boolean popState() {
        if (this.visits.isEmpty()) {
            return false;
        }
        WalkerState state = this.visits.removeLast();
        this.curFile = state.lastFile;
        this.curAPT = state.lastNode;
        this.curWasInChild = state.wasInChild;
        this.curIncludeDirectiveFileIndex = state.curIncludeDirectiveFileIndex;
        return true;
    }

    private void init(boolean needStream) {
        if (this.walkerUsedForTokenStreamGeneration != null) {
            throw new IllegalStateException("walker could be used only once");
        }
        this.walkerUsedForTokenStreamGeneration = needStream;
        assert (this.curIncludeDirectiveFileIndex == -2) : "must be invalid " + this.curIncludeDirectiveFileIndex;
        this.curIncludeDirectiveFileIndex = -1;
        this.preInit();
        this.curFile = this.root;
        this.curAPT = this.curFile.getFirstChild();
        this.curWasInChild = false;
        this.pushState();
    }

    private APTToken nextTokenImpl() throws TokenStreamException {
        while (true) {
            if (!this.tokens.isEmpty()) {
                TokenStream ts = this.tokens.peek();
                APTToken theRetToken = (APTToken)ts.nextToken();
                if (!APTUtils.isEOF(theRetToken)) {
                    return theRetToken;
                }
                this.tokens.removeFirst();
                continue;
            }
            if (this.finished()) {
                this.onEOF();
                return APTUtils.EOF_TOKEN;
            }
            this.toNextNode();
        }
    }

    private void toNextNode() {
        this.popState();
        if (this.finished()) {
            return;
        }
        if (this.curAPT == null) {
            APTUtils.LOG.log(Level.SEVERE, "incomplete APT {0}", new Object[]{this.curFile});
            do {
                this.popState();
                if (this.curAPT == null) continue;
                this.curAPT = this.curAPT.getNextSibling();
            } while (this.curAPT == null && !this.finished());
            if (this.curAPT == null) {
                return;
            }
        }
        if (APTUtils.isStartConditionNode(this.curAPT.getType())) {
            this.curWasInChild = false;
        }
        boolean visitChild = this.onAPT(this.curAPT, this.curWasInChild);
        this.curWasInChild |= visitChild;
        if (visitChild) {
            assert (APTUtils.isStartOrSwitchConditionNode(this.curAPT.getType()));
            if (this.curAPT.getFirstChild() != null) {
                this.pushState();
                this.curAPT = this.curAPT.getFirstChild();
                this.curWasInChild = false;
            } else {
                this.curAPT = this.curAPT.getNextSibling();
            }
        } else {
            if (this.curAPT.getType() != 12) {
                if (this.curAPT.getType() == 15) {
                    if (this.stopOnErrorDirective()) {
                        this.stop();
                        return;
                    }
                } else if (this.curAPT.getType() == 13 && this.isStopped() && this.stopOnErrorDirective()) {
                    return;
                }
            }
            this.curAPT = this.curAPT.getNextSibling();
            while (this.curAPT == null && !this.finished()) {
                this.popState();
                this.curAPT = this.curAPT.getNextSibling();
            }
        }
        if (!this.finished()) {
            this.pushState();
        }
    }

    private void fillTokensIfNeeded(APT node) {
        if (this.isTokenProducer() && node != null && node.getType() == 2) {
            this.pushTokenStream(((APTStream)node).getTokenStream());
        }
    }

    protected final void pushTokenStream(TokenStream ts) {
        this.tokens.add(ts);
    }

    private boolean finished() {
        return this.curAPT == null && this.visits.isEmpty() || this.isStopped();
    }

    protected final APTMacroMap getMacroMap() {
        return this.macros;
    }

    protected final APTFile getCurFile() {
        return this.curFile;
    }

    protected final APT getCurNode() {
        return this.curAPT;
    }

    protected final int getCurIncludeDirectiveFileIndex() {
        assert (this.curIncludeDirectiveFileIndex != -2) : "must not be invalid ";
        return this.curIncludeDirectiveFileIndex;
    }

    protected final APTFile getRootFile() {
        return this.root;
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    protected final void stop() {
        this.stopped = true;
    }

    private static final class WalkerState {
        private final APT lastNode;
        private final APTFile lastFile;
        private final boolean wasInChild;
        private final int curIncludeDirectiveFileIndex;

        private WalkerState(APTFile file, APT node, boolean wasInChildState, int curIncludeDirectiveFileIndex) {
            this.lastFile = file;
            this.lastNode = node;
            this.wasInChild = wasInChildState;
            this.curIncludeDirectiveFileIndex = curIncludeDirectiveFileIndex;
        }
    }

    private final class WalkerTokenStream
    implements TokenStream,
    APTTokenStream {
        private WalkerTokenStream() {
            APTWalker.this.init(true);
        }

        @Override
        public APTToken nextToken() {
            try {
                return APTWalker.this.nextTokenImpl();
            }
            catch (TokenStreamException ex) {
                APTUtils.LOG.log(Level.WARNING, "{0}:{1}", new Object[]{APTWalker.this.curFile.getPath(), ex});
                return APTUtils.EOF_TOKEN;
            }
        }
    }
}

