/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support.api;

import java.io.IOException;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;
import org.openide.util.Parameters;

public final class StartEntry
implements SelfPersistent {
    private final CharSequence startFile;
    private final Key startFileProject;
    private final transient FileSystem fileSystem;

    public StartEntry(FileSystem fs2, String startFile, Key startFileProject) {
        Parameters.notNull((CharSequence)"startFileProject", (Object)startFileProject);
        this.fileSystem = fs2;
        this.startFile = FilePathCache.getManager().getString((CharSequence)startFile);
        this.startFileProject = startFileProject;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public CharSequence getStartFile() {
        return this.startFile;
    }

    public APTFileSearch getFileSearch() {
        return APTFileSearch.get(this.startFileProject);
    }

    public Key getStartFileProject() {
        return this.startFileProject;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        assert (output != null);
        output.writeFileSystem(this.fileSystem);
        output.writeFilePathForFileSystem(this.fileSystem, this.startFile);
        KeyFactory.getDefaultFactory().writeKey(this.startFileProject, output);
    }

    public StartEntry(RepositoryDataInput input) throws IOException {
        assert (input != null);
        this.fileSystem = input.readFileSystem();
        this.startFile = input.readFilePathForFileSystem(this.fileSystem);
        this.startFileProject = KeyFactory.getDefaultFactory().readKey(input);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartEntry other = (StartEntry)obj;
        if (!(this.startFile == other.startFile || this.startFile != null && this.startFile.equals(other.startFile))) {
            return false;
        }
        return this.startFileProject == other.startFileProject || this.startFileProject != null && this.startFileProject.equals(other.startFileProject);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.startFile != null ? this.startFile.hashCode() : 0);
        hash = 89 * hash + (this.startFileProject != null ? this.startFileProject.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Start Entry: from file=").append(this.startFile).append("\nof project=").append(this.startFileProject);
        return out.toString();
    }
}

