/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.Driver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDriver
implements Driver {
    @Override
    public List<String> splitCommandLine(String line, CompileLineOrigin isScriptOutput) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        block5: while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            switch (c) {
                case '\'': {
                    if (isSingleQuoteMode) {
                        isSingleQuoteMode = false;
                    } else if (!isDoubleQuoteMode) {
                        isSingleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\"': {
                    if (isDoubleQuoteMode) {
                        isDoubleQuoteMode = false;
                    } else if (!isSingleQuoteMode) {
                        isDoubleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (isSingleQuoteMode || isDoubleQuoteMode) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    res.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            res.add(current.toString());
        }
        return res;
    }

    @Override
    public Artifacts gatherCompilerLine(String compileLine, CompileLineOrigin isScriptOutput, boolean isCpp) {
        if (compileLine.length() > 0) {
            return this.gatherCompilerLine(this.splitCommandLine(compileLine, isScriptOutput).listIterator(), isScriptOutput, isCpp);
        }
        return new ArtifactsImpl();
    }

    @Override
    public Artifacts gatherCompilerLine(ListIterator<String> st, CompileLineOrigin isScriptOutput, boolean isCpp) {
        ArtifactsImpl res = new ArtifactsImpl();
        while (st.hasNext()) {
            String path;
            String macro;
            String option = st.next();
            if (option.startsWith("--")) {
                option = option.substring(1);
            }
            if (option.startsWith("-D")) {
                macro = option.substring(2);
                int i = macro.indexOf(61);
                if (i > 0) {
                    String value = macro.substring(i + 1).trim();
                    if (value.length() >= 2 && (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'' || value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"')) {
                        value = value.substring(1, value.length() - 1);
                    }
                    res.userMacros.put(macro.substring(0, i), value);
                    continue;
                }
                res.userMacros.put(macro, null);
                continue;
            }
            if (option.startsWith("-I")) {
                path = option.substring(2);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                res.userIncludes.add(this.removeQuotes(path));
                continue;
            }
            if (option.startsWith("-U")) {
                macro = option.substring(2);
                if (macro.length() == 0 && st.hasNext()) {
                    macro = st.next();
                }
                res.undefinedMacros.add(this.removeQuotes(macro));
                continue;
            }
            if (option.startsWith("-Y")) {
                String defaultSearchPath = option.substring(2);
                if (defaultSearchPath.length() == 0 && st.hasNext()) {
                    defaultSearchPath = st.next();
                }
                if (!defaultSearchPath.startsWith("I,")) continue;
                defaultSearchPath = defaultSearchPath.substring(2);
                res.userIncludes.add(this.removeQuotes(defaultSearchPath));
                continue;
            }
            if (option.startsWith("-isystem")) {
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                res.userIncludes.add(this.removeQuotes(path));
                continue;
            }
            if (option.startsWith("-include")) {
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                res.userFiles.add(this.removeQuotes(path));
                continue;
            }
            if (!option.startsWith("-imacros")) continue;
            path = option.substring(8);
            if (path.length() == 0 && st.hasNext()) {
                path = st.next();
            }
            res.userFiles.add(this.removeQuotes(path));
        }
        return res;
    }

    private String removeQuotes(String str) {
        if (str.length() >= 2 && (str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"')) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArtifactsImpl
    implements Artifacts {
        public final List<String> input = new ArrayList<String>();
        public final List<String> userIncludes = new ArrayList<String>();
        public final List<String> userFiles = new ArrayList<String>();
        public final Map<String, String> userMacros = new HashMap<String, String>();
        public final List<String> undefinedMacros = new ArrayList<String>();
        public final Set<String> libraries = new HashSet<String>();
        public final List<String> languageArtifacts = new ArrayList<String>();
        public final List<String> importantFlags = new ArrayList<String>();
        public String output;

        private ArtifactsImpl() {
        }

        @Override
        public List<String> getInput() {
            return this.input;
        }

        @Override
        public List<String> getUserIncludes() {
            return this.userIncludes;
        }

        @Override
        public List<String> getUserFiles() {
            return this.userFiles;
        }

        @Override
        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        @Override
        public List<String> getUserUndefinedMacros() {
            return this.undefinedMacros;
        }

        @Override
        public Set<String> getLibraries() {
            return this.libraries;
        }

        @Override
        public List<String> getLanguageArtifacts() {
            return this.languageArtifacts;
        }

        @Override
        public List<String> getImportantFlags() {
            return this.importantFlags;
        }

        @Override
        public String getOutput() {
            return this.output;
        }
    }
}

