/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.exec;

import java.awt.EventQueue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phing.PhingBuildTool;
import org.netbeans.modules.php.phing.exec.Bundle;
import org.netbeans.modules.php.phing.file.BuildXml;
import org.netbeans.modules.php.phing.options.PhingOptions;
import org.netbeans.modules.php.phing.options.PhingOptionsValidator;
import org.netbeans.modules.php.phing.util.PhingUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class PhingExecutable {
    static final Logger LOGGER = Logger.getLogger(PhingExecutable.class.getName());
    public static final String PHING_NAME = "phing";
    @SuppressWarnings(value={"MS_MUTABLE_ARRAY"}, justification="No need to worry, noone will change it")
    public static final String[] PHING_NAMES;
    private static final String LOGGER_PARAM = "-logger";
    private static final String LOGGER_COLOR_VALUE = "phing.listener.AnsiColorLogger";
    private static final String LIST_PARAM = "-list";
    private static final String QUIET_PARAM = "-quiet";
    private static final File TMP_DIR;
    private final Project project;
    private final String phingPath;

    PhingExecutable(String phingPath, @NullAllowed Project project) {
        assert (phingPath != null);
        this.phingPath = phingPath;
        this.project = project;
    }

    @CheckForNull
    public static PhingExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new PhingOptionsValidator().validatePhing().getResult();
        if (PhingExecutable.validateResult(result) != null) {
            if (showOptions) {
                UiUtils.showOptions((String)"FrameworksAndTools/Phing");
            }
            return null;
        }
        return new PhingExecutable(PhingOptions.getInstance().getPhing(), project);
    }

    private String getCommand() {
        return this.phingPath;
    }

    public Future<Integer> run(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = PhingUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.PhingExecutable_run(projectName)).additionalParameters(this.getRunParams(args)).run(this.getDescriptor());
        assert (task != null) : this.phingPath;
        return task;
    }

    public Future<List<String>> listTargets() {
        final PhingTargetsLineProcessor phingTargetsLineProcessor = new PhingTargetsLineProcessor();
        Future task = this.getExecutable("list phing targets").noInfo(true).additionalParameters(Arrays.asList(QUIET_PARAM, LIST_PARAM)).redirectErrorStream(false).run(PhingExecutable.getSilentDescriptor(), new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)phingTargetsLineProcessor);
            }
        });
        assert (task != null) : this.phingPath;
        return new TargetList(task, phingTargetsLineProcessor);
    }

    private PhpExecutable getExecutable(String title) {
        assert (title != null);
        return new PhpExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsSubcategory("FrameworksAndTools/Phing");
    }

    private List<String> getRunParams(String[] args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 2);
        params.add(LOGGER_PARAM);
        params.add(LOGGER_COLOR_VALUE);
        params.addAll(Arrays.asList(args));
        return params;
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Phing").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{PhingExecutable.this.getWorkDir()});
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8).outLineBased(true);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return TMP_DIR;
        }
        BuildXml buildXml = PhingBuildTool.forProject(this.project).getBuildXml();
        if (buildXml.exists()) {
            return buildXml.getFile().getParentFile();
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    static {
        TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
        PHING_NAMES = new String[]{Utilities.isWindows() ? "phing.bat" : PHING_NAME, "phing.php", "phing-latest.phar"};
    }

    private static final class TargetList
    implements Future<List<String>> {
        private final Future<Integer> task;
        private final PhingTargetsLineProcessor processor;
        private List<String> phingTargets = null;

        TargetList(Future<Integer> task, PhingTargetsLineProcessor processor) {
            assert (task != null);
            assert (processor != null);
            this.task = task;
            this.processor = processor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                this.task.get();
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getPhingTargets();
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.task.get(timeout, unit);
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getPhingTargets();
        }

        private synchronized List<String> getPhingTargets() {
            if (this.phingTargets != null) {
                return Collections.unmodifiableList(this.phingTargets);
            }
            ArrayList<String> targets = new ArrayList<String>(this.processor.getTargets());
            Collections.sort(targets);
            this.phingTargets = new CopyOnWriteArrayList<String>(targets);
            return Collections.unmodifiableList(this.phingTargets);
        }
    }

    private static final class PhingTargetsLineProcessor
    implements LineProcessor {
        private static final String MAIN_TARGETS = "Main targets:";
        private static final String SUBTARGETS = "Subtargets:";
        final List<String> targets = new ArrayList<String>();
        boolean collecting = false;

        private PhingTargetsLineProcessor() {
        }

        public void processLine(String line) {
            String trimmed = line.trim();
            if (this.collecting) {
                if (!SUBTARGETS.equals(trimmed) && StringUtilities.hasText((String)trimmed.replace('-', ' '))) {
                    this.targets.add((String)StringUtilities.explode((String)trimmed, (String)" ").get(0));
                }
            } else {
                this.collecting = MAIN_TARGETS.equals(trimmed) || SUBTARGETS.equals(trimmed);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<String> getTargets() {
            return Collections.unmodifiableList(this.targets);
        }
    }
}

