/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.content.project.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.FileNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class IncludeImpl
extends OffsetableIdentifiableBase<CsmInclude>
implements CsmInclude {
    private final CharSequence name;
    private final boolean system;
    private final boolean recursive;
    private final short includeDirectiveIndex;
    private CsmUID<CsmFile> includeFileUID;

    private IncludeImpl(String name, boolean system, boolean recursive, CsmFile includeFile, CsmFile containingFile, int startOffset, int endOffset, short includeDirectiveIndex) {
        super(containingFile, startOffset, endOffset);
        this.name = FileNameCache.getManager().getString((CharSequence)name);
        this.system = system;
        this.recursive = recursive;
        this.includeDirectiveIndex = includeDirectiveIndex;
        this.includeFileUID = UIDCsmConverter.fileToUID(includeFile);
        assert (this.includeFileUID != null || includeFile == null) : "got " + this.includeFileUID + " for " + includeFile;
    }

    public static IncludeImpl create(String name, boolean system, boolean recursive, CsmFile includeFile, CsmFile containingFile, int startOffset, int endOffset, int includeDirectiveIndex) {
        assert (includeDirectiveIndex <= Short.MAX_VALUE);
        return new IncludeImpl(name, system, recursive, includeFile, containingFile, startOffset, endOffset, (short)includeDirectiveIndex);
    }

    public CsmFile getIncludeFile() {
        return this._getIncludeFile();
    }

    public CsmInclude.IncludeState getIncludeState() {
        if (this.recursive) {
            return CsmInclude.IncludeState.Recursive;
        }
        if (this.getIncludeFile() == null) {
            return CsmInclude.IncludeState.Fail;
        }
        return CsmInclude.IncludeState.Success;
    }

    public CharSequence getIncludeName() {
        return this.name;
    }

    public boolean isSystem() {
        return this.system;
    }

    @Override
    public String toString() {
        char beg = this.isSystem() ? (char)'<' : '\"';
        char end = this.isSystem() ? (char)'>' : '\"';
        String error = "";
        if (this.getContainingFile() == null) {
            error = "<NO CONTAINER INFO> ";
        }
        CsmInclude.IncludeState includeState = this.getIncludeState();
        String state = "";
        if (includeState == CsmInclude.IncludeState.Recursive) {
            state = " <RECURSIVE inclusion>";
        } else if (includeState == CsmInclude.IncludeState.Fail) {
            state = " <FAILED inclusion>";
        }
        return error + beg + this.getIncludeName() + end + state + " [" + this.getStartPosition() + "-" + this.getEndPosition() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        boolean retValue;
        if (obj == null || !(obj instanceof IncludeImpl)) {
            retValue = false;
        } else {
            IncludeImpl other = (IncludeImpl)obj;
            retValue = IncludeImpl.equals(this, other);
        }
        return retValue;
    }

    private static boolean equals(IncludeImpl one, IncludeImpl other) {
        return CharSequences.comparator().compare(one.getIncludeName(), other.getIncludeName()) == 0 && one.system == other.system && one.getStartOffset() == other.getStartOffset();
    }

    @Override
    public int hashCode() {
        int retValue = 17 * (this.isSystem() ? 1 : -1);
        retValue = 31 * retValue + this.getStartOffset();
        retValue = 31 * retValue + this.getIncludeName().hashCode();
        return retValue;
    }

    private CsmFile _getIncludeFile() {
        CsmProject prj;
        CsmFile container;
        CsmFile file = UIDCsmConverter.UIDtoFile(this.includeFileUID);
        if (file == null && this.includeFileUID != null) {
            this.includeFileUID = null;
        }
        if (TraceFlags.NEED_TO_TRACE_UNRESOLVED_INCLUDE && file == null && "yes".equals(System.getProperty("cnd.modelimpl.trace.trace_now")) && (container = this.getContainingFile()) != null && (prj = container.getProject()) instanceof ProjectImpl) {
            System.out.println("File " + container.getAbsolutePath());
            ProjectImpl impl = (ProjectImpl)prj;
            boolean find = false;
            GraphContainer graph = CsmCorePackageAccessor.get().getGraph(impl);
            for (CsmFile top : graph.getTopParentFiles(container).getCompilationUnits()) {
                if (container == top) continue;
                System.out.println("  icluded from " + top.getAbsolutePath());
                find = true;
            }
            if (!find) {
                System.out.println("  there are no files included the file");
            }
        }
        return file;
    }

    @Override
    protected CsmUID<CsmInclude> createUID() {
        return UIDUtilities.createIncludeUID(this);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        output.writeBoolean(this.system);
        output.writeBoolean(this.recursive);
        output.writeShort((int)this.includeDirectiveIndex);
        UIDObjectFactory.getDefaultFactory().writeUID(this.includeFileUID, output);
    }

    public IncludeImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, FileNameCache.getManager());
        assert (this.name != null);
        this.system = input.readBoolean();
        this.recursive = input.readBoolean();
        this.includeDirectiveIndex = input.readShort();
        this.includeFileUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    public int getIncludeDirectiveIndex() {
        return this.includeDirectiveIndex;
    }
}

