/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFunPtrImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionStatementImpl;
import org.netbeans.modules.cnd.modelimpl.util.MapHierarchy;
import org.openide.util.CharSequences;

public class TemplateUtils {
    private static final String UNNAMED_TEMPLATE_PARAMETER = "__nb_unnamed_param_";
    public static final String TYPENAME_STRING = "class";

    public static CharSequence getSpecializationSuffix(AST qIdToken, List<CsmTemplateParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        for (AST child = qIdToken.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            TemplateUtils.addSpecializationSuffix(child, sb, parameters);
            break;
        }
        return sb;
    }

    public static CharSequence getClassSpecializationSuffix(AST qIdToken, List<CsmTemplateParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        TemplateUtils.addSpecializationSuffix(qIdToken.getFirstChild(), sb, parameters);
        return sb;
    }

    public static void addSpecializationSuffix(AST firstChild, StringBuilder res, List<CsmTemplateParameter> parameters) {
        TemplateUtils.addSpecializationSuffix(firstChild, res, parameters, false);
    }

    public static void addSpecializationSuffix(AST firstChild, StringBuilder res, List<CsmTemplateParameter> parameters, boolean checkForSpecialization) {
        int depth = 0;
        int paramsNumber = 0;
        StringBuilder sb = new StringBuilder(res);
        for (AST child = firstChild; child != null; child = child.getNextSibling()) {
            AST grandChild;
            if (child.getType() == 21) {
                ++depth;
            }
            if (510 <= child.getType() && child.getType() <= 602) {
                grandChild = child.getFirstChild();
                if (grandChild == null) continue;
                TemplateUtils.addSpecializationSuffix(grandChild, sb, parameters);
                ++paramsNumber;
                continue;
            }
            if (child.getType() == 116) {
                sb.append(AstUtil.getText(child));
                sb.append('<');
                grandChild = child.getFirstChild();
                if (grandChild != null) {
                    TemplateUtils.addSpecializationSuffix(grandChild, sb, parameters);
                }
                TemplateUtils.addGREATERTHAN(sb);
                sb.append(' ');
                ++paramsNumber;
                continue;
            }
            if (child.getType() == 23) {
                TemplateUtils.addGREATERTHAN(sb);
                if (--depth != 0) continue;
                break;
            }
            CharSequence text = AstUtil.getText(child);
            if (parameters != null) {
                for (CsmTemplateParameter param : parameters) {
                    if (CharSequences.comparator().compare(param.getName(), text) != 0) continue;
                    text = TYPENAME_STRING;
                    ++paramsNumber;
                }
            }
            assert (text != null);
            assert (text.length() > 0);
            if (sb.length() > 0 && Character.isJavaIdentifierPart(sb.charAt(sb.length() - 1)) && Character.isJavaIdentifierPart(text.charAt(0))) {
                sb.append(' ');
            }
            sb.append(text);
        }
        if (!checkForSpecialization || parameters == null || paramsNumber != parameters.size()) {
            res.append(sb.substring(res.length()));
        }
    }

    public static void addGREATERTHAN(StringBuilder sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '>') {
            sb.append(' ');
        }
        sb.append('>');
    }

    public static boolean isPartialClassSpecialization(AST ast) {
        if (ast.getType() == 536) {
            for (AST node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != 563) continue;
                for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getType() != 21) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static AST getTemplateStart(AST ast) {
        for (AST child = ast; child != null; child = child.getNextSibling()) {
            if (child.getType() != 116) continue;
            return child;
        }
        return null;
    }

    public static List<CsmTemplateParameter> getTemplateParameters(AST ast, CsmFile file, CsmScope scope, boolean global) {
        assert (ast != null && ast.getType() == 116);
        ArrayList<CsmTemplateParameter> res = new ArrayList<CsmTemplateParameter>();
        AST parameterStart = null;
        boolean variadic = false;
        int unnamedCount = 0;
        block12: for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 130: 
                case 158: {
                    parameterStart = child;
                    variadic = false;
                    continue block12;
                }
                case 4: {
                    variadic = true;
                    continue block12;
                }
                case 91: {
                    AST fakeAST = null;
                    fakeAST = parameterStart == null ? (parameterStart = child) : AstUtil.createAST(parameterStart, child);
                    res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(child), OffsetableBase.getStartOffset(fakeAST), OffsetableBase.getEndOffset(fakeAST), file, scope, variadic, global));
                    parameterStart = null;
                    continue block12;
                }
                case 525: {
                    parameterStart = child;
                    AST varDecl = child.getFirstChild();
                    if (varDecl != null) {
                        varDecl = AstRenderer.getFirstSiblingSkipQualifiers(varDecl);
                    }
                    if (varDecl != null && varDecl.getType() == 130) {
                        varDecl = varDecl.getNextSibling();
                    }
                    if (varDecl != null && (varDecl.getType() == 118 || varDecl.getType() == 159 || varDecl.getType() == 158 || varDecl.getType() == 160) && ((varDecl = varDecl.getNextSibling()) == null || varDecl.getType() != 528 && varDecl.getType() != 563)) continue block12;
                    while (varDecl != null && varDecl.getNextSibling() != null && varDecl.getNextSibling().getType() == 595) {
                        varDecl = varDecl.getNextSibling();
                    }
                    if (varDecl != null && varDecl.getNextSibling() != null && varDecl.getNextSibling().getType() == 597) {
                        varDecl = varDecl.getNextSibling();
                    }
                    if (varDecl != null) {
                        switch (varDecl.getType()) {
                            case 597: {
                                AST pn = varDecl.getFirstChild();
                                if (pn != null && pn.getType() == 4) {
                                    pn = pn.getNextSibling();
                                }
                                if (pn == null) break;
                                res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(pn), file, scope, variadic, global));
                                break;
                            }
                            case 526: 
                            case 528: {
                                boolean added = false;
                                for (AST p = varDecl.getFirstChild(); p != null; p = p.getNextSibling()) {
                                    if (p.getType() != 91) continue;
                                    res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(p), file, scope, variadic, global));
                                    added = true;
                                    break;
                                }
                                if (added) break;
                                res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, UNNAMED_TEMPLATE_PARAMETER + unnamedCount, file, scope, variadic, global));
                                ++unnamedCount;
                                break;
                            }
                        }
                    }
                    parameterStart = null;
                    continue block12;
                }
                case 538: {
                    parameterStart = child;
                    for (AST paramChild = child.getFirstChild(); paramChild != null; paramChild = paramChild.getNextSibling()) {
                        if (paramChild.getType() != 91) continue;
                        res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(paramChild), file, scope, variadic, global));
                    }
                    parameterStart = null;
                    continue block12;
                }
                case 6: 
                case 8: {
                    if (parameterStart != null) {
                        res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, UNNAMED_TEMPLATE_PARAMETER + unnamedCount, file, scope, variadic, global));
                        ++unnamedCount;
                    }
                    parameterStart = null;
                }
            }
        }
        if (parameterStart != null) {
            res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, UNNAMED_TEMPLATE_PARAMETER + unnamedCount, file, scope, variadic, global));
            ++unnamedCount;
        }
        return res;
    }

    public static List<CsmSpecializationParameter> getSpecializationParameters(AST ast, CsmFile file, CsmScope scope, boolean global) {
        AST start;
        assert (ast != null);
        ArrayList<CsmSpecializationParameter> res = new ArrayList<CsmSpecializationParameter>();
        for (start = ast.getFirstChild(); start != null; start = start.getNextSibling()) {
            if (start.getType() != 21) continue;
            start = start.getNextSibling();
            break;
        }
        if (start != null) {
            AST ptr = null;
            AST type = null;
            block7: for (AST child = start; child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 595: {
                        ptr = child;
                        continue block7;
                    }
                    case 526: 
                    case 528: {
                        type = child;
                        continue block7;
                    }
                    case 588: {
                        res.add((CsmSpecializationParameter)ExpressionBasedSpecializationParameterImpl.create(ExpressionStatementImpl.create(child, file, scope), file, OffsetableBase.getStartOffset(child), OffsetableBase.getEndOffset(child)));
                        continue block7;
                    }
                    case 8: 
                    case 23: {
                        if (type != null) {
                            res.add((CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(TemplateUtils.checkTemplateType((CsmType)TypeFactory.createType(type, file, ptr, 0, null, scope, true, false), (CsmObject)scope), scope, file, OffsetableBase.getStartOffset(type), OffsetableBase.getEndOffset(type)));
                        }
                        type = null;
                        ptr = null;
                    }
                }
            }
        }
        return res;
    }

    public static CsmType checkTemplateType(CsmType type, CsmObject scope) {
        return TemplateUtils.checkTemplateType(type, scope, null);
    }

    public static CsmType checkTemplateType(CsmType type, CsmObject scope, List<CsmTemplateParameter> additionalParams) {
        CsmType paramType;
        TypeFunPtrImpl fpt;
        CsmType returnType;
        CsmType newReturnType;
        if (!(type instanceof TypeImpl)) {
            return type;
        }
        if (type instanceof NestedType) {
            NestedType nestedType = (NestedType)type;
            type = NestedType.create(TemplateUtils.checkTemplateType(nestedType.getParent(), scope, additionalParams), nestedType);
        }
        if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (newReturnType = TemplateUtils.checkTemplateType(returnType = (fpt = (TypeFunPtrImpl)type).getReturnType(), scope, additionalParams)) != returnType) {
            fpt.setReturnType(newReturnType);
        }
        if (type.isInstantiation()) {
            TypeImpl typeImpl = (TypeImpl)type;
            List<CsmSpecializationParameter> params = typeImpl.getInstantiationParams();
            for (int i = 0; i < params.size(); ++i) {
                CsmType newType;
                CsmSpecializationParameter instParam = params.get(i);
                if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) || (newType = TemplateUtils.checkTemplateType(((CsmTypeBasedSpecializationParameter)instParam).getType(), scope, additionalParams)) == instParam) continue;
                if (CsmKindUtilities.isScope((CsmObject)scope)) {
                    params.set(i, (CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(newType, (CsmScope)scope));
                    continue;
                }
                if (CsmKindUtilities.isScopeElement((CsmObject)scope)) {
                    params.set(i, (CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(newType, ((CsmScopeElement)scope).getScope()));
                    continue;
                }
                params.set(i, (CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(newType, null));
            }
        }
        if (additionalParams != null && (paramType = TemplateUtils.checkTemplateType(type, additionalParams)) != type) {
            return paramType;
        }
        while (scope != null) {
            if (CsmKindUtilities.isTemplate((CsmObject)scope) && (paramType = TemplateUtils.checkTemplateType(type, ((CsmTemplate)scope).getTemplateParameters())) != type) {
                return paramType;
            }
            if (!(scope instanceof CsmScopeElement)) break;
            scope = ((CsmScopeElement)scope).getScope();
        }
        return type;
    }

    public static MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> gatherMapping(CsmInstantiation inst) {
        MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapHierarchy = new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(inst.getMapping());
        while (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
            inst = (CsmInstantiation)inst.getTemplateDeclaration();
            mapHierarchy.push(inst.getMapping());
        }
        return mapHierarchy;
    }

    public static MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> gatherMapping(List<CsmInstantiation> instantiations) {
        MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapHierarchy = new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>();
        for (CsmInstantiation instantiation : instantiations) {
            mapHierarchy.push(instantiation.getMapping());
        }
        return mapHierarchy;
    }

    public static boolean isTemplateQualifiedName(String name) {
        return name.contains("<");
    }

    public static String getTemplateQualifiedNameWithoutSiffix(String name) {
        return name.replaceAll("<.*", "");
    }

    private static CsmType checkTemplateType(CsmType type, List<CsmTemplateParameter> params) {
        if (params != null && !params.isEmpty()) {
            CharSequence classifierText = ((TypeImpl)type).getClassifierText();
            for (CsmTemplateParameter param : params) {
                if (CharSequences.comparator().compare(param.getName(), classifierText) != 0) continue;
                return new TemplateParameterTypeImpl(type, param);
            }
        }
        return type;
    }

    private TemplateUtils() {
    }
}

