/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class TypedefImpl
extends OffsetableDeclarationBase<CsmTypedef>
implements CsmTypedef,
CsmTemplate,
Disposable,
CsmScopeElement {
    private final CharSequence name;
    private final CsmType type;
    private boolean typeUnnamed = false;
    private CsmObject containerRef;
    private CsmUID<CsmIdentifiable> containerUID;
    private TemplateDescriptor templateDescriptor = null;
    private static final byte UNNAMED_TYPE_FLAG = 1;
    private static final byte UNNAMED_TYPEDEF_FLAG = 2;

    protected TypedefImpl(AST ast, CsmFile file, CsmObject container, CsmType type, CharSequence aName) {
        super(file, TypedefImpl.getStartOffset(ast), TypedefImpl.getEndOffset(ast));
        if (UIDCsmConverter.isIdentifiable(container)) {
            this.containerUID = UIDCsmConverter.identifiableToUID((CsmIdentifiable)container);
            assert (this.containerUID != null || container == null);
            this.containerRef = null;
        } else {
            this.containerRef = container;
        }
        this.type = type == null ? this.createType(ast) : type;
        if (aName.length() == 0) {
            aName = this.fixBuiltInTypedef(ast);
        }
        this.name = QualifiedNameCache.getManager().getString(aName);
    }

    protected TypedefImpl(CsmType type, CharSequence name, CsmObject container, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        if (UIDCsmConverter.isIdentifiable(container)) {
            this.containerUID = UIDCsmConverter.identifiableToUID((CsmIdentifiable)container);
            assert (this.containerUID != null || container == null);
            this.containerRef = null;
        } else {
            this.containerRef = container;
        }
        this.type = type;
        this.name = name;
    }

    public static TypedefImpl create(AST ast, CsmFile file, CsmObject container, CsmType type, CharSequence aName, boolean global) {
        TypedefImpl typedefImpl = new TypedefImpl(ast, file, container, type, aName);
        if (!global) {
            Utils.setSelfUID(typedefImpl);
        }
        return typedefImpl;
    }

    private CharSequence fixBuiltInTypedef(AST ast) {
        AST first = ast.getFirstChild();
        if (first != null) {
            AST last = null;
            while (first != null && first.getType() != 8 && first.getType() != 10) {
                last = first;
                first = first.getNextSibling();
            }
            if (last != null) {
                CharSequence text;
                for (first = last.getFirstChild(); first != null; first = first.getNextSibling()) {
                    text = AstUtil.getText(first);
                    if (text == null || text.length() <= 0 || !Character.isJavaIdentifierStart(text.charAt(0))) continue;
                    last = first;
                }
                text = AstUtil.getText(last);
                if (text != null && text.length() > 0 && Character.isJavaIdentifierStart(text.charAt(0))) {
                    return text;
                }
            }
        }
        return "";
    }

    public boolean isTypeUnnamed() {
        return this.typeUnnamed;
    }

    public void setTypeUnnamed() {
        this.typeUnnamed = true;
    }

    public CsmScope getScope() {
        CsmObject container = this._getContainer();
        if (CsmKindUtilities.isScope((CsmObject)container)) {
            return (CsmScope)container;
        }
        return this.getContainingFile();
    }

    @Override
    public void dispose() {
        CsmScope scope;
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if ((scope = this.getScope()) instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)scope).removeDeclaration(this);
        }
        FileImpl file = (FileImpl)this.getContainingFile();
        file.getProjectImpl(true).unregisterDeclaration(this);
    }

    private synchronized void onDispose() {
        if (this.containerRef == null) {
            this.containerRef = UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (this.containerRef != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
    }

    public CharSequence getQualifiedName() {
        CharSequence nsName;
        CsmObject container = this._getContainer();
        if (CsmKindUtilities.isClass((CsmObject)container)) {
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)((CsmClass)container).getQualifiedName(), (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix()));
        }
        if (CsmKindUtilities.isNamespace((Object)container) && (nsName = ((CsmNamespace)container).getQualifiedName()) != null && nsName.length() > 0) {
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)nsName, (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.TYPEDEF;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)this.getName(), (CharSequence)this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public void setTemplateDescriptor(TemplateDescriptor templateDescriptor) {
        this.templateDescriptor = templateDescriptor;
    }

    private CsmType createType(AST node) {
        AST ptrOperator = null;
        int arrayDepth = 0;
        AST classifier = null;
        for (AST token = node.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 526: 
                case 528: {
                    classifier = token;
                    break;
                }
                case 159: {
                    AST next = token.getNextSibling();
                    if (next == null || next.getType() != 563) break;
                    classifier = next;
                }
            }
            if (classifier != null) break;
        }
        if (classifier != null) {
            return TypeFactory.createType(classifier, this.getContainingFile(), ptrOperator, arrayDepth);
        }
        return null;
    }

    public CsmType getType() {
        return this.type;
    }

    private synchronized CsmObject _getContainer() {
        CsmObject container = this.containerRef;
        if (container == null) {
            container = UIDCsmConverter.UIDtoIdentifiable(this.containerUID);
            assert (container != null || this.containerUID == null) : "null object for UID " + this.containerUID;
        }
        return container;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        boolean unnamed;
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        byte unnamedState = 0;
        if (this.typeUnnamed) {
            unnamedState = (byte)(unnamedState | 1);
        }
        boolean bl = unnamed = this.getName().length() == 0;
        if (unnamed) {
            unnamedState = (byte)(unnamedState | 2);
        }
        output.writeByte((int)unnamedState);
        if (unnamed) {
            super.writeUID(output);
        }
        assert (this.type != null);
        PersistentUtils.writeType(this.type, output);
        if (this.containerUID == null) {
            System.err.println("trying to write non-writable typedef:" + this.getContainingFile() + this.toString());
            if (this.containerRef == null) {
                System.err.println("typedef doesn't have container at all");
            }
        } else {
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, output);
        }
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
    }

    public TypedefImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        byte unnamedState = input.readByte();
        this.typeUnnamed = false;
        if ((unnamedState & 1) == 1) {
            this.typeUnnamed = true;
        }
        boolean unnamed = false;
        if ((unnamedState & 2) == 2) {
            unnamed = true;
        }
        if (unnamed) {
            super.readUID(input);
        }
        this.type = PersistentUtils.readType(input);
        assert (this.type != null);
        this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        if (this.containerUID == null) {
            System.err.println("non-writable object was read:" + this.getContainingFile() + this.toString());
        }
        this.containerRef = null;
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
    }

    public static class TypedefBuilder
    extends OffsetableDeclarationBase.SimpleDeclarationBuilder
    implements CsmObjectBuilder {
        public TypedefBuilder() {
        }

        public TypedefBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
            super(builder);
        }

        public TypedefImpl create() {
            CsmType type = null;
            if (this.getTypeBuilder() != null) {
                this.getTypeBuilder().setScope(this.getScope());
                if (this.getTypeBuilder() != null && this.getDeclaratorBuilder() != null && this.getParametersListBuilder() != null) {
                    CsmType returnType = this.getTypeBuilder().create();
                    FunctionParameterListImpl.FunctionParameterListBuilder parametersBuilder = (FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder();
                    FunctionParameterListImpl parametersList = parametersBuilder.create();
                    List<CsmParameter> parameters = parametersList.getParameters();
                    if (parameters == null) {
                        parameters = Collections.emptyList();
                    }
                    type = TypeFactory.createFunPtrType(this.getFile(), returnType.getPointerDepth() - 1, TypeFactory.getReferenceValue(returnType), returnType.getArrayDepth(), returnType.isConst(), returnType.getStartOffset(), parametersList.getEndOffset(), parameters, returnType);
                    boolean c = true;
                } else {
                    type = this.getTypeBuilder().create();
                }
            }
            if (type == null) {
                type = TypeFactory.createSimpleType((CsmClassifier)BuiltinTypes.getBuiltIn("int"), this.getFile(), this.getStartOffset(), this.getStartOffset());
            }
            TypedefImpl td = new TypedefImpl(type, this.getName(), (CsmObject)this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            if (!this.isGlobal()) {
                Utils.setSelfUID(td);
            } else {
                ((FileImpl)this.getFile()).getProjectImpl(true).registerDeclaration(td);
            }
            this.addDeclaration(td);
            return td;
        }
    }
}

