/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmStandaloneFileProviderImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.RequestProcessor;

public class FakeRegistrationWorker {
    private final RequestProcessor FAKE_REGISTRATION_WORKER;
    private final ProjectBase project;
    private final AtomicBoolean disposing;

    FakeRegistrationWorker(ProjectBase project, AtomicBoolean disposing) {
        this.project = project;
        this.disposing = disposing;
        this.FAKE_REGISTRATION_WORKER = new RequestProcessor("Fake Registration Worker " + project.getDisplayName(), CndUtils.getNumberCndWorkerThreads());
    }

    void fixFakeRegistration(boolean libsAlreadyParsed) {
        long time = System.currentTimeMillis();
        Collection<CsmUID<CsmFile>> files = this.project.getAllFilesUID();
        int size = files.size();
        int threads = CndUtils.getNumberCndWorkerThreads() * 3;
        CountDownLatch countDownLatch = new CountDownLatch(threads);
        int chunk = size / threads + 1;
        Iterator<CsmUID<CsmFile>> it = files.iterator();
        for (int i = 0; i < threads; ++i) {
            ArrayList<CsmUID<CsmFile>> list = new ArrayList<CsmUID<CsmFile>>(chunk);
            for (int j = 0; j < chunk && it.hasNext(); ++j) {
                list.add(it.next());
            }
            FixRegistrationRunnable r = new FixRegistrationRunnable(countDownLatch, list, libsAlreadyParsed, this.disposing);
            if (this.project.getPlatformProject() instanceof CsmStandaloneFileProviderImpl.NativeProjectImpl) {
                r.run();
                continue;
            }
            this.FAKE_REGISTRATION_WORKER.post((Runnable)r);
        }
        try {
            countDownLatch.await();
            time = System.currentTimeMillis() - time;
            if (libsAlreadyParsed) {
                this.project.cleanAllFakeFunctionAST();
            }
            if (TraceFlags.TIMING) {
                Logger.getLogger(FakeRegistrationWorker.class.getSimpleName()).log(Level.INFO, "FAKE REGISTRATION {0} took {1}ms\n", new Object[]{this.project.getName(), time});
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private static class FixRegistrationRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<CsmUID<CsmFile>> files;
        private final boolean libsAlreadyParsed;
        private final AtomicBoolean cancelled;

        private FixRegistrationRunnable(CountDownLatch countDownLatch, List<CsmUID<CsmFile>> files, boolean libsAlreadyParsed, AtomicBoolean cancelled) {
            this.countDownLatch = countDownLatch;
            this.files = files;
            this.libsAlreadyParsed = libsAlreadyParsed;
            this.cancelled = cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (CsmUID<CsmFile> file : this.files) {
                    if (this.cancelled.get()) {
                        return;
                    }
                    if (file == null) {
                        return;
                    }
                    FileImpl impl = (FileImpl)UIDCsmConverter.UIDtoFile(file);
                    CndUtils.assertTrueInConsole((impl != null ? 1 : 0) != 0, (String)"no deref file for ", file);
                    if (impl == null) {
                        return;
                    }
                    String oldName = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("Fix registration " + file);
                        impl.onProjectParseFinished(this.libsAlreadyParsed);
                    }
                    finally {
                        Thread.currentThread().setName(oldName);
                    }
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

