/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.utils.CndUtils;

class NativeProjectListenerImpl
implements NativeProjectItemsListener {
    private static final boolean TRACE;
    private static final Logger LOG;
    private final NativeProject nativeProject;
    private final ProjectBase projectBase;
    private volatile boolean enabledEventsHandling = true;

    public NativeProjectListenerImpl(ModelImpl model, NativeProject nativeProject, ProjectBase project) {
        this.nativeProject = nativeProject;
        this.projectBase = project;
        if (TraceFlags.MERGE_EVENTS) {
            CndUtils.assertTrue((boolean)false, (String)"NativeProjectListenerImpl shoudl not be used if MERGE_EVENTS flag is set");
        }
    }

    public void filesAdded(List<NativeFileItem> fileItems) {
        if (TRACE) {
            String title = "Native event filesAdded:" + fileItems.size();
            LOG.log(Level.INFO, title + "\n" + DeepReparsingUtils.toString(fileItems), new Exception(title));
        }
        if (this.enabledEventsHandling) {
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : fileItems) {
                if (item.isExcluded()) continue;
                list.add(item);
            }
            this.itemsAddedImpl(list);
        } else if (TraceFlags.TIMING) {
            LOG.log(Level.INFO, "skipped filesAdded(list) {0}...", this.nativeProject.getProjectDisplayName());
        }
    }

    public void filesRemoved(List<NativeFileItem> fileItems) {
        if (TRACE) {
            String title = "Native event filesRemoved:" + fileItems.size();
            LOG.log(Level.INFO, title + "\n" + DeepReparsingUtils.toString(fileItems), new Exception(title));
        }
        if (this.enabledEventsHandling) {
            this.itemsRemovedImpl(fileItems);
        } else if (TraceFlags.TIMING) {
            LOG.log(Level.INFO, "skipped filesRemoved(list) {0}...", this.nativeProject.getProjectDisplayName());
        }
    }

    public void fileRenamed(String oldPath, NativeFileItem newFileIetm) {
        if (TRACE) {
            LOG.log(Level.INFO, "Native event fileRenamed:\tOld Name:" + oldPath + "\tNew Name:" + newFileIetm.getAbsolutePath(), new Exception("fileRenamed"));
        }
        if (!this.enabledEventsHandling) {
            LOG.log(Level.INFO, "UNEXPECTED fileRenamed {0}...", this.nativeProject.getProjectDisplayName());
        }
        this.itemRenamedImpl(oldPath, newFileIetm);
    }

    final void enableListening(boolean enable) {
        if (TraceFlags.TIMING) {
            LOG.log(Level.INFO, "\n%{0} ProjectListeners {1}...", new Object[]{enable ? "enable" : "disable", this.nativeProject.getProjectDisplayName()});
        }
        this.enabledEventsHandling = enable;
    }

    public void filesPropertiesChanged(List<NativeFileItem> fileItems) {
        if (TRACE) {
            String title = "Native event filesPropertiesChanged:" + fileItems.size();
            LOG.log(Level.INFO, title + "\n" + DeepReparsingUtils.toString(fileItems), new Exception(title));
        }
        if (this.enabledEventsHandling) {
            this.itemsPropertiesChangedImpl(fileItems, false);
        } else if (TraceFlags.TIMING) {
            LOG.log(Level.INFO, "skipped filesPropertiesChanged(list) {0}...", this.nativeProject.getProjectDisplayName());
        }
    }

    public void filesPropertiesChanged() {
        List allFiles = this.nativeProject.getAllFiles();
        if (TRACE) {
            String title = "Native event projectPropertiesChanged:" + allFiles.size();
            LOG.log(Level.INFO, title, new Exception(title));
        }
        if (this.enabledEventsHandling) {
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : allFiles) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        list.add(item);
                        break;
                    }
                }
            }
            this.itemsPropertiesChangedImpl(list, true);
        } else if (TraceFlags.TIMING) {
            LOG.log(Level.INFO, "skipped filesPropertiesChanged {0}...", this.nativeProject.getProjectDisplayName());
        }
    }

    public void projectDeleted(NativeProject nativeProject) {
        if (TRACE) {
            LOG.log(Level.INFO, "projectDeleted {0}", nativeProject);
        }
        RepositoryUtils.onProjectDeleted(nativeProject);
    }

    private void itemsAddedImpl(final List<NativeFileItem> items) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeProjectListenerImpl.this.projectBase.onFileItemsAdded(items);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying add items");
        }
    }

    private void itemsRemovedImpl(final List<NativeFileItem> items) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeProjectListenerImpl.this.projectBase.onFileItemsRemoved(items);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying remove items");
        }
    }

    private void itemRenamedImpl(final String oldPath, final NativeFileItem newFileIetm) {
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            @Override
            public void run() {
                try {
                    NativeProjectListenerImpl.this.projectBase.onFileItemRenamed(oldPath, newFileIetm);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }, "Applying rename item");
    }

    private void itemsPropertiesChangedImpl(final List<NativeFileItem> items, final boolean invalidateLibraries) {
        if (!items.isEmpty()) {
            ModelImpl.instance().enqueueModelTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeProjectListenerImpl.this.projectBase.onFileItemsPropertyChanged(items, invalidateLibraries);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }, "Applying property changes");
        }
    }

    public void fileOperationsStarted(NativeProject nativeProject) {
        if (TRACE) {
            String title = "fileOperationsStarted:" + nativeProject.getProjectDisplayName();
            LOG.log(Level.INFO, title, new Exception(title));
        }
        ModelSupport.instance().suspendDeleteEvents();
    }

    public void fileOperationsFinished(NativeProject nativeProject) {
        if (TRACE) {
            String title = "fileOperationsFinished:" + nativeProject.getProjectDisplayName();
            LOG.log(Level.INFO, title, new Exception(title));
        }
        ModelSupport.instance().resumeDeleteEvents();
    }

    static {
        LOG = Logger.getLogger("NativeProjectListenerImpl");
        TRACE = LOG.isLoggable(Level.FINE);
    }
}

