/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public abstract class OffsetableDeclarationBase<T>
extends OffsetableIdentifiableBase<T>
implements CsmOffsetableDeclaration {
    public static final char UNIQUE_NAME_SEPARATOR = ':';

    protected OffsetableDeclarationBase(CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
    }

    public CharSequence getUniqueName() {
        return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(this.getKind()), (char)':', (CharSequence)this.getUniqueNameWithoutPrefix()));
    }

    public CharSequence getUniqueNameWithoutPrefix() {
        return this.getQualifiedName();
    }

    protected final CsmProject getProject() {
        CsmFile file = this.getContainingFile();
        if (file == null) {
            CndUtils.assertUnconditional((String)"Null containing file");
            return null;
        }
        return file.getProject();
    }

    public CharSequence getQualifiedNamePostfix() {
        if (TraceFlags.SET_UNNAMED_QUALIFIED_NAME && this.getName().length() == 0) {
            return this.getOffsetBasedName();
        }
        return this.getName();
    }

    protected CharSequence toStringName() {
        CharSequence name = CsmKindUtilities.isTemplate((CsmObject)this) ? ((CsmTemplate)this).getDisplayName() : this.getName();
        if (this instanceof RawNamable) {
            StringBuilder out = new StringBuilder(name);
            out.append('(');
            boolean first = true;
            for (CharSequence part : ((RawNamable)((Object)this)).getRawName()) {
                if (first) {
                    first = false;
                } else {
                    out.append("::");
                }
                out.append(part);
            }
            out.append(')');
            name = out;
        }
        return name;
    }

    private String getOffsetBasedName() {
        return "[" + this.getContainingFile().getName() + ":" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    @Override
    protected CsmUID<? extends CsmOffsetableDeclaration> createUID() {
        return UIDUtilities.createDeclarationUID(this);
    }

    protected static TemplateDescriptor createTemplateDescriptor(AST node, CsmFile file, CsmScope scope, StringBuilder classTemplateSuffix, boolean global) {
        boolean _template = false;
        boolean specialization = false;
        switch (node.getType()) {
            case 517: 
            case 523: 
            case 524: 
            case 543: 
            case 545: 
            case 547: 
            case 549: {
                _template = true;
                break;
            }
            case 529: 
            case 532: 
            case 533: 
            case 534: 
            case 535: {
                _template = true;
                specialization = true;
            }
        }
        if (_template) {
            AST startTemplateSign;
            List<CsmTemplateParameter> templateParams = null;
            AST templateNode = node.getFirstChild();
            if (templateNode == null || templateNode.getType() != 116) {
                return null;
            }
            ArrayList<AST> templateClassNodes = new ArrayList<AST>();
            AST qIdToken = AstUtil.findChildOfType(node, 563);
            AST aST = startTemplateSign = qIdToken != null ? AstUtil.findChildOfType(qIdToken, 21) : null;
            while (templateNode != null && startTemplateSign != null) {
                AST scopeSign;
                AST endTemplateSign = null;
                for (AST sibling = startTemplateSign.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                    if (sibling.getType() != 23) continue;
                    endTemplateSign = sibling;
                    break;
                }
                if (endTemplateSign == null || (scopeSign = endTemplateSign.getNextSibling()) == null || scopeSign.getType() != 52) break;
                _template = false;
                if (specialization && classTemplateSuffix != null) {
                    classTemplateSuffix.append(TemplateUtils.getSpecializationSuffix(qIdToken, null));
                }
                templateClassNodes.add(templateNode);
                templateNode = AstUtil.findSiblingOfType(templateNode.getNextSibling(), 116);
                startTemplateSign = AstUtil.findSiblingOfType(endTemplateSign, 21);
            }
            if (!_template && templateNode != null && templateNode.getType() == 116) {
                _template = true;
            }
            int inheritedTemplateParametersNumber = 0;
            if (!templateClassNodes.isEmpty()) {
                for (AST templateClassNode : templateClassNodes) {
                    if (templateParams == null) {
                        templateParams = TemplateUtils.getTemplateParameters(templateClassNode, file, scope, global);
                    } else {
                        templateParams.addAll(TemplateUtils.getTemplateParameters(templateClassNode, file, scope, global));
                    }
                    inheritedTemplateParametersNumber = templateParams.size();
                }
            }
            if (_template) {
                CharSequence templateSuffix;
                if (specialization) {
                    templateSuffix = qIdToken == null ? "<>" : TemplateUtils.getSpecializationSuffix(qIdToken, null);
                } else {
                    StringBuilder sb = new StringBuilder();
                    TemplateUtils.addSpecializationSuffix(templateNode.getFirstChild(), sb, null);
                    templateSuffix = CharSequenceUtils.concatenate((CharSequence)"<", (CharSequence)sb, (CharSequence)">");
                }
                if (templateParams != null) {
                    templateParams.addAll(TemplateUtils.getTemplateParameters(templateNode, file, scope, global));
                } else {
                    templateParams = TemplateUtils.getTemplateParameters(templateNode, file, scope, global);
                }
                return new TemplateDescriptor(templateParams, templateSuffix, inheritedTemplateParametersNumber, specialization, global);
            }
            return new TemplateDescriptor(templateParams, "", inheritedTemplateParametersNumber, specialization, global);
        }
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    protected OffsetableDeclarationBase(RepositoryDataInput input) throws IOException {
        super(input);
    }

    @Override
    public String toString() {
        CharSequence name = this.toStringName();
        return "" + this.getKind() + ' ' + name + this.getOffsetString() + this.getPositionString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OffsetableDeclarationBase other = (OffsetableDeclarationBase)obj;
        if (!this.getKind().equals((Object)other.getKind())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.getName().hashCode();
    }

    protected boolean registerInProject() {
        return false;
    }

    protected static <T> void postObjectCreateRegistration(boolean register, OffsetableDeclarationBase<T> obj) {
        obj.getUniqueName();
        if (register) {
            if (!obj.registerInProject()) {
                RepositoryUtils.put(obj);
            }
        } else {
            Utils.setSelfUID(obj);
        }
    }

    protected static <T> void temporaryRepositoryRegistration(boolean global, OffsetableDeclarationBase<T> obj) {
        if (global) {
            RepositoryUtils.hang(obj);
        } else {
            Utils.setSelfUID(obj);
        }
    }

    public static class DeclaratorBuilder
    implements CsmObjectBuilder {
        private int level = 0;
        private CharSequence name;
        private OffsetableIdentifiableBase.NameBuilder nameBuilder;

        public void setName(CharSequence name) {
            assert (CharSequences.isCompact((CharSequence)name)) : "only compact strings allowed";
            this.name = name;
        }

        public CharSequence getName() {
            return this.name;
        }

        public void enterDeclarator() {
            ++this.level;
        }

        public void leaveDeclarator() {
            --this.level;
        }

        public boolean isTopDeclarator() {
            return this.level == 0;
        }

        public OffsetableIdentifiableBase.NameBuilder getNameBuilder() {
            return this.nameBuilder;
        }

        public void setNameBuilder(OffsetableIdentifiableBase.NameBuilder nameBuilder) {
            this.nameBuilder = nameBuilder;
        }

        public String toString() {
            return "DeclaratorBuilder{level=" + this.level + ", name=" + this.name + ", nameBuilder=" + this.nameBuilder + '}';
        }
    }

    public static class SimpleDeclarationBuilder
    extends ScopedDeclarationBuilder {
        private boolean typedefSpecifier = false;
        private boolean friendSpecifier = false;
        private boolean typeSpecifier = false;
        private boolean inDeclSpecifiers = false;
        private DeclaratorBuilder declaratorBuilder;
        private TypeFactory.TypeBuilder typeBuilder;
        private CsmObjectBuilder parametersListBuilder;
        private TemplateDescriptor.TemplateDescriptorBuilder templateDescriptorBuilder;
        private ExpressionBase.ExpressionBuilder initializerBuilder;
        private boolean _static = false;
        private boolean _extern = false;
        private boolean _const = false;
        private boolean constructor = false;
        private boolean destructor = false;

        public SimpleDeclarationBuilder() {
        }

        protected SimpleDeclarationBuilder(SimpleDeclarationBuilder builder) {
            super(builder);
            this.typedefSpecifier = builder.typedefSpecifier;
            this.friendSpecifier = builder.friendSpecifier;
            this.typeSpecifier = builder.typeSpecifier;
            this.inDeclSpecifiers = builder.inDeclSpecifiers;
            this.declaratorBuilder = builder.declaratorBuilder;
            this.typeBuilder = builder.typeBuilder;
            this.parametersListBuilder = builder.parametersListBuilder;
            this.templateDescriptorBuilder = builder.templateDescriptorBuilder;
            this.initializerBuilder = builder.initializerBuilder;
            this._static = builder._static;
            this._extern = builder._extern;
            this._const = builder._const;
            this.constructor = builder.constructor;
            this.destructor = builder.destructor;
        }

        public void setInitializerBuilder(ExpressionBase.ExpressionBuilder initializerBuilder) {
            this.initializerBuilder = initializerBuilder;
        }

        public ExpressionBase.ExpressionBuilder getInitializerBuilder() {
            return this.initializerBuilder;
        }

        public void setConstructor() {
            this.constructor = true;
        }

        public void setDestructor() {
            this.destructor = true;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public boolean isDestructor() {
            return this.destructor;
        }

        public void setFriend() {
            this.friendSpecifier = true;
        }

        public boolean isFriend() {
            return this.friendSpecifier;
        }

        public void setStatic() {
            this._static = true;
        }

        public void setExtern() {
            this._extern = true;
        }

        public void setConst() {
            this._const = true;
        }

        public boolean isStatic() {
            return this._static;
        }

        public boolean isExtern() {
            return this._extern;
        }

        public boolean isConst() {
            return this._const;
        }

        public void setTypedefSpecifier() {
            this.typedefSpecifier = true;
            if (this.typeBuilder != null) {
                this.typeBuilder.setTypedef();
            }
        }

        public boolean hasTypedefSpecifier() {
            return this.typedefSpecifier;
        }

        public void setTypeSpecifier() {
            this.typeSpecifier = true;
        }

        public boolean hasTypeSpecifier() {
            return this.typeSpecifier && this.inDeclSpecifiers;
        }

        public void declSpecifiers() {
            this.inDeclSpecifiers = true;
        }

        public void endDeclSpecifiers() {
            this.inDeclSpecifiers = false;
        }

        public boolean isInDeclSpecifiers() {
            return this.inDeclSpecifiers;
        }

        public void setDeclaratorBuilder(DeclaratorBuilder declaratorBuilder) {
            this.declaratorBuilder = declaratorBuilder;
        }

        public void setTemplateDescriptorBuilder(TemplateDescriptor.TemplateDescriptorBuilder templateDescriptorBuilder) {
            this.templateDescriptorBuilder = templateDescriptorBuilder;
            if (templateDescriptorBuilder != null) {
                this.setStartOffset(templateDescriptorBuilder.getStartOffset());
            }
        }

        public TemplateDescriptor.TemplateDescriptorBuilder getTemplateDescriptorBuilder() {
            return this.templateDescriptorBuilder;
        }

        public TemplateDescriptor getTemplateDescriptor() {
            TemplateDescriptor td = null;
            if (this.getTemplateDescriptorBuilder() != null) {
                this.getTemplateDescriptorBuilder().setScope(this.getScope());
                td = this.getTemplateDescriptorBuilder().create();
            }
            return td;
        }

        public void setTypeBuilder(TypeFactory.TypeBuilder typeBuilder) {
            this.typeBuilder = typeBuilder;
        }

        public TypeFactory.TypeBuilder getTypeBuilder() {
            return this.typeBuilder;
        }

        public DeclaratorBuilder getDeclaratorBuilder() {
            return this.declaratorBuilder;
        }

        public void setParametersListBuilder(CsmObjectBuilder parametersListBuilder) {
            this.parametersListBuilder = parametersListBuilder;
        }

        public CsmObjectBuilder getParametersListBuilder() {
            return this.parametersListBuilder;
        }

        public boolean isFunction() {
            return this.parametersListBuilder != null;
        }

        protected CsmType getType() {
            CsmType type = null;
            if (this.getTypeBuilder() != null) {
                this.getTypeBuilder().setScope(this.getScope());
                type = this.getTypeBuilder().create();
            }
            if (type == null) {
                type = TypeFactory.createSimpleType((CsmClassifier)BuiltinTypes.getBuiltIn("int"), this.getFile(), this.getStartOffset(), this.getStartOffset());
            }
            return type;
        }

        public CsmDeclaration create() {
            throw new UnsupportedOperationException("Should not be used.");
        }

        @Override
        public String toString() {
            return "SimpleDeclarationBuilder{typedefSpecifier=" + this.typedefSpecifier + ", friendSpecifier=" + this.friendSpecifier + ", typeSpecifier=" + this.typeSpecifier + ", inDeclSpecifiers=" + this.inDeclSpecifiers + ", declaratorBuilder=" + this.declaratorBuilder + ", typeBuilder=" + this.typeBuilder + ", parametersListBuilder=" + this.parametersListBuilder + ", templateDescriptorBuilder=" + this.templateDescriptorBuilder + ", initializerBuilder=" + this.initializerBuilder + ", _static=" + this._static + ", _extern=" + this._extern + ", _const=" + this._const + ", constructor=" + this.constructor + ", destructor=" + this.destructor + super.toString() + '}';
        }
    }

    public static abstract class ScopedDeclarationBuilder
    extends OffsetableIdentifiableBase.OffsetableIdentifiableBuilder {
        private boolean global = true;
        private CsmObjectBuilder parent;
        private CsmScope scope;

        public ScopedDeclarationBuilder() {
        }

        protected ScopedDeclarationBuilder(ScopedDeclarationBuilder builder) {
            super(builder);
            this.global = builder.global;
            this.parent = builder.parent;
            this.scope = builder.scope;
        }

        public void setScope(CsmScope scope) {
            this.scope = scope;
        }

        public void setParent(CsmObjectBuilder parent) {
            this.parent = parent;
        }

        public CsmObjectBuilder getParent() {
            return this.parent;
        }

        public CsmScope getScope() {
            if (this.scope != null) {
                return this.scope;
            }
            this.scope = this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder ? ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).getNamespace() : (NamespaceImpl)this.getFile().getProject().getGlobalNamespace();
            return this.scope;
        }

        protected void addDeclaration(CsmOffsetableDeclaration decl) {
            if (this.parent != null) {
                if (this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                    ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).addDeclaration(decl);
                }
            } else {
                this.getFileContent().addDeclaration(decl);
            }
            if (this.getScope() instanceof CsmNamespace) {
                ((NamespaceImpl)this.getScope()).addDeclaration(decl);
            }
        }

        public boolean isGlobal() {
            return this.global && !(this.scope instanceof CompoundStatementImpl);
        }

        public void setLocal() {
            this.global = false;
        }

        @Override
        public CharSequence getName() {
            String[] split = super.getName().toString().split("::");
            return NameCache.getManager().getString((CharSequence)split[split.length - 1]);
        }

        public CharSequence[] getScopeNames() {
            if (super.getName() != null) {
                String[] split = super.getName().toString().split("::");
                CharSequence[] res = new CharSequence[split.length - 1];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = NameCache.getManager().getString((CharSequence)split[i]);
                }
                return res;
            }
            return new CharSequence[0];
        }

        @Override
        public String toString() {
            return "{global=" + this.global + ", scope=" + this.scope + super.toString() + '}';
        }
    }
}

