/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ConditionExpressionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.DeepUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public final class IfStatementImpl
extends StatementBase
implements CsmIfStatement {
    private CsmCondition condition;
    private CsmStatement thenStmt;
    private CsmStatement elseStmt;

    private IfStatementImpl(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file, scope);
    }

    private IfStatementImpl(CsmScope scope, CsmFile file, int start, int end) {
        super(file, start, end, scope);
    }

    public static IfStatementImpl create(AST ast, CsmFile file, CsmScope scope) {
        IfStatementImpl stmt = new IfStatementImpl(ast, file, scope);
        stmt.init(ast);
        return stmt;
    }

    private void init(AST ast) {
        this.render(ast);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.IF;
    }

    public CsmCondition getCondition() {
        return this.condition;
    }

    public CsmStatement getThen() {
        return this.thenStmt;
    }

    public CsmStatement getElse() {
        return this.elseStmt;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.condition instanceof Disposable) {
            ((Disposable)this.condition).dispose();
        }
        if (this.thenStmt instanceof Disposable) {
            ((Disposable)this.thenStmt).dispose();
        }
        if (this.elseStmt instanceof Disposable) {
            ((Disposable)this.elseStmt).dispose();
        }
    }

    private void render(AST ast) {
        AstRenderer renderer = new AstRenderer((FileImpl)this.getContainingFile());
        boolean inElse = false;
        block4: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 599: {
                    this.condition = renderer.renderCondition(token, (CsmScope)this);
                    continue block4;
                }
                case 171: {
                    inElse = true;
                    continue block4;
                }
                default: {
                    StatementBase stmt = AstRenderer.renderStatement(token, this.getContainingFile(), (CsmScope)this);
                    if (stmt == null) continue block4;
                    if (inElse) {
                        this.elseStmt = stmt;
                        continue block4;
                    }
                    this.thenStmt = stmt;
                }
            }
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return DeepUtil.merge(this.getCondition(), this.getThen(), this.getElse());
    }

    public static class IfStatementBuilder
    extends StatementBase.StatementBuilder
    implements StatementBase.StatementBuilderContainer {
        ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration;
        ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression;
        StatementBase.StatementBuilder thenStatement;
        StatementBase.StatementBuilder elseStatement;

        public void setThenStatement(StatementBase.StatementBuilder thenStatement) {
            this.thenStatement = thenStatement;
        }

        public void setElseStatement(StatementBase.StatementBuilder elseStatement) {
            this.elseStatement = elseStatement;
        }

        public void setConditionExpression(ConditionExpressionImpl.ConditionExpressionBuilder conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public void setConditionDeclaration(ConditionDeclarationImpl.ConditionDeclarationBuilder conditionDeclaration) {
            this.conditionDeclaration = conditionDeclaration;
        }

        @Override
        public IfStatementImpl create() {
            IfStatementImpl stmt = new IfStatementImpl(this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            if (this.thenStatement != null) {
                this.thenStatement.setScope((CsmScope)stmt);
                stmt.thenStmt = this.thenStatement.create();
            }
            if (this.conditionDeclaration != null) {
                this.conditionDeclaration.setScope((CsmScope)stmt);
                stmt.condition = this.conditionDeclaration.create();
            } else if (this.conditionExpression != null) {
                this.conditionExpression.setScope((CsmScope)stmt);
                stmt.condition = this.conditionExpression.create();
            }
            if (this.elseStatement != null) {
                this.elseStatement.setScope((CsmScope)stmt);
                stmt.elseStmt = this.elseStatement.create();
            }
            return stmt;
        }

        @Override
        public void addStatementBuilder(StatementBase.StatementBuilder builder) {
            if (this.thenStatement == null) {
                this.thenStatement = builder;
            } else {
                this.elseStatement = builder;
            }
        }
    }
}

