/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmOverloadingResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.impl.services.evaluator.VariableProvider;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.parser.OffsetableAST;
import org.netbeans.modules.cnd.spi.model.services.CsmSymbolResolverImplementation;
import org.openide.util.CharSequences;

public class CsmSymbolResolverImpl
implements CsmSymbolResolverImplementation {
    private static final String LT = "<";
    private static final String GT = ">";
    private static final Logger LOG = Logger.getLogger(VariableProvider.class.getSimpleName());

    public Collection<CsmOffsetable> resolveSymbol(NativeProject project, CharSequence declText) {
        CsmProject cndProject = CsmModelAccessor.getModel().getProject((Object)project);
        if (cndProject != null) {
            cndProject.waitParse();
            return this.resolveSymbol(cndProject, declText);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetable> resolveSymbol(CsmProject project, CharSequence declText) {
        try {
            CsmCacheManager.enter();
            AST ast = CsmSymbolResolverImpl.tryParseQualifiedId(declText);
            if (ast != null) {
                Collection<CsmOffsetable> collection = this.resolveQualifiedId(project, ast);
                return collection;
            }
            ast = CsmSymbolResolverImpl.tryParseFunctionSignature(declText);
            if (ast != null) {
                Collection<CsmOffsetable> collection = this.resolveFunction(project, ast, false);
                return collection;
            }
            ast = CsmSymbolResolverImpl.tryParseDeclaration(declText);
            if (ast != null) {
                switch (ast.getType()) {
                    case 518: 
                    case 519: 
                    case 521: {
                        Collection<CsmOffsetable> collection = this.resolveFunction(project, ast, true);
                        return collection;
                    }
                    case 523: {
                        Collection<CsmOffsetable> collection = this.resolveFunction(project, ast, true);
                        return collection;
                    }
                    case 529: {
                        if (!AstRenderer.isClassSpecialization(ast) && !AstRenderer.isClassExplicitInstantiation(ast)) {
                            Collection<CsmOffsetable> collection = this.resolveFunction(project, ast, true);
                            return collection;
                        }
                        List<CsmOffsetable> list = Collections.emptyList();
                        return list;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
        finally {
            CsmCacheManager.leave();
        }
        return Collections.emptyList();
    }

    private Collection<CsmOffsetable> resolveFunction(CsmProject project, AST ast, boolean template) {
        AST funNameAst = AstUtil.findMethodName(ast);
        if (funNameAst != null) {
            CharSequence[] qualifiedName = AstRenderer.renderQualifiedId(funNameAst, null, true);
            ArrayList<CsmObject> resolvedContext = new ArrayList<CsmObject>();
            this.resolveContext(project, qualifiedName, resolvedContext);
            ArrayList candidates = new ArrayList();
            CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_INSTANTIATION}), CsmSelect.getFilterBuilder().createNameFilter(CsmSymbolResolverImpl.hasTemplateSuffix(qualifiedName[qualifiedName.length - 1]) ? CsmSymbolResolverImpl.trimTemplateSuffix(qualifiedName[qualifiedName.length - 1]) : qualifiedName[qualifiedName.length - 1], true, true, false));
            FunctionsAcceptor acceptor = FunctionsAcceptor.INSTANCE;
            for (CsmObject context : resolvedContext) {
                if (CsmKindUtilities.isNamespace((Object)context)) {
                    CsmNamespace ns = (CsmNamespace)context;
                    Iterator iter = CsmSelect.getDeclarations((CsmNamespace)ns, (CsmSelect.CsmFilter)filter);
                    CsmSymbolResolverImpl.fillFromDecls(candidates, iter, (DeclarationAcceptor)acceptor);
                    continue;
                }
                if (!CsmKindUtilities.isClass((CsmObject)context)) continue;
                CsmClass cls = (CsmClass)context;
                CsmSymbolResolverImpl.fillFromDecls(candidates, CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter), (DeclarationAcceptor)acceptor);
            }
            return CsmSymbolResolverImpl.fillFromDecls(this.filterFunctions(ast, funNameAst, candidates.iterator()), null);
        }
        return Collections.emptyList();
    }

    private Collection<CsmOffsetable> resolveQualifiedId(CsmProject project, AST qualNameNode) {
        CharSequence[] qualifiedId = AstRenderer.renderQualifiedId(qualNameNode, null, true);
        ArrayList<CsmObject> resolvedContext = new ArrayList<CsmObject>();
        this.resolveContext(project, qualifiedId, resolvedContext);
        ArrayList<CsmOffsetable> candidates = new ArrayList<CsmOffsetable>();
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_INSTANTIATION, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TYPEALIAS}), CsmSelect.getFilterBuilder().createNameFilter(qualifiedId[qualifiedId.length - 1], true, true, false));
        for (CsmObject context : resolvedContext) {
            if (CsmKindUtilities.isNamespace((Object)context)) {
                CsmNamespace ns = (CsmNamespace)context;
                CsmSymbolResolverImpl.fillFromDecls(candidates, CsmSelect.getDeclarations((CsmNamespace)ns, (CsmSelect.CsmFilter)filter), null);
                continue;
            }
            if (!CsmKindUtilities.isClass((CsmObject)context)) continue;
            CsmClass cls = (CsmClass)context;
            CsmSymbolResolverImpl.fillFromDecls(candidates, CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter), null);
        }
        return candidates;
    }

    private Collection<CsmFunction> filterFunctions(AST funAst, AST funNameAst, Iterator<CsmFunction> candidates) {
        if (candidates.hasNext()) {
            Collection<AST> paramsAsts = this.getFunctionParamsAsts(funAst, funNameAst);
            List<CsmFunction> filteredByParamNumber = this.filterFunctionsByParamNumber(paramsAsts, candidates);
            return this.filterFunctionsByParamTypes(paramsAsts, filteredByParamNumber);
        }
        return Collections.emptyList();
    }

    private List<CsmFunction> filterFunctionsByParamNumber(Collection<AST> paramsAsts, Iterator<CsmFunction> candidates) {
        ArrayList<CsmFunction> filteredByParamNumber = new ArrayList<CsmFunction>();
        while (candidates.hasNext()) {
            CsmFunction candidate = candidates.next();
            if (candidate.getParameters().size() != paramsAsts.size()) continue;
            filteredByParamNumber.add(candidate);
        }
        return filteredByParamNumber;
    }

    private Collection<CsmFunction> filterFunctionsByParamTypes(Collection<AST> paramsAsts, Collection<CsmFunction> candidates) {
        IdentityHashMap<CsmFunction, List<CsmType>> paramsPerFunction = new IdentityHashMap<CsmFunction, List<CsmType>>();
        for (CsmFunction candidate : candidates) {
            List<CsmType> parameters = this.createFunctionParams(paramsAsts, candidate);
            paramsPerFunction.put(candidate, parameters);
        }
        return CsmOverloadingResolver.resolveOverloading(candidates, null, paramsPerFunction);
    }

    private Collection<AST> getFunctionParamsAsts(AST targetFunAst, AST targetFunNameAst) {
        AST params;
        AST lparen = AstUtil.findSiblingOfType(targetFunNameAst, 12);
        AST rparen = AstUtil.findSiblingOfType(lparen, 13);
        for (params = lparen; params != rparen && 554 != params.getType(); params = params.getNextSibling()) {
        }
        if (554 == params.getType()) {
            ArrayList<AST> parameters = new ArrayList<AST>();
            for (AST paramAst = params.getFirstChild(); paramAst != null; paramAst = paramAst.getNextSibling()) {
                if (525 != paramAst.getType()) continue;
                parameters.add(paramAst);
            }
            return parameters;
        }
        return Collections.emptyList();
    }

    private List<CsmType> createFunctionParams(Collection<AST> targetFunParamsAsts, CsmFunction context) {
        ArrayList<CsmType> params = new ArrayList<CsmType>();
        for (AST paramAst : targetFunParamsAsts) {
            AST typeAst;
            AST paramTypeStart;
            if (paramAst == null) continue;
            for (paramTypeStart = paramAst.getFirstChild(); paramTypeStart != null && !AstUtil.isTypeNode(paramTypeStart) && !AstRenderer.isQualifier(paramTypeStart.getType()); paramTypeStart = paramTypeStart.getNextSibling()) {
            }
            if (paramTypeStart != null && AstRenderer.isQualifier(paramTypeStart.getType()) && !AstUtil.isTypeNode(typeAst = AstRenderer.getFirstSiblingSkipQualifiers(paramTypeStart))) {
                paramTypeStart = null;
            }
            if (paramTypeStart == null) continue;
            AST ptrOperator = AstUtil.findSiblingOfType(paramTypeStart, 595);
            TypeImpl type = TypeFactory.createType(paramTypeStart, context.getContainingFile(), ptrOperator, 0, context.getScope());
            params.add(type);
        }
        return params;
    }

    private void resolveContext(CsmProject project, CharSequence[] qualifiedName, Collection<CsmObject> result) {
        CharSequence[] cnn = qualifiedName;
        if (cnn != null) {
            if (cnn.length > 1) {
                this.resolveContext(project.getGlobalNamespace(), qualifiedName, 0, result);
            } else if (cnn.length == 1) {
                result.add((CsmObject)project.getGlobalNamespace());
            }
        }
    }

    private void resolveContext(CsmNamespace context, CharSequence[] qualifiedName, int current, Collection<CsmObject> result) {
        CharSequence[] cnn = qualifiedName;
        if (current >= cnn.length - 1) {
            result.add((CsmObject)context);
            return;
        }
        CsmSelect.CsmFilter filter = CsmSymbolResolverImpl.createNamespaceFilter(qualifiedName[current]);
        Iterator decls = CsmSelect.getDeclarations((CsmNamespace)context, (CsmSelect.CsmFilter)filter);
        if (!decls.hasNext() && CsmSymbolResolverImpl.hasTemplateSuffix(qualifiedName[current])) {
            filter = CsmSymbolResolverImpl.createNamespaceFilter(CsmSymbolResolverImpl.trimTemplateSuffix(qualifiedName[current]));
            decls = CsmSelect.getDeclarations((CsmNamespace)context, (CsmSelect.CsmFilter)filter);
        }
        this.handleNamespaceDecls(decls, cnn, current, result);
        if (!CsmSymbolResolverImpl.hasTemplateSuffix(qualifiedName[current])) {
            HashSet<CsmNamespace> handledNamespaces = new HashSet<CsmNamespace>();
            for (CsmNamespace nested : context.getNestedNamespaces()) {
                if (handledNamespaces.contains(nested)) continue;
                handledNamespaces.add(nested);
                if (!qualifiedName[current].toString().equals(nested.getName().toString())) continue;
                this.resolveContext(nested, qualifiedName, current + 1, result);
            }
        }
    }

    private void resolveContext(CsmClass context, CharSequence[] qualifiedName, int current, Collection<CsmObject> result) {
        CharSequence[] cnn = qualifiedName;
        if (current >= cnn.length - 1) {
            result.add((CsmObject)context);
            return;
        }
        CsmSelect.CsmFilter filter = CsmSymbolResolverImpl.createClassFilter(qualifiedName[current]);
        Iterator decls = CsmSelect.getClassMembers((CsmClass)context, (CsmSelect.CsmFilter)filter);
        if (!decls.hasNext() && CsmSymbolResolverImpl.hasTemplateSuffix(qualifiedName[current])) {
            filter = CsmSymbolResolverImpl.createClassFilter(CsmSymbolResolverImpl.trimTemplateSuffix(qualifiedName[current]));
            decls = CsmSelect.getClassMembers((CsmClass)context, (CsmSelect.CsmFilter)filter);
        }
        this.handleClassDecls(decls, cnn, current, result);
    }

    private void handleNamespaceDecls(Iterator<CsmOffsetableDeclaration> decls, CharSequence[] qualifiedName, int current, Collection<CsmObject> result) {
        HashSet<CsmNamespace> handledNamespaces = new HashSet<CsmNamespace>();
        while (decls.hasNext()) {
            CsmTypedef typedef;
            CsmClassifier cls;
            CsmOffsetableDeclaration decl = decls.next();
            if (CsmKindUtilities.isNamespaceAlias((CsmObject)decl)) {
                CsmNamespace ns = ((CsmNamespaceAlias)decl).getReferencedNamespace();
                if (handledNamespaces.contains(ns)) continue;
                handledNamespaces.add(ns);
                this.resolveContext(ns, qualifiedName, current + 1, result);
                continue;
            }
            if (CsmKindUtilities.isClass((CsmObject)decl)) {
                this.resolveContext((CsmClass)decl, qualifiedName, current + 1, result);
                continue;
            }
            if (!CsmKindUtilities.isTypedefOrTypeAlias((CsmObject)decl) || !CsmKindUtilities.isClass((CsmObject)(cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)(typedef = (CsmTypedef)decl), (CsmFile)typedef.getContainingFile())))) continue;
            this.resolveContext((CsmClass)cls, qualifiedName, current + 1, result);
        }
    }

    private void handleClassDecls(Iterator<CsmMember> decls, CharSequence[] qualifiedName, int current, Collection<CsmObject> result) {
        while (decls.hasNext()) {
            CsmTypedef typedef;
            CsmClassifier cls;
            CsmMember member = decls.next();
            if (CsmKindUtilities.isClass((CsmObject)member)) {
                this.resolveContext((CsmClass)member, qualifiedName, current + 1, result);
                continue;
            }
            if (!CsmKindUtilities.isTypedefOrTypeAlias((CsmObject)member) || !CsmKindUtilities.isClass((CsmObject)(cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)(typedef = (CsmTypedef)member), (CsmFile)typedef.getContainingFile())))) continue;
            this.resolveContext((CsmClass)cls, qualifiedName, current + 1, result);
        }
    }

    private static <T extends CsmOffsetable> List<T> fillFromDecls(Iterable<? extends CsmObject> decls, DeclarationAcceptor acceptor) {
        return CsmSymbolResolverImpl.fillFromDecls(decls.iterator(), acceptor);
    }

    private static <T extends CsmOffsetable> List<T> fillFromDecls(Iterator<? extends CsmObject> decls, DeclarationAcceptor acceptor) {
        ArrayList<CsmOffsetable> result = new ArrayList<CsmOffsetable>();
        while (decls.hasNext()) {
            CsmObject decl = decls.next();
            if (acceptor != null && !acceptor.accept(decl)) continue;
            result.add((CsmOffsetable)decl);
        }
        return result;
    }

    private static <T extends CsmOffsetable> void fillFromDecls(List<T> list, Iterable<? extends CsmObject> decls, DeclarationAcceptor acceptor) {
        CsmSymbolResolverImpl.fillFromDecls(list, decls.iterator(), acceptor);
    }

    private static <T extends CsmOffsetable> void fillFromDecls(List<T> list, Iterator<? extends CsmObject> decls, DeclarationAcceptor acceptor) {
        while (decls.hasNext()) {
            CsmObject decl = decls.next();
            if (acceptor != null && !acceptor.accept(decl)) continue;
            list.add((CsmOffsetable)decl);
        }
    }

    private static AST tryParseQualifiedId(CharSequence sequence) {
        String trimmedSequence = sequence.toString().trim();
        CPPParserEx parser = CsmSymbolResolverImpl.createParser(trimmedSequence);
        if (parser != null) {
            OffsetableAST offsetableAst;
            AST lastChild;
            parser.qualified_id();
            if (!parser.matchError && parser.getAST() != null && (lastChild = AstUtil.getLastNonEOFChildRecursively(parser.getAST())) instanceof OffsetableAST && (offsetableAst = (OffsetableAST)lastChild).getEndOffset() == trimmedSequence.length()) {
                return parser.getAST();
            }
        }
        return null;
    }

    private static AST tryParseFunctionSignature(CharSequence sequence) {
        String trimmedSequence = sequence.toString().trim();
        CPPParserEx parser = CsmSymbolResolverImpl.createParser(trimmedSequence);
        if (parser != null) {
            parser.function_declarator(false, false, false);
            if (!parser.matchError && parser.getAST() != null) {
                OffsetableAST offsetableAst;
                FakeAST signatureAst = new FakeAST();
                signatureAst.setType(518);
                signatureAst.addChild(parser.getAST());
                AST lastChild = AstUtil.getLastNonEOFChildRecursively((AST)signatureAst);
                if (lastChild instanceof OffsetableAST && (offsetableAst = (OffsetableAST)lastChild).getEndOffset() == trimmedSequence.length()) {
                    return signatureAst;
                }
            }
        }
        return null;
    }

    private static AST tryParseDeclaration(CharSequence sequence) {
        CPPParserEx parser = CsmSymbolResolverImpl.createParser(sequence);
        if (parser != null) {
            parser.external_declaration();
            if (!parser.matchError) {
                return parser.getAST();
            }
        }
        return null;
    }

    private static CPPParserEx createParser(CharSequence sequence) {
        TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)sequence.toString(), (String)"Gnu C++ Language");
        if (ts != null) {
            int flags = 8;
            APTLanguageFilter langFilter = APTLanguageSupport.getInstance().getFilter("Gnu C++ Language", "");
            return CPPParserEx.getInstance("In_memory_parse", langFilter.getFilteredStream(ts), flags |= 4);
        }
        return null;
    }

    private static String concat(CharSequence[] charSequences, CharSequence separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CharSequence cs : charSequences) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(cs);
        }
        return sb.toString();
    }

    private static boolean hasTemplateSuffix(CharSequence qualNamePart) {
        return CharSequences.indexOf((CharSequence)qualNamePart, (CharSequence)GT) > CharSequences.indexOf((CharSequence)qualNamePart, (CharSequence)LT);
    }

    private static CharSequence trimTemplateSuffix(CharSequence qualNamePart) {
        return qualNamePart.subSequence(0, CharSequences.indexOf((CharSequence)qualNamePart, (CharSequence)LT));
    }

    private static CsmSelect.CsmFilter createNamespaceFilter(CharSequence qualNamePart) {
        return CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT}), CsmSelect.getFilterBuilder().createNameFilter(qualNamePart, true, true, false));
    }

    private static CsmSelect.CsmFilter createClassFilter(CharSequence qualNamePart) {
        return CsmSelect.getFilterBuilder().createCompoundFilter(CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT}), CsmSelect.getFilterBuilder().createNameFilter(qualNamePart, true, true, false));
    }

    private static void printAST(AST ast) {
        StringBuilder sb = new StringBuilder();
        CsmSymbolResolverImpl.printAST(sb, ast, 0);
        System.out.println(sb.toString());
    }

    private static void printAST(StringBuilder sb, AST ast, int level) {
        if (ast != null) {
            CsmSymbolResolverImpl.repeat(sb, ' ', level * 2);
            sb.append(ast.getText()).append('\n');
            CsmSymbolResolverImpl.printAST(sb, ast.getFirstChild(), level + 1);
            CsmSymbolResolverImpl.printAST(sb, ast.getNextSibling(), level);
        }
    }

    private static void repeat(StringBuilder sb, char character, int times) {
        while (--times >= 0) {
            sb.append(character);
        }
    }

    private static class NonTemplateFunctionsAcceptor
    extends FunctionsAcceptor {
        public static final NonTemplateFunctionsAcceptor INSTANCE = new NonTemplateFunctionsAcceptor();

        private NonTemplateFunctionsAcceptor() {
        }

        @Override
        public boolean accept(CsmObject decl) {
            return super.accept(decl) && !TemplateFunctionsAcceptor.INSTANCE.accept(decl);
        }
    }

    private static class TemplateFunctionsAcceptor
    extends FunctionsAcceptor {
        public static final TemplateFunctionsAcceptor INSTANCE = new TemplateFunctionsAcceptor();

        private TemplateFunctionsAcceptor() {
        }

        @Override
        public boolean accept(CsmObject decl) {
            return super.accept(decl) && decl instanceof CsmTemplate && ((CsmTemplate)decl).isTemplate();
        }
    }

    private static class FunctionsAcceptor
    implements DeclarationAcceptor {
        public static final FunctionsAcceptor INSTANCE = new FunctionsAcceptor();

        private FunctionsAcceptor() {
        }

        @Override
        public boolean accept(CsmObject decl) {
            return decl instanceof CsmFunction;
        }
    }

    private static interface DeclarationAcceptor {
        public boolean accept(CsmObject var1);
    }
}

