/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.util.MapHierarchy;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class VariableProvider {
    private static final Logger LOG = Logger.getLogger(VariableProvider.class.getSimpleName());
    public static final int INFINITE_RECURSION = 16;
    private final int level;
    private final CsmScope scope;
    private CsmOffsetableDeclaration decl;
    private MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping;
    private CsmFile variableFile;
    private int variableStartOffset;
    private int variableEndOffset;
    private static final Pattern intrisicOneArgFunCall = Pattern.compile("([\\w_]+)\\(([\\w_]+)\\)");

    public VariableProvider(int level, CsmScope scope) {
        this.level = level;
        this.scope = scope;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "\nVARIABLE PROVIDER CREATED WITHOUT MAP HIERARCHY\n");
        }
    }

    public VariableProvider(CsmOffsetableDeclaration decl, CsmScope scope, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping, CsmFile variableFile, int variableStartOffset, int variableEndOffset, int level) {
        this.decl = decl;
        this.scope = scope;
        this.mapping = mapping;
        this.variableFile = variableFile != null ? variableFile : (decl != null ? decl.getContainingFile() : null);
        this.variableStartOffset = variableStartOffset;
        this.variableEndOffset = variableEndOffset;
        this.level = level;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "\nVARIABLE PROVIDER CREATED WITH MAP HIERARCHY:\n{0}\n", mapping);
        }
    }

    /*
     * Exception decompiling
     */
    public int getValue(String variableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getFunCallValue(String funCall) {
        if (funCall != null) {
            if (funCall.startsWith(CppTokenId.__IS_CLASS.fixedText())) {
                CsmType type = this.resolveIntrisicTypeTraceFunParam(CppTokenId.__IS_CLASS.fixedText(), funCall);
                return type != null && CsmKindUtilities.isClass((CsmObject)type.getClassifier()) ? 1 : 0;
            }
            if (funCall.startsWith(CppTokenId.__IS_ENUM.fixedText())) {
                CsmType type = this.resolveIntrisicTypeTraceFunParam(CppTokenId.__IS_ENUM.fixedText(), funCall);
                return type != null && CsmKindUtilities.isEnum((CsmObject)type.getClassifier()) ? 1 : 0;
            }
            if (funCall.startsWith(CppTokenId.__IS_UNION.fixedText())) {
                CsmType type = this.resolveIntrisicTypeTraceFunParam(CppTokenId.__IS_UNION.fixedText(), funCall);
                return type != null && CsmKindUtilities.isUnion((CsmObject)type.getClassifier()) ? 1 : 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getSizeOfValue(String obj) {
        CsmScope objScope;
        ArrayList<CsmInstantiation> instantiations = null;
        if (CsmKindUtilities.isInstantiation((CsmObject)this.decl)) {
            instantiations = new ArrayList<CsmInstantiation>();
            CsmInstantiation inst = (CsmInstantiation)this.decl;
            instantiations.add(inst);
            while (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
                inst = (CsmInstantiation)inst.getTemplateDeclaration();
                instantiations.add(inst);
            }
        } else if (CsmKindUtilities.isTemplate((CsmObject)this.decl) && !this.mapping.isEmpty()) {
            List<Map<CsmTemplateParameter, CsmSpecializationParameter>> maps = this.mapping.getMaps(new MapHierarchy.NonEmptyFilter());
            InstantiationProviderImpl ip = (InstantiationProviderImpl)InstantiationProviderImpl.getDefault();
            CsmOffsetableDeclaration instantiation = this.decl;
            instantiations = new ArrayList();
            for (int i = maps.size() - 1; i >= 0; --i) {
                instantiation = ip.instantiate((CsmTemplate)instantiation, this.variableFile, this.variableStartOffset, maps.get(i), false);
                instantiations.add(0, (CsmInstantiation)instantiation);
            }
        }
        if ((objScope = this.scope) == null && CsmKindUtilities.isScope((CsmObject)this.decl)) {
            objScope = (CsmScope)this.decl;
        }
        CsmType objType = CsmExpressionResolver.resolveType((CharSequence)obj, (CsmFile)this.variableFile, (int)this.variableEndOffset, (CsmScope)objScope, instantiations);
        objType = CsmExpressionResolver.resolveMacroType((CsmType)objType, (CsmScope)objScope, instantiations, null);
        return Utils.getSizeOfType(objType, this.variableFile);
    }

    private CsmType resolveIntrisicTypeTraceFunParam(String suggestedFunName, String funCall) {
        String paramName;
        CsmSpecializationParameter resolvedParam;
        Matcher matcher = intrisicOneArgFunCall.matcher(funCall);
        if (matcher.matches() && matcher.groupCount() >= 2 && suggestedFunName.equals(matcher.group(1)) && CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)(resolvedParam = this.resolveTemplateParameter(paramName = matcher.group(2))))) {
            CsmType type = ((CsmTypeBasedSpecializationParameter)resolvedParam).getType();
            return CsmUtilities.iterateTypeChain((CsmType)type, (CsmUtilities.Predicate)new CsmUtilities.ConstantPredicate(false));
        }
        return null;
    }

    private CsmSpecializationParameter resolveTemplateParameter(String variableName) {
        if (this.decl != null) {
            String scopeQualifiedName = CsmKindUtilities.isQualified((CsmObject)this.scope) ? ((CsmQualifiedNamedElement)this.scope).getQualifiedName().toString() : this.decl.getQualifiedName().toString();
            String fullVariableName = scopeQualifiedName + "::" + variableName;
            for (Map.Entry<CsmTemplateParameter, CsmSpecializationParameter> entry : this.mapping.entries()) {
                CsmType paramType;
                CsmTemplateParameter param = entry.getKey();
                if (!variableName.equals(param.getQualifiedName().toString()) && !fullVariableName.equals(param.getQualifiedName().toString())) continue;
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)((CsmObject)entry.getValue())) && CsmKindUtilities.isTemplateParameterType((CsmObject)(paramType = ((CsmTypeBasedSpecializationParameter)entry.getValue()).getType()))) {
                    return this.resolveTemplateParameter(((CsmTemplateParameterType)paramType).getParameter());
                }
                return entry.getValue();
            }
        }
        return null;
    }

    private CsmSpecializationParameter resolveTemplateParameter(CsmTemplateParameter param) {
        CsmSpecializationParameter nextInstParam;
        CsmSpecializationParameter instParam = this.mapping.get(param);
        for (int iteration = 15; CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)instParam).getType()) && iteration != 0 && (nextInstParam = this.mapping.get(((CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instParam).getType()).getParameter())) != null; --iteration) {
            instParam = nextInstParam;
        }
        return instParam;
    }

    private CsmType instantiateType(CsmType type, CsmInstantiation inst) {
        if (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
            type = this.instantiateType(type, (CsmInstantiation)inst.getTemplateDeclaration());
        }
        return Instantiation.createType(type, inst);
    }

    private CsmType checkTemplateType(CsmType type, CsmInstantiation inst) {
        if (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
            type = this.checkTemplateType(type, (Instantiation)inst.getTemplateDeclaration());
        }
        for (CsmTemplateParameter csmTemplateParameter : inst.getMapping().keySet()) {
            type = TemplateUtils.checkTemplateType(type, (CsmObject)csmTemplateParameter.getScope());
        }
        return type;
    }

    private MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> getMapping(CsmInstantiation inst) {
        MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping2 = new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(inst.getMapping());
        while (CsmKindUtilities.isInstantiation((CsmObject)inst.getTemplateDeclaration())) {
            inst = (CsmInstantiation)inst.getTemplateDeclaration();
            mapping2.push(inst.getMapping());
        }
        return mapping2;
    }

    public String toString() {
        return "VariableProvider{level=" + this.level + ", decl=" + this.decl + ", mapping=" + this.mapping + ", variableFile=" + this.variableFile + ", variableStartOffset=" + this.variableStartOffset + ", variableEndOffset=" + this.variableEndOffset + '}';
    }
}

