/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.WeakSet;

public class KeyManager {
    private final KeyStorage storage;
    private static final int KEY_MANAGER_DEFAULT_CAPACITY;
    private static final int KEY_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final KeyManager instance;
    private final Object lock = new Lock();

    private KeyManager() {
        this.storage = new KeyStorage(KEY_MANAGER_DEFAULT_SLICED_NUMBER, KEY_MANAGER_DEFAULT_CAPACITY);
    }

    public static KeyManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Key getSharedKey(Key key) {
        if (key == null) {
            throw new NullPointerException("null string is illegal to share");
        }
        Key outKey = null;
        Object object = this.lock;
        synchronized (object) {
            outKey = this.storage.getShared(key);
        }
        assert (outKey != null);
        assert (outKey.equals(key));
        return outKey;
    }

    public final void dispose() {
        this.storage.dispose();
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            KEY_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            KEY_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            KEY_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            KEY_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = new KeyManager();
    }

    private static final class KeyStorage {
        private final WeakSet<Key>[] instances;
        private final int segmentMask;
        private final int initialCapacity;

        private KeyStorage(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            this.initialCapacity = initialCapacity;
            WeakSet[] ar = new WeakSet[ssize];
            for (int i = 0; i < ar.length; ++i) {
                ar[i] = new WeakSet(initialCapacity);
            }
            this.instances = ar;
        }

        private WeakSet<Key> getDelegate(Key key) {
            int index = key.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        public final Key getShared(Key key) {
            Key out = (Key)this.getDelegate(key).putIfAbsent((Object)key);
            return out;
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    Object[] arr = this.instances[i].toArray();
                    System.out.println("Key cache " + this.instances[i].size());
                    HashMap classes = new HashMap();
                    for (Object o : arr) {
                        if (o == null) continue;
                        Integer num = (Integer)classes.get(o.getClass());
                        num = num != null ? new Integer(num + 1) : new Integer(1);
                        classes.put(o.getClass(), num);
                    }
                    for (Map.Entry e : classes.entrySet()) {
                        System.out.println("   " + e.getValue() + " of " + ((Class)e.getKey()).getName());
                    }
                }
                this.instances[i].clear();
                this.instances[i].resize(this.initialCapacity);
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

